#SETUP-----------------------
# Run the setup lines in Master if running as stand-alone
# garbage collection
gc()
# remove all variables except those defining directory and graph theme
rm(list = setdiff(ls(), c(ls()[grep("Dir", ls())], "mytheme")))

#COMPUTE NET TAXES ON DIFFERENT TYPES OF CAPITAL-----------
# OBTAIN INPUTS: RATES, DEPRECIATION, PRICES------------
# Real lending rate from the World Bank
tableR <- setDT(read_csv(paste0(invDir,"/RealInterestRateUSWorldBank.csv")))
colnames(tableR) = c("Year", "r")
tableRFred <- setDT(read_csv(paste0(invDir,"/RatesFred.csv")))
tableRMoody <- setDT(read_csv(paste0(invDir,"/RatesMoodyAAA.csv")))

tableRFred = tableRFred[tableRMoody, on = .(Year = DATE)]

# Inflation expectation is moving average of 5 past years
# tableRFred = tableRFred[, rTAAA := AAA - SMA(shift(Inflation,1))]
# tableRFred = tableRFred[, rT := r10T - SMA(shift(Inflation,1))]
# tableRFred = tableRFred[, rTAAA := AAA - SMA(shift(Inflation,1), n = 5)]
# tableRFred = tableRFred[, rT := r10T - SMA(shift(Inflation,1), n = 5)]

# measure of inflation expectations: 5 years MA of Realized inflation (should be K-N)
# "1" and "0" indicate foresight
tableRFred = tableRFred[, rTAAA1 := (AAA - rollapply(Inflation, 5, mean, na.rm = TRUE, fill = "extend"))/100]
tableRFred = tableRFred[, rT1 := (r10T - rollapply(Inflation, 5, mean, na.rm = TRUE, fill = "extend"))/100]


tableRFred = tableRFred[, rTAAA0 := (AAA - rollapply(Inflation, 1, mean, na.rm = TRUE, fill = "extend"))/100]
tableRFred = tableRFred[, rT0 := (r10T - rollapply(Inflation, 1, mean, na.rm = TRUE, fill = "extend"))/100]

# K-N smooth series, but unclear how
 # tableRFred = tableRFred[, rTAAA := rollapply(rTAAA, 3, mean, na.rm = TRUE, fill = "extend")]
 # tableRFred = tableRFred[, rT := rollapply(rT, 3, mean, na.rm = TRUE, fill = "extend")]
 # tableRFred = tableRFred[, rTAAA := rollapply(rTAAA, 3, mean, na.rm = TRUE, fill = "extend")]
 # tableRFred = tableRFred[, rT := rollapply(rT, 3, mean, na.rm = TRUE, fill = "extend")]
 # 

# Graph the Real interest Rates
ggplot() + geom_line(data = tableRFred , aes(Year, rT1, colour = "10-Year Treasury"), size = 1.3) +
  geom_line(data = tableR, aes(Year,r, colour = "Real Lending Rate"), size = 1.3)+
  geom_line(data = tableRFred, aes(Year,rTAAA1, colour = "10-Year AAA"), size = 1.3)+
  labs(title = "Real Rates with some Foresight", y = "Rate" )+
  scale_color_discrete("")+ mytheme
ggsave(paste0(figureDir, "/Rates_Fore.png"), width = 12, height = 10)

ggplot() + geom_line(data = tableRFred , aes(Year, rT0, colour = "10-Year Treasury"), size = 1.3) +
  geom_line(data = tableR, aes(Year,r, colour = "Real Lending Rate"), size = 1.3)+
  geom_line(data = tableRFred, aes(Year,rTAAA0, colour = "10-Year AAA"), size = 1.3)+
  labs(title = "Real Rates with Myopic Expectations", y = "Rate" )+
  scale_color_discrete("")+ mytheme
ggsave(paste0(figureDir, "/Rates_NoFore.png"), width = 12, height = 10)

tableR = tableR[tableRFred, on = .(Year = Year) ]

# Get quantities and prices of investment

tableInv <- setDT(read_csv(paste0(invDir,"/Table_2_7_INV.csv")))[, Line:= NULL]
tableInv_Q <- setDT(read_csv(paste0(invDir,"/Table_2_8_Chain_Inv_q.csv")))[, Line:= NULL]

# get the chained price index
tableInv = cbind(tableInv[,1], tableInv[,2:ncol(tableInv)]/tableInv_Q[,2:ncol(tableInv)] )

# Reshape to Long
tableInv = melt(tableInv, 
                id.vars = c("Type"),
                measure.vars = colnames(tableInv)[colnames(tableInv) !="Type" & colnames(tableInv) !="Line"],
                variable.name = "Year",
                value.name = "Value")
# Next steps: sort and then take differences using the shift function (see cheatsheet)
tableInv = tableInv[!is.na(Type),]
setkey(tableInv, Type, Year)

# Find type-specific inflation q_t/(q_{t-1})
tableInv = tableInv[, DPrice := Value/shift(Value, n=1, fill = NA), by = Type]

# Import depreciation data
tableDepr <- setDT(read_csv(paste0(invDir,"/Table_2_4_current_cost_depr.csv")))[ , Line:=NULL][!is.na(Type), ]
tableDepr = melt(tableDepr, 
                id.vars = c("Type"),
                measure.vars = colnames(tableDepr)[colnames(tableDepr) !="Type" & colnames(tableDepr) !="Line"],
                variable.name = "Year",
                value.name = "Depreciation")
tableDepr_Q <- setDT(read_csv(paste0(invDir,"/Table_2_1_current_cost_stock.csv")))[ , Line:=NULL][!is.na(Type), ]
tableDepr_Q = melt(tableDepr_Q, 
                 id.vars = c("Type"),
                 measure.vars = colnames(tableDepr_Q)[colnames(tableDepr_Q) !="Type" & colnames(tableDepr_Q) !="Line"],
                 variable.name = "Year",
                 value.name =  "Stock")

tableDepr = tableDepr[tableDepr_Q, on = .(Year = Year, Type = Type)]

# compute depreciation: remember that Depr_Q is end-of-year estimates so the lag is needed
setDT(tableDepr)
setkey(tableDepr, Type, Year)
# lag stock to have year start
tableDepr = tableDepr[, Stock := shift(Stock, n=1, fill = NA ), by = Type]
tableDepr = tableDepr[, delta := Depreciation/Stock, by = Type]

# Keep only detailed category to avoid double counting when aggregating at other levels
tableCategories =  setDT(read_csv(paste0(rawDir,"/INV_TYPE.csv")))[!is.na(DetCategory), ][, c(1:4)]
colnames(tableCategories) = c("Type", colnames(tableCategories)[2: ncol((tableCategories))] )

tableDeprCat =  tableDepr[tableCategories, on = .(Type = Type)]
#Unmatched is only master categories
# tableDeprUnm =  tableDepr[!tableCategories, on = .(Type = Type)]

# Get aggregates at different levels
tableDeprCat =  tableDeprCat[, deltaDetCat := sum(Depreciation)/sum(Stock),
                             by = c("Year", "DetCategory") ]
tableDeprCat =  tableDeprCat[, deltaSubCat := sum(Depreciation)/sum(Stock),
                             by = c("Year", "Subcategory") ]
tableDeprCat =  tableDeprCat[, deltaCat := sum(Depreciation)/sum(Stock),
                             by = c("Year", "Category") ]

# Extract category names
CategoryNames = unique(tableCategories$Category)
SubCategoryNames = unique(tableCategories$Subcategory)
DetCategoryNames = unique(tableCategories$DetCategory)

# Do the same with table Inv: here we need to recover the qggregate directly as we only have quantity indexes
tableInvCat = tableInv[Type %in% CategoryNames, DPriceCat := DPrice, by = Type]
tableInvCat = tableInvCat[Type %in% SubCategoryNames, DPriceSubCat := DPrice, by = Type]
tableCategories =  setDT(read_csv(paste0(rawDir,"/INV_TYPE.csv")))[, c(1:4)]
colnames(tableCategories) = c("Type", colnames(tableCategories)[2: ncol((tableCategories))] )
tableInvCat =  tableInvCat[tableCategories, on = .(Type = Type)]


# Spread out the aggregates to the whole dataset
tableInvCat = tableInvCat[, DPriceCat := sum(DPriceCat, na.rm = TRUE), by = c("Year","Category")]
tableInvCat = tableInvCat[, DPriceSubCat := sum(DPriceSubCat, na.rm = TRUE), by = c("Year","Subcategory")]
tableDetCat = unique(tableInvCat[Type %in% DetCategoryNames, c("Year", "Type", "DPrice")])
tableDetCat[, DPriceDetCat := DPrice ]
tableDetCat[, DPrice := NULL ]
tableInvCat = tableInvCat[tableDetCat, on = .(Year = Year, DetCategory = Type)]


tableInvCat$Year = as.numeric(as.character(tableInvCat$Year))
tableDeprCat$Year = as.numeric(as.character(tableDeprCat$Year))
# Some Graphs
series = c("DPriceSubCat", "DPriceDetCat", "DPriceCat")
nameGroup = c("Subcategory", "DetCategory", "Category")
seriesDelta = c("deltaSubCat", "deltaDetCat", "deltaCat")

for (j in c(1:3)){ 
  ggplot()+
    geom_point(data = unique(tableInvCat[!is.na(get(nameGroup[j])) & Year > 1970,
                                         mget(c("Year", series[j] , nameGroup[j]))]) , 
               aes(x= Year, y=  get(series[j]) - 1, color = get(nameGroup[j])), size = 2)+
    labs(title = paste0("Price Inflation Rate by", nameGroup[j]), y = "Rate")+ 
    scale_x_discrete(breaks = seq(1975,2010,5))+
    theme(plot.title = element_text(hjust = 0.5),legend.position = "bottom")+
    scale_color_discrete("")+ mytheme+guides(colour=guide_legend(nrow=5))
  ggsave(paste0(figureDir, "/Inv_prices_", nameGroup[j], ".png"), width = 12, height = 10)
  
  ggplot()+
    geom_point(data = unique(tableDeprCat[!is.na(get(nameGroup[j])) & Year > 1970,
                                         mget(c("Year", seriesDelta[j] , nameGroup[j]))]) , 
               aes(x= Year, y=  get(seriesDelta[j]), color = get(nameGroup[j])), size = 2)+
    labs(title = paste0("Depreciation Rate by", nameGroup[j]), y = "Rate")+ 
    scale_x_discrete(breaks = seq(1975,2010,5))+
    theme(plot.title = element_text(hjust = 0.5),legend.position = "bottom")+
    scale_color_discrete("")+ mytheme+guides(colour=guide_legend(nrow=5))
  ggsave(paste0(figureDir, "/Depreciation_", nameGroup[j], ".png"), width = 12, height = 10)

}

save(tableR, tableInvCat, tableDeprCat, file = paste0(outDir,"/InvestmentPriceSeries.RData"))
