plot.wedges.ExportData <- function(WedgeSeries, stringType = "Equipment"){
  
  dataEq = unique(WedgeSeries[Type == stringType & Year>1980 & (!is.na(T_C_NET)), 
                                         c("Year", "T_C_NET", "T_S_NET", "T_NC_NET") ])
  
  ggplot(dataEq)+
    geom_line(data = dataEq , 
              aes(x= Year, y=  T_C_NET), size = 2, color="blue" )+
    geom_line(data = dataEq , 
              aes(x= Year, y=  T_S_NET), size = 2, color="forestgreen")+
    geom_line(data = dataEq , 
              aes(x= Year, y=  T_NC_NET), size = 2, color="darkorange")+
    labs( y = paste0("Average net tax rate, ", stringType))+
    annotate(geom="text", x= dataEq$Year[length(dataEq$T_C_NET) ] + 2,
             y= dataEq$T_C_NET[length(dataEq$T_C_NET)] - 0.01,
             label=expression("C-corp"), size=6,
             color="blue")+
    annotate(geom="text", x= dataEq$Year[length(dataEq$T_S_NET) ] + 2,
             y= dataEq$T_S_NET[length(dataEq$T_S_NET)] + 0.01,
             label=expression("S-corp"), size=6,
             color="forestgreen")+
    annotate(geom="text", x= dataEq$Year[length(dataEq$T_NC_NET) ] + 2,
             y= dataEq$T_NC_NET[length(dataEq$T_NC_NET)] - 0.01,
             label= expression("PUE"), size=6,
             color="darkorange")+
    theme_bw()+
    mytheme+
    theme(legend.position ="none" )
  
  
}



plot.wedges.DebtNoDebt <- function(WedgeSeriesNoDebt, WedgeSeriesDebt , stringType = "Equipment"){
  
  dataEq = unique(WedgeSeriesNoDebt[Type == stringType & Year>1980 & (!is.na(T_C_NET)), 
                                           c("Year", "T_C_NET", "T_S_NET", "T_NC_NET") ])
  dataEqDebt = unique(WedgeSeriesDebt[Type == stringType & Year>1980 & (!is.na(T_C_NET_BOND)), 
                                    c("Year", "T_C_NET_BOND", "T_S_NET_BOND", "T_NC_NET_BOND") ])
  
  ggplot(dataEq)+
    geom_line(data = dataEq , 
              aes(x= Year, y=  T_C_NET), size = 2, color="blue" )+
    geom_line(data = dataEq , 
              aes(x= Year, y=  T_S_NET), size = 2, color="forestgreen")+
    geom_line(data = dataEq , 
              aes(x= Year, y=  T_NC_NET), size = 2, color="darkorange")+
    geom_line(data = dataEqDebt , 
              aes(x= Year, y=  T_C_NET_BOND), size = 2, color="blue" , linetype="dashed")+
    geom_line(data = dataEqDebt , 
              aes(x= Year, y=  T_S_NET_BOND), size = 2, color="forestgreen" , linetype="dashed")+
    geom_line(data = dataEqDebt , 
              aes(x= Year, y=  T_NC_NET_BOND), size = 2, color="darkorange" , linetype="dashed")+
    labs( y = paste0("Average net tax rate, ", stringType))+
    annotate(geom="text", x= dataEq$Year[length(dataEq$T_C_NET) ] + 2,
             y= dataEq$T_C_NET[length(dataEq$T_C_NET)] - 0.01,
             label=expression("C-corp"), size=6,
             color="blue")+
    annotate(geom="text", x= dataEq$Year[length(dataEq$T_S_NET) ] + 2,
             y= dataEq$T_S_NET[length(dataEq$T_S_NET)] + 0.01,
             label=expression("S-corp"), size=6,
             color="forestgreen")+
    annotate(geom="text", x= dataEq$Year[length(dataEq$T_NC_NET) ] + 2,
             y= dataEq$T_NC_NET[length(dataEq$T_NC_NET)] - 0.01,
             label= expression("PUE"), size=6,
             color="darkorange")+
    theme_bw()+
    mytheme+
    theme(legend.position ="none" )
  
  
}




plot.wedges.Avg <- function(WedgeSeries , stringType = "Equipment", plotBoth = T, filename = "AvgWedge_equipment"){
  
  dataEq = unique(WedgeSeries[Type == stringType & Year>1980 & (!is.na(T_C_NET)), 
                                    c("Year", "T_C_NET_AVG", "T_S_NET_AVG", "T_NC_NET_AVG") ])
  dataEqNoB = unique(WedgeSeries[Type == stringType & Year>1980 & (!is.na(T_C_NET_BOND)), 
                                      c("Year", "T_C_NET_AVG_NoB", "T_S_NET_AVG_NoB", "T_NC_NET_AVG_NoB") ])
  
  if(plotBoth){
  ggplot(dataEq)+
    geom_line(data = dataEq , 
              aes(x= Year, y=  T_C_NET_AVG), size = 2, color="blue" )+
    geom_line(data = dataEq , 
              aes(x= Year, y=  T_S_NET_AVG), size = 2, color="forestgreen")+
    geom_line(data = dataEq , 
              aes(x= Year, y=  T_NC_NET_AVG), size = 2, color="darkorange")+
    geom_line(data = dataEqNoB , 
              aes(x= Year, y=  T_C_NET_AVG_NoB), size = 2, color="blue" , linetype="dashed")+
    geom_line(data = dataEqNoB , 
              aes(x= Year, y=  T_S_NET_AVG_NoB), size = 2, color="forestgreen" , linetype="dashed")+
    geom_line(data = dataEqNoB , 
              aes(x= Year, y=  T_NC_NET_AVG_NoB), size = 2, color="darkorange" , linetype="dashed")+
    labs( y = paste0("Average net tax rate, ", stringType))+
    annotate(geom="text", x= dataEq$Year[length(dataEq$T_C_NET_AVG) ] + 2,
             y= dataEq$T_C_NET_AVG[length(dataEq$T_C_NET_AVG)] - 0.01,
             label=expression("C-corp"), size=6,
             color="blue")+
    annotate(geom="text", x= dataEq$Year[length(dataEq$T_S_NET_AVG) ] + 2,
             y= dataEq$T_S_NET_AVG[length(dataEq$T_S_NET_AVG)] + 0.01,
             label=expression("S-corp"), size=6,
             color="forestgreen")+
    annotate(geom="text", x= dataEq$Year[length(dataEq$T_NC_NET_AVG) ] + 2,
             y= dataEq$T_NC_NET_AVG[length(dataEq$T_NC_NET_AVG)] - 0.01,
             label= expression("PUE"), size=6,
             color="darkorange")+
    theme_bw()+
    mytheme+
    theme(legend.position ="none" )
    ggsave(paste0(figureDir,"/", filename, ".png"),
           device = "png", width = 16, height = 9)
    
    write.csv(cbind(dataEq, dataEqNoB[, c(-1)]), paste0(dataDir,"/",filename , ".csv"), row.names = FALSE)
  }
  else{
    
    ggplot(dataEq)+
      geom_line(data = dataEq , 
                aes(x= Year, y=  T_C_NET_AVG), size = 2, color="blue" )+
      geom_line(data = dataEq , 
                aes(x= Year, y=  T_S_NET_AVG), size = 2, color="forestgreen")+
      geom_line(data = dataEq , 
                aes(x= Year, y=  T_NC_NET_AVG), size = 2, color="darkorange")+
      labs( y = paste0("Average net tax rate, ", stringType))+
      annotate(geom="text", x= dataEq$Year[length(dataEq$T_C_NET_AVG) ] + 2,
               y= dataEq$T_C_NET_AVG[length(dataEq$T_C_NET_AVG)] - 0.01,
               label=expression("C-corp"), size=6,
               color="blue")+
      annotate(geom="text", x= dataEq$Year[length(dataEq$T_S_NET_AVG) ] + 2,
               y= dataEq$T_S_NET_AVG[length(dataEq$T_S_NET_AVG)] + 0.01,
               label=expression("S-corp"), size=6,
               color="forestgreen")+
      annotate(geom="text", x= dataEq$Year[length(dataEq$T_NC_NET_AVG) ] + 2,
               y= dataEq$T_NC_NET_AVG[length(dataEq$T_NC_NET_AVG)] - 0.01,
               label= expression("PUE"), size=6,
               color="darkorange")+
      theme_bw()+
      mytheme+
      theme(legend.position ="none" )
    ggsave(paste0(figureDir,"/", filename, ".png"),
           device = "png", width = 16, height = 9)
    
    write.csv(dataEq, paste0(dataDir,"/",filename , ".csv"), row.names = FALSE)
  }
  
  
}