# LOAD DATA and MERGE-----------------

#SETUP-----------------------
# Run the setup lines in Master if running as stand-alone
# garbage collection
gc()
# remove all variables except those defining directory and graph theme
rm(list = setdiff(ls(), c(ls()[grep("Dir", ls())], "mytheme")))

baseDir = "/Users/andreamanera/Dropbox (MIT)/Research/Brookings20/replicationKit"

binDir = paste0(baseDir,"/R/bin")


figureDir = paste0(outDir, "/Figures/NewDraft")
dataDir = paste0(outDir, "/Data")

source(paste0(binDir, "/setupLines.R"))

library(xtable)

# Compute Debt financing and Equity financing for C-, S-Corps, and noncorporate----------

tableFREDEqD = setDT(read_csv(paste0(capTaxDir,"/FRED_EquityDebt.csv"))) 
tableIRSAllIncome = setDT(read_csv(paste0(capTaxDir,"/IRS_AllCorps_income.csv"))) 
tableIRSScorpIncome = setDT(read_csv(paste0(capTaxDir,"/IRS_SCorps_income.csv"))) 

tableIRSAllIncome = tableIRSAllIncome[(Line>=28 & Line<=33) | Line == 60  ,]
tableIRSAllIncome$Item = c("K_stock", "Paid_In_Capital", "Ret_Earnings_App",
                           "Ret_Earnings_UnApp", "Adjustment",
                           "Treasury_Stock_Cost", "Interest_Deduction")


tableIRSScorpIncome = tableIRSScorpIncome[ (Line>=29 & Line<=33) | Line == 47  ,]
tableIRSScorpIncome$Item = c("K_stock_S", "Paid_In_Capital_S",
                           "Ret_Earnings_UnApp_S", "Adjustment_S", 
                           "Treasury_Stock_Cost_S", "Interest_Deduction_S")

tableIRSIncome = rbind(tableIRSAllIncome, tableIRSScorpIncome)

rm(list = c("tableIRSScorpIncome", "tableIRSAllIncome"))
tableIRSIncome = tableIRSIncome[,Line:= NULL]

tableIRSIncome = melt(tableIRSIncome, 
                   id.vars = c("Item"),
                   measure.vars = colnames(tableIRSIncome)[colnames(tableIRSIncome) !="Item"],
                   variable.name = "Year",
                   value.name = "Value")

tableIRSIncome$Value = as.numeric(tableIRSIncome$Value)
tableIRSIncome$Year = as.numeric(as.character(tableIRSIncome$Year))

tableIRSIncome = setDT(dcast(tableIRSIncome, Year~ Item, value.var="Value"))

# Raplece NA in adjustment variables
tableIRSIncome[is.na(Adjustment), c("Adjustment")] = 0
tableIRSIncome[is.na(Adjustment_S), c("Adjustment_S")] = 0


# Compute Total equity for All and S_Corps
tableIRSIncome  = tableIRSIncome[ , AllEquity := Adjustment + K_stock +
                                    Paid_In_Capital + Ret_Earnings_App +
                                    Ret_Earnings_UnApp  - Treasury_Stock_Cost] 

tableIRSIncome  = tableIRSIncome[ , Equity_S := Adjustment_S + K_stock_S +
                                    Paid_In_Capital_S + 
                                    Ret_Earnings_UnApp_S  - Treasury_Stock_Cost_S] 

tableIRSIncome = tableIRSIncome[ , Share_Debt_S := Interest_Deduction_S / (Interest_Deduction)]
tableIRSIncome = tableIRSIncome[ , Share_Equity_S := Equity_S/AllEquity ]


tableIRSIncome = tableFREDEqD[tableIRSIncome, on=.(Year = Year)]

tableIRSIncome = tableIRSIncome[, Equity_S_Corp := Share_Equity_S * Equity_Corp ]
tableIRSIncome = tableIRSIncome[, Debt_S_Corp := Share_Debt_S * Debt_Corp ]
tableIRSIncome = tableIRSIncome[, Equity_C_Corp := (1 - Share_Equity_S) * Equity_Corp ]
tableIRSIncome = tableIRSIncome[, Debt_C_Corp := (1 - Share_Debt_S) * Debt_Corp ]

# Compute financing shares for each Legal form of organization
tableIRSIncome = tableIRSIncome[, Debt_fin_C_Corp := Debt_C_Corp/(Equity_C_Corp + Debt_C_Corp)  ]
tableIRSIncome = tableIRSIncome[, Debt_fin_S_Corp := Debt_S_Corp/(Equity_S_Corp + Debt_S_Corp)  ]
tableIRSIncome = tableIRSIncome[, Debt_fin_Non_Corp := Debt_Non_Corp/(Equity_Non_corp + Debt_Non_Corp)  ]

tableYears = setDT(data.frame(Year = seq(1980,2018,1)))

tableSharesDebt = tableIRSIncome[, c("Year", "Debt_fin_C_Corp", "Debt_fin_S_Corp", "Debt_fin_Non_Corp"), with = F]
tableSharesDebt = tableSharesDebt[tableYears, on =.(Year = Year)]

# Fill in NA
tableSharesDebt[ Year < 1994 & is.na(Debt_fin_C_Corp), c("Debt_fin_C_Corp")] = unique(tableSharesDebt[ Year == 1994, c("Debt_fin_C_Corp")])
tableSharesDebt[ Year > 2013 & is.na(Debt_fin_C_Corp), c("Debt_fin_C_Corp")] = unique(tableSharesDebt[ Year == 2013, c("Debt_fin_C_Corp")])
tableSharesDebt[ Year < 1994 & is.na(Debt_fin_S_Corp), c("Debt_fin_S_Corp")] = unique(tableSharesDebt[ Year == 1994, c("Debt_fin_S_Corp")])
tableSharesDebt[ Year > 2013 & is.na(Debt_fin_S_Corp), c("Debt_fin_S_Corp")] = unique(tableSharesDebt[ Year == 2013, c("Debt_fin_S_Corp")])
tableSharesDebt[ Year < 1994 & is.na(Debt_fin_Non_Corp), c("Debt_fin_Non_Corp")] = unique(tableSharesDebt[ Year == 1994, c("Debt_fin_Non_Corp")])
tableSharesDebt[ Year > 2013 & is.na(Debt_fin_Non_Corp), c("Debt_fin_Non_Corp")] = unique(tableSharesDebt[ Year == 2013, c("Debt_fin_Non_Corp")])



# IRS data on income by type of corporation
tableIRSIBD = setDT(read_csv(paste0(taxDir,"/IRS_IBD.csv"))) 
tableIRSIBD = tableIRSIBD[Line ==6 |Line == 13 | Line ==20, ]
tableIRSIBD$Item = c("NI_ALL", "NI_CORP", "NI_C_CORP")
tableIRSIBD = tableIRSIBD[,Line:= NULL]

tableIRSIBD = melt(tableIRSIBD, 
                      id.vars = c("Item"),
                      measure.vars = colnames(tableIRSIBD)[colnames(tableIRSIBD) !="Item"],
                      variable.name = "Year",
                      value.name = "Value")

tableIRSIBD$Value = as.numeric(tableIRSIBD$Value)
tableIRSIBD$Year = as.numeric(as.character(tableIRSIBD$Year))

tableIRSIBD = setDT(dcast(tableIRSIBD, Year~ Item, value.var="Value"))
tableIRSIBD = tableIRSIBD[!is.na(Year),]

tableIRSIBD[, SHARE_NI_C := NI_C_CORP/NI_ALL]
tableIRSIBD[, SHARE_NI_S := (NI_CORP - NI_C_CORP)/NI_ALL]
tableIRSIBD[, SHARE_NI_NC := 1 - SHARE_NI_C - SHARE_NI_S ]

tableIRSIBD = tableIRSIBD[tableYears, on =.(Year = Year)]


# Interpolate and extrapolate to deal with NA
tableIRSIBD[Year==1990, "SHARE_NI_C" ] = (tableIRSIBD[Year==1989, "SHARE_NI_C" ] +
                                                  tableIRSIBD[Year==1991, "SHARE_NI_C" ])/2 
tableIRSIBD[Year==1990, "SHARE_NI_S" ] = (tableIRSIBD[Year==1989, "SHARE_NI_S" ] +
                                            tableIRSIBD[Year==1991, "SHARE_NI_S" ])/2 
tableIRSIBD[Year==1990, "SHARE_NI_NC" ] = (tableIRSIBD[Year==1989, "SHARE_NI_NC" ] +
                                            tableIRSIBD[Year==1991, "SHARE_NI_NC" ])/2 

tableIRSIBD[Year>2013, "SHARE_NI_C" ] = (tableIRSIBD[Year==2013, "SHARE_NI_C" ])
tableIRSIBD[Year>2013, "SHARE_NI_S" ] = (tableIRSIBD[Year==2013, "SHARE_NI_S" ])
tableIRSIBD[Year>2013, "SHARE_NI_NC" ] = (tableIRSIBD[Year==2013, "SHARE_NI_NC" ])

# load tableInv
load(paste0(outDir,"/DepreciationInputs.RData") )
# load Average Rates on Tax Base
load(paste0(outDir,"/TaxSeries.RData") )
# load Average Dividend Taxes
load(paste0(outDir,"/TaxSeriesDiv.RData") )
tableGains = tableTaxDiv[, .SD, .SDcols = c("Year", "TAU_DIV", "SHARE_S_CORP", "SHARE_C_CORP", "xi_ST_C_Corp_mean", "xi_S_inc_ST","TAU_ST")]
colnames(tableGains) <- c("Year", "TAU_LT", "SHARE_S_CORP", "SHARE_C_CORP", "xi_ST_C_Corp_mean", "xi_S_inc_ST","TAU_ST" )
tableBusTax = tableBEA[, c("Year","T_K_corp_FEDState_C_corp", "T_K_corp_State_S_corp",  "NOSCORP_IRS"), with = F]
colnames(tableBusTax) <- c("Year","T_c", "T_c_SL",  "NOSCORP_IRS")
tableGains = tableGains[tableBusTax, on =.(Year = Year)]




# average share of S-corp net income realized through short-term gains or income
xi_S = mean(tableGains$xi_S_inc_ST, na.rm = T)
# average share of C-corp net income realized through short-term gains or non-qualifying dividends, taxable gain distributions ac similia
xi_ST_C_Corp = mean(tableGains$xi_ST_C_Corp_mean, na.rm = T)

# load DATA FOR THE SHARE OF CORPORATE STOCKS BY HOUSEHOLDS AND NONPROFITs
tableShareCorp = setDT(read_csv(paste0(capTaxDir,"/FRED_SHARE_Corp_HH.csv"))) 

# Load investment prices and interest rates
load(paste0(outDir,"/InvestmentPriceSeries.RData") )

# set constant rates and deltas
constant_delta = T
constant_DPrice = T
constant_rate = T
myopic_taxes = T



vecPerfectForesight = c(1) # [0,1] to have both myopic and perfect fore
taxSeries = "T_K_corp_net_C_corp" # set tax series

tableInvCat = tableDeprCat[tableInvCat, on=.(Year = Year, Type = Type)]

tableTaxDiscounts = tableTaxes[tableInvCat, on=.(Year = Year)]

tableTaxDiscounts = tableTaxDiscounts[tableR, on=.(Year = Year)]
tableTaxDiscounts = tableTaxDiscounts[tableShareCorp, on=.(Year = Year)]
tableTaxDiscounts = tableTaxDiscounts[invLong, on=.(Year = Year, Type = NAME)]
tableTaxDiscounts = tableTaxDiscounts[, TAX_DISCOUNT := NA]
tableTaxDiscounts = tableTaxDiscounts[Year<=2018 & Year>=1981,]
################# Use Schedules from publication 946 and 534 for 1981-present 
nYears = length(1981:2018)
# BONUS APPLICATION ----------
applyBonus = 1
invTypes = unique(tableTaxDiscounts$Type) 
vecRates = c( "rTAAA1")
# Generate series for constant historical delta, and DPrice
tableTaxDiscounts[, MeanDelta := mean(delta, na.rm = T), by = c("Type")]
tableTaxDiscounts[, MeanDPrice := mean(DPrice, na.rm = T), by = c("Type")]

# If there are constant variables, rename the averages for formulas below and store the raw variable in *Raw


if (constant_delta){
  tableTaxDiscounts[, deltaRaw := delta]
  tableTaxDiscounts[,  delta := NULL]
  names(tableTaxDiscounts)[names(tableTaxDiscounts) == "MeanDelta"] <- "delta"
}
if (constant_DPrice){
  tableTaxDiscounts[, DPriceRaw := DPrice]
  tableTaxDiscounts[,  DPrice := NULL]
  names(tableTaxDiscounts)[names(tableTaxDiscounts) == "MeanDPrice"] <- "DPrice"
}

# table to store all the results

tableTaxDiscounts_Full = tableTaxDiscounts

tableAvgTaxDiscounts = unique(tableTaxDiscounts_Full[ Year>1980, Year, 
                                          by = c("Category", "Year")])  


tableAverages = as.data.frame(c(0,0, 0), row.names = c("With 81-82", "83 onwards", "2003 onwards"))
tableAveragesStructures = tableAverages
tableAveragesSoftware = tableAverages

###MAIN COMPUTATION FOR ALLOWANCES-------------
j = 0
for (rateSeries in vecRates){
  j = j + 1
  tableTaxDiscounts[, RatesToUse := get(rateSeries)]
  if (constant_rate){
    meanRate = mean(tableTaxDiscounts[Year>=1981, get(rateSeries) ], na.rm = T)
    tableTaxDiscounts$RatesToUse = meanRate
  }
  
  for (perfectForesight in vecPerfectForesight){ #PUT BACK TO 0,1!
      
      nYears = length(1981:2018)
      
      for (indType in 1:length(invTypes)){
        
        # allocate matrices for values of interest rates "r" and depreciation allowances "d"
        RatesMat = matrix(NA,nrow = length(1981:2018), ncol = nrow(Schedules))
        DepreciationMat = matrix(NA,nrow = length(1981:2018), ncol = nrow(Schedules))
        for (indYear in 1:nYears){
          # STEP 1: get depreciation type---------
          DeprType = tableTaxDiscounts$CLASS[tableTaxDiscounts$Year == (1980 + indYear) &
                                               tableTaxDiscounts$Type == invTypes[indType] ]
          if (is.na(DeprType)){
          }
          else{
            # get the appropriate investment schedule and multiply by purchase in that year
            
            # STEP 2: SET bonus depreciation-------------
            bonus = 0
            if (1980 + indYear>2001 & applyBonus == 1){
              if (1980 + indYear==2002|1980 + indYear==2003){
                bonus = .3
              }
              if (1980 + indYear==2004){
                bonus = .5
              }
              
              #According to IRS
              if ((1980 + indYear >=2008 & 1980 + indYear <= 2017) ){
                bonus = .5
              }
              if (1980 + indYear >=2018 |1980 + indYear == 2011 ){
                bonus = 1
              }
              if (1980 + indYear == 2010 ){ # attribute bonus based on number of quarters, Sep changed to 100%
                bonus = .75*.5 + .25*1
              }
            }
            
            # STEP 3: set up all the allowance terms "d" in the series--------
            DeprAllowances = (((1 - bonus) * Schedules[,DeprType] +
                                 t(c(bonus, rep(0, nrow(Schedules)- 1 ))))* 
                                tableTaxDiscounts$QUALIF[tableTaxDiscounts$Year == (1980 + indYear)
                                                         & tableTaxDiscounts$Type == invTypes[indType]] +
                                Schedules[,DeprType] *
                                (1 - tableTaxDiscounts$QUALIF[tableTaxDiscounts$Year == (1980 + indYear) 
                                                              & tableTaxDiscounts$Type == invTypes[indType]]))
            
            DeprAllowancesNoBonus =  Schedules[,DeprType]
            
            # STEP 4: prepare Rates and Tax series for the computations of the discount-------
            
            if (perfectForesight == 1){ # use realized real rates and realized average tax rates
              Rates = (1 + tableTaxDiscounts$RatesToUse[tableTaxDiscounts$Year >= (1980 + indYear) & 
                                                          tableTaxDiscounts$Year <= (1980 +  indYear + nrow(Schedules) - 1) & 
                                                          tableTaxDiscounts$Type == invTypes[indType]])
              
              TaxSeries = tableTaxDiscounts[(Year >= (1980 + indYear) & Year <= (1980 +  indYear + nrow(Schedules) - 1 ))
                                            &  tableTaxDiscounts$Type == invTypes[indType], get(taxSeries)]
              
            }
            else{ #  use the current interest rate and taxes to extrapolate
              Rates = (1 + tableTaxDiscounts$RatesToUse[tableTaxDiscounts$Year == (1980 + indYear) & 
                                                          tableTaxDiscounts$Type == invTypes[indType]])
              TaxSeries = tableTaxDiscounts[Year == (1980 + indYear) &  tableTaxDiscounts$Type == invTypes[indType],
                                            get(taxSeries)]
            }
            
            if (myopic_taxes){
              TaxSeries = tableTaxDiscounts[Year == (1980 + indYear) &  tableTaxDiscounts$Type == invTypes[indType],
                                            get(taxSeries)]
          
            }
            
            
            if (length(Rates) < nrow(Schedules)){ #cannot use perfect foresight for years after the largest, so extrapolate after that
              Rates = c(Rates, rep(Rates[length(Rates)],nrow(Schedules) - length(Rates)))
            }
            
            if (length(TaxSeries) < nrow(Schedules)){ #cannot use perfect foresight for years after the largest, so extrapolate after that
              TaxSeries = c(TaxSeries, rep(TaxSeries[length(TaxSeries)],nrow(Schedules) - length(TaxSeries)))
            }  
            
            
            # no discounting in current period
            Rates[1] = 1
            
            # Compute discount factors
            DiscountFactors = cumprod(Rates)
            
            
            # ALLOCATE PDV of allowances
            tableTaxDiscounts$PDV_DEPR[tableTaxDiscounts$Type==invTypes[indType] 
                                             & tableTaxDiscounts$Year== (1980 + indYear)] = 
              sum( DeprAllowances/ DiscountFactors)
            tableTaxDiscounts$PDV_DEPR_No_Bonus[tableTaxDiscounts$Type==invTypes[indType] 
                                       & tableTaxDiscounts$Year== (1980 + indYear)] = 
              sum( DeprAllowancesNoBonus/ DiscountFactors)
            
            
            # STEP 5: Compute the amount of depreciation in each year--------------
            DeprAllowances = DeprAllowances * TaxSeries / DiscountFactors
            
            
            #allocate it to matrix
            DepreciationMat[indYear,] = t(DeprAllowances)
            
            RatesMat[indYear,] = Rates
            # add the bonus in the first year for qualifying property
            
          }
        }
        if (all(is.na(DepreciationMat))){
          DeprTimeSeries =matrix(NA, length(1981:2018))
        }
        else{
          DeprTimeSeries = rowSums(DepreciationMat,na.rm = TRUE)
        }
        
        
        tableTaxDiscounts$TAX_DISCOUNT[tableTaxDiscounts$Type==invTypes[indType] 
                                       & tableTaxDiscounts$Year>=1981] = DeprTimeSeries

      }
  }  
  
}  


# SELECT USEFUL DATA in PDVs----------------



tablePDVs = tableTaxDiscounts[, .SD, .SDcols = c("Year", "T_INC", "Category", "Subcategory", "DetCategory", "Type", "PDV_DEPR",
                                                  "PDV_DEPR_No_Bonus", "INV", "SHARE_CORP_HH", "DPrice", "delta",
                                                 "RatesToUse", "INV")]

tablePDVs = tableGains[tablePDVs, on =.(Year = Year)]

tablePDVs = tableShareCorp[tablePDVs, on =.(Year = Year)]

tablePDVs = tablePDVs[, PDV_DEPR_No_Bonus_DEBT:= 1 + PDV_DEPR_No_Bonus]
tablePDVs = tablePDVs[, PDV_DEPR_DEBT:= 1 + PDV_DEPR]


# Set tax rates on Debt (for now use CBO)
# tablePDVs = tablePDVs[, TAU_H_C_B:= .143]
# tablePDVs = tablePDVs[, TAU_CH_S_B:= .209]
tablePDVs = tablePDVs[, TAU_H_C_B:= .1684]
tablePDVs = tablePDVs[, TAU_CH_S_B:= .2325]

# COMPUTE INPUT TAX SERIES --------- 

# Adjusted depreciation
tablePDVs[, delta_tilde := 1 - DPrice * ( 1 - delta)]
# Taxes on households holding C-corporation equity
tablePDVs[, TAU_H_C := 1 - (
  xi_ST_C_Corp * (1 - TAU_ST) + (1 - xi_ST_C_Corp) * (
    SHARE_CORP_HH * (1 - TAU_LT) + (1 - SHARE_CORP_HH) * (1 - T_INC)
  )
  )]

tablePDVs[, TAU_H_C_0_indirect := 1 - (
  xi_ST_C_Corp * (1 - TAU_ST) + (1 - xi_ST_C_Corp) * (
    SHARE_CORP_HH * (1 - TAU_LT) + (1 - SHARE_CORP_HH) )
) ]

tablePDVs[, TAU_H_C_0_indirect_death := 1 - (
  xi_ST_C_Corp * (1 - TAU_ST) + .5* (1 - xi_ST_C_Corp) * (
    SHARE_CORP_HH * (1 - TAU_LT) + (1 - SHARE_CORP_HH) ) + .5* (1 - xi_ST_C_Corp)
) ]

tablePDVs[, TAU_CH_C_baseline := TAU_H_C_0_indirect_death + T_c ]


# Taxes on households owning S-corporations
tablePDVs[, TAU_H_S := 1 - (
  xi_S * (1 - TAU_ST) + (1 - xi_S) * (1 - TAU_LT)
)]

# Modified state tax to account for ITC
tablePDVs[, ITCRate := .02]
# get investment in private fixed assets and compute tax discount from ITC
tableTaxCredit = unique(tablePDVs[Type =="Private fixed assets"  , c("Year", "INV", "NOSCORP_IRS", "T_c_SL", "ITCRate", "T_c"), with = F ])
tableTaxCredit = tableTaxCredit[ , ITCDiscountRate := (ITCRate * INV)/NOSCORP_IRS]
tableTaxCredit = tableTaxCredit[ , T_c_SL_ITC := T_c_SL + ITCDiscountRate]
tableTaxCredit = tableTaxCredit[ , T_c_ITC := T_c + ITCDiscountRate]
tableTaxCredit = tableTaxCredit[, c("Year", "T_c_SL_ITC", "T_c_ITC" )]

tablePDVs = tableTaxCredit[tablePDVs, on =.(Year = Year)]

tablePDVs[, noITCRate := 0 ]


# Overall Tax rate on S-corporations:State + HH
tablePDVs[, TAU_CH_S := T_c_SL + TAU_H_S]
tablePDVs[, TAU_CH_S_ITC := T_c_SL_ITC + TAU_H_S]
tablePDVs[, RatesToUse_B := RatesToUse]
tablePDVs[, RatesToUse := .0796 - .036] #annual S&P over 57 to 2018 minus average inflation over the same period


# Compute economic depreciation PDV
tablePDVs = tablePDVs[, PDV_ECON:= delta/(delta + RatesToUse)]
tablePDVs = tablePDVs[, PDV_ECON_B:= delta/(delta + RatesToUse_B)]

# Merge with shares of Debt and shares of property
tablePDVs = tableSharesDebt[tablePDVs, on = .(Year = Year)]
tablePDVs = tableIRSIBD[tablePDVs, on = .(Year = Year)]

write.csv(tablePDVs, file = paste0(dataDir, "/AllData.csv"), row.names = F)

# Filter by things we care about.

source(paste0(binDir,"/functionComputeWedges.R"))
source(paste0(binDir,"/functionProduceTables.R"))
source(paste0(binDir,"/functionGraphExportSeries.R"))

WedgeAvgsOursNoPropNoInv = compute.avgWedges.capitalizeTax(tablePDVs,SeriesITCRate = "noITCRate", SeriesTAU_H_C_B = "TAU_H_C_B",
                                                           SeriesTAU_CH_S_B = "TAU_H_S")


WedgeAvgsOurs0IND = compute.avgWedges.capitalizeTax(tablePDVs, SeriesTAU_H_C = "TAU_H_C_0_indirect", SeriesTAU_H_C_B = "TAU_H_C_B",
                                                    SeriesTAU_CH_S_B = "TAU_H_S", SeriesITCRate = "noITCRate")


varsToKeepDepr = c("Year", "Type", "PDV_DEPR", "PDV_ECON", "PDV_ECON_B")


dataSo = WedgeAvgsOurs0IND[Type == "Software", varsToKeepDepr, with = F]
dataEq = WedgeAvgsOurs0IND[Type == "Equipment", varsToKeepDepr, with = F]
dataStruc = WedgeAvgsOurs0IND[Type == "Nonresidential structures", varsToKeepDepr, with = F]
write.csv(dataSo, file = paste0(dataDir, "/SoftDepr.csv"), row.names = F)
write.csv(dataEq, file = paste0(dataDir, "/EquipDepr.csv"), row.names = F)
write.csv(dataStruc, file = paste0(dataDir, "/StructDepr.csv"), row.names = F)

varsToKeep = c("Year", "Type", 
               "T_C_NET","T_C_NET_NoB",
               "T_S_NET","T_S_NET_NoB", 
               "T_NC_NET","T_NC_NET_NoB",
               "T_C_NET_BOND","T_C_NET_NoB_BOND",
               "T_S_NET_BOND","T_S_NET_NoB_BOND", 
               "T_NC_NET_BOND","T_NC_NET_NoB_BOND",
               "T_C_NET_AVG", "T_S_NET_AVG", "T_NC_NET_AVG",
               "T_NET_AVG", "T_NET_AVG_NO_DEBT",
               "T_C_NET_AVG_NoB", "T_S_NET_AVG_NoB", "T_NC_NET_AVG_NoB",
               "T_NET_AVG_NoB", "T_NET_AVG_NO_DEBT_NoB")


tableWedgeOurs = WedgeAvgsOursNoPropNoInv[, varsToKeep, with = F]
tableWedgeOurs0IND = WedgeAvgsOurs0IND[, varsToKeep, with = F]


# SAVE DATA OF INTEREST
dataSo = tableWedgeOurs0IND[Type == "Software", ]
dataEq = tableWedgeOurs0IND[Type == "Equipment", ]
dataStruc = tableWedgeOurs0IND[Type == "Nonresidential structures", ]
write.csv(dataSo, file = paste0(dataDir, "/SoftWedges.csv"), row.names = F)
write.csv(dataEq, file = paste0(dataDir, "/EquipWedges.csv"), row.names = F)
write.csv(dataStruc, file = paste0(dataDir, "/StructWedges.csv"), row.names = F)

# EXPORT CAPITAL TAXATION
dataExport = unique(tablePDVs[!is.na(TAU_H_C), c("Year", "TAU_CH_C_baseline", "TAU_H_C", "T_c",
                                                 "TAU_CH_S", "TAU_H_S", "T_INC")])
write.csv(dataExport, file = paste0(dataDir, "/CapitalIncomeTaxes.csv"), row.names = F)

# WEDGES PLOTS-----------
filename = "WedgesVariousEq"

ggplot(dataEq)+
  geom_line(aes(x= Year, y=  T_C_NET), size = 2, color="blue" )+
  geom_line(aes(x= Year, y=  T_NET_AVG), size = 2, color="forestgreen")+
  geom_line(aes(x= Year, y=  T_NET_AVG_NO_DEBT), size = 2, color="darkorange")+
  geom_line(aes(x= Year, y=  T_C_NET_NoB), size = 2, color="blue", linetype="dashed")+
  geom_line(aes(x= Year, y=  T_NET_AVG_NoB), size = 2, color="forestgreen", linetype="dashed")+
  geom_line(aes(x= Year, y=  T_NET_AVG_NO_DEBT_NoB), size = 2, color="darkorange", linetype="dashed")+
  labs( y = "Equipment net tax rate")+
  annotate(geom="text", x= dataEq$Year[length(dataEq$T_C_NET) ] + 2,
           y= dataEq$T_C_NET[length(dataEq$T_C_NET)] - 0.01,
           label=expression("C-corp wedge, Equity only" ), size=6,
           color="blue")+
  annotate(geom="text", x= dataEq$Year[length(dataEq$T_NET_AVG) ] + 2,
           y= dataEq$T_NET_AVG[length(dataEq$T_NET_AVG)] - 0.01,
           label=expression("Wedge all"), size=6,
           color="forestgreen")+
  annotate(geom="text", x= dataEq$Year[length(dataEq$T_NET_AVG_NO_DEBT) ] + 3,
           y= dataEq$T_NET_AVG_NO_DEBT[length(dataEq$T_NET_AVG_NO_DEBT)] + 0.01,
           label= expression("Wedge all, NO DEBT"), size=6,
           color="darkorange")+
  theme_bw()+
  mytheme +
  xlim(1980, 2024)+
  theme(legend.position ="none" )
  

ggsave(paste0(figureDir,"/", filename, ".png"),
       device = "png", width = 16, height = 9)


filename = "WedgesVariousSoft"

ggplot(dataSo)+
  geom_line(aes(x= Year, y=  T_C_NET), size = 2, color="blue" )+
  geom_line(aes(x= Year, y=  T_NET_AVG), size = 2, color="forestgreen")+
  geom_line(aes(x= Year, y=  T_NET_AVG_NO_DEBT), size = 2, color="darkorange")+
  geom_line(aes(x= Year, y=  T_C_NET_NoB), size = 2, color="blue", linetype="dashed")+
  geom_line(aes(x= Year, y=  T_NET_AVG_NoB), size = 2, color="forestgreen", linetype="dashed")+
  geom_line(aes(x= Year, y=  T_NET_AVG_NO_DEBT_NoB), size = 2, color="darkorange", linetype="dashed")+
  labs( y = "Software net tax rate")+
  annotate(geom="text", x= dataSo$Year[length(dataSo$T_C_NET) ] + 2,
           y= dataSo$T_C_NET[length(dataSo$T_C_NET)] - 0.01,
           label=expression("C-corp wedge, Equity only" ), size=6,
           color="blue")+
  annotate(geom="text", x= dataSo$Year[length(dataSo$T_NET_AVG) ] + 2,
           y= dataSo$T_NET_AVG[length(dataSo$T_NET_AVG)] - 0.01,
           label=expression("Wedge all"), size=6,
           color="forestgreen")+
  annotate(geom="text", x= dataSo$Year[length(dataSo$T_NET_AVG_NO_DEBT) ] + 3,
           y= dataSo$T_NET_AVG_NO_DEBT[length(dataSo$T_NET_AVG_NO_DEBT)] + 0.01,
           label= expression("Wedge all, NO DEBT"), size=6,
           color="darkorange")+
  theme_bw()+
  mytheme +
  xlim(1980, 2024)+
  theme(legend.position ="none" )


ggsave(paste0(figureDir,"/", filename, ".png"),
       device = "png", width = 16, height = 9)



dataGraph = unique(tablePDVs[!is.na(TAU_H_C), c("Year", "TAU_H_C", "TAU_H_C_0_indirect", "TAU_H_C_0_indirect_death",
                                                               "TAU_CH_S", "TAU_H_S")])

ggplot(dataGraph)+
  geom_line(data = dataGraph ,
            aes(x= Year, y=  TAU_H_C_0_indirect), size = 2, color="blue", linetype = "dashed" )+
  geom_line(data = dataGraph ,
            aes(x= Year, y=  TAU_H_C_0_indirect_death), size = 2, color="blue", linetype = "dotted" )+
  geom_line(data = dataGraph ,
            aes(x= Year, y=  TAU_H_C), size = 2, color="blue" )+
  geom_line(data = dataGraph ,
            aes(x= Year, y=  TAU_CH_S), size = 2, color="forestgreen")+
  geom_line(data = dataGraph ,
            aes(x= Year, y=  TAU_H_S), size = 2, color="darkorange")+
  labs( y = "Average tax rate")+
  annotate(geom="text", x= dataGraph$Year[length(dataGraph$TAU_H_C) ] + 2,
           y= dataGraph$TAU_H_C[length(dataGraph$TAU_H_C)] - 0.01,
           label=expression("HH Tax on C-corp, " ~ tau ^ "h,c" ), size=6,
           color="blue")+
  annotate(geom="text", x= dataGraph$Year[length(dataGraph$TAU_H_C_0_indirect) ] + 2,
           y= dataGraph$TAU_H_C_0_indirect[length(dataGraph$TAU_H_C_0_indirect)] - 0.01,
           label=expression("HH Tax on C-corp, no ind., " ~ tau ^ "h,c" ), size=6,
           color="blue")+
  annotate(geom="text", x= dataGraph$Year[length(dataGraph$TAU_H_C_0_indirect_death) ] + 2,
           y= dataGraph$TAU_H_C_0_indirect_death[length(dataGraph$TAU_H_C_0_indirect_death)] - 0.01,
           label=expression("HH Tax on C-corp, no ind., death " ~ tau ^ "h,c" ), size=6,
           color="blue")+
  annotate(geom="text", x= dataGraph$Year[length(dataGraph$TAU_CH_S) ] + 2,
           y= dataGraph$TAU_CH_S[length(dataGraph$TAU_CH_S)] - 0.01,
           label=expression("Tax on S-corp, "~ tau ^ "h,s"), size=6,
           color="forestgreen")+
  annotate(geom="text", x= dataGraph$Year[length(dataGraph$TAU_H_S) ] + 2,
           y= dataGraph$TAU_H_S[length(dataGraph$TAU_H_S)] - 0.01,
           label= expression("Tax on S-corp, debt-financed"~ tau ^ "h,s b"), size=6,
           color="darkorange")+
  theme_bw()+
  mytheme+
  theme(legend.position ="none" )

# EXPORT SERIES FOR CAPITAL TAXATION 



