* This .do file produces the graphs for the blog "Angola and the Money Laundering Paradox" 

* Installs needed to run graphs 
*net install scheme-modern, from("https://raw.githubusercontent.com/mdroste/stata-scheme-modern/master/")
* 
* ssc install kountry
* ssc install mmerge 
* ssc install egenmore
/*
kountryadd "Macedonia (Former Yugoslav Republic of)" to "Macedonia" add
kountryadd "Congo. Democratic Republic" to "Democratic Republic of Congo" add
kountryadd "Azebaijan" to "Azerbaijan" add
kountryadd "Colobia" to "Colombia" add 
kountryadd "India4" to "India" add
kountryadd "United Arab EmiratesUAE" to "United Arab Emirates" add
kountryadd "Eswatini Swaziland" to "Swaziland" add
kountryadd "St Kitts  Nevis" to "Saint Kitts and Nevis" add
*/


*****************
* 1 - Data prep *
*****************
cd "C:\Users\mcollin\Dropbox\Research\Troika\wrap\brookings blog"		/// Set directory here 

* CPI (2019)
import excel "CPI2019.xlsx", sheet("CPI2019") cellrange(A3:V183) clear firstrow
keep ISO3 CPI
rename    CPI cpi_2019
rename    ISO3 iso3
drop if iso3 == ""
tempfile cpi
save    `cpi', replace

* FATF blacklisting status 2010-2019
use "f_black2010.dta", clear
tempfile f
save    `f', replace

* * * Mutual evaluation reviews 
use "$output/MERS_110819.dta", clear
keep if ReportType == "MER"
bys  iso3: keep if _n == 1
tempfile mer
save    `mer', replace  

* Financial secrecy index 2018
import excel "$input\FSI-Rankings-2018.xlsx", sheet("FSI Results") firstrow clear
replace Jurisdiction = subinstr(Jurisdiction, "2", "",.)
replace Jurisdiction = subinstr(Jurisdiction, "3", "",.)
replace Jurisdiction = trim(Jurisdiction)
drop if Jurisdiction == ""
kountry Jurisdiction, from(other) stuck
rename _ISO3N_ numcode
kountry numcode, from(iso3n) to(iso3c) m
drop NAMES_STD MARKER numcode
rename _ISO3C_ iso3
replace iso3 = "JEY" if Juris == "Jersey"
replace iso3 = "UAE" if Juris == "United Arab Emirates (Dubai),"
replace iso3 = "GGY" if Juris == "Guernsey"
replace iso3 = "IMN" if Juris == "Isle of Man"
replace iso3 = "CUW" if Juris == "Curacao"
drop                 if Juris == "Malaysia (Labuan)" | Juris == "Portugal (Madeira)"
assert  iso3 != ""
rename SecrecyScore SecrecyScore18
rename FSIValue     FSIValue18
gen    lnfsi18  = ln(FSIValue18)
keep iso3 Secrecy FSIValue lnfsi18

lab var  FSIValue "Financial Secrecy Index Score (2018*)"
lab var  lnfsi	  "Log(Financial Secrecy Index Score (2018*))"
lab var  Secrecy  "Financial Secrecy Score (2018*)"

tempfile fsi18
save    `fsi18', replace

* Troika data
use "troika_year.dta", clear
keep if year >= 2010
collapse (max) anytransaction, by(iso3)
tempfile troika
save    `troika', replace

* * * Importing Luanda Leaks data
import excel "ICIJ_-Luanda-Leaks-List-of-companies-held-by-Isabel-dos-Santos-and-Sindika-Dokolo.xlsx", sheet("Companies list") firstrow clear

* Adding ISO codes
* Replacing some jurisdictions
drop if Jurisdiction == ""
replace Jurisdiction = "United Arab Emirates" if Juris == "Abu Dhabi"
replace Jurisdiction = "United Arab Emirates" if Juris == "Dubai"
replace Jurisdiction = "United Arab Emirates" if Juris == "Ras Al Khaimah"
replace Jurisdiction = "Portugal"			  if Juris == "Azores"
replace Jurisdiction = "Portugal"			  if Juris == "Madeira"
replace Jurisdiction = "United States"		  if Juris == "Georgia, USA"
replace Jurisdiction = "United States"		  if Juris == "New York"
kountry Jurisdiction, from(other) stuck
rename _ISO3N_ numcode
kountry numcode, from(iso3n) to(iso3c) m
drop NAMES_STD MARKER numcode
rename _ISO3C_ iso3
replace iso3 = "STP"						  if Juris == "São Tomé e Príncipe"
replace iso3 = "IMN" 						  if Juris == "Isle of Man" 
assert iso3 != ""

* Collapsing across Jurisdictions and saving
gen num_companies = 1 
collapse (sum) num_companies (first) Jurisdiction, by(iso3)

tempfile ll
save    `ll', replace 



************
* Assemble *
************
wbopendata, indicator(NY.GNP.PCAP.CD;SP.POP.TOTL) clear long 					// Loading data from World Bank on GDP per capita, population
keep if year   == 2017															// Slightly more GDP per capita data from this period
drop if region == "Aggregates" 													// dropping regional agrgegates 
foreach file in f mer ll fsi18 cpi troika {											// Merging in above datasets 
	mmerge countrycode using ``file'', type(1:1) umatch(iso3) 
}
foreach var of varlist f_black num_companies {									// Replacin gmissing for zeros for data for which this make ssense
	replace `var' = 0 if `var' == . 
}

gen lnny = ln(ny)
gen any_company = num_companies > 0
gen arcsign_comp = ln(num_c + sqrt(num_c^2 +1 )) 

replace Secrecy = 100 - Secrecy

************************
* Binscatters for blog * 
************************

* Graph 1 - dos Santos network
* FATF effectiveness
binscatter any_company IOmean 														 ///
		    , scheme(modern_dark)													 ///
			  xtitle("Average FATF effectiveness score" "(higher = more effective)") ///
			  ytitle("Probability jurisdiction in Santos network") 					 ///
			  subtitle(AML institutions) name(f1, replace) linetype(qfit)

* FSI Secrecy Score 
binscatter any_company Secrecy 														 ///
		    , scheme(modern_dark)													 ///
			  xtitle("100 - Secrecy Score" "(higher = more transparent)") 			 ///
			  ytitle("Probability jurisdiction in Santos network") 					 ///
			  subtitle(Financial transparency) name(f2, replace) linetype(qfit)

* Corruption Perceptions Index
binscatter any_company cpi_2019 ///
		    , scheme(modern_dark)	///
			  xtitle("Corruption Perceptions Index" "(higher = fewer perceptions of corruption)") ///
			  ytitle("Probability jurisdiction in Santos network") ///
			  subtitle(Perceived corruption) name(f3, replace)  linetype(qfit)
graph combine f1 f2 f3, ycommon rows(1) note("*Data is binned for ease of interpretation" "**Sources: ICIJ, Tax Justice Network, Transparency International") ///
title("The dos Santos network was more likely to operate in transparent" ///
	  "countries with more effective AML institutions and low levels of" ///
	  "perceived corruption")
graph play "$do/dos_santos_graph.grec"
graph export "prgraph_luanda.png", as(png) width(2000)	replace		 			 
			 
replace anytrans = 0 if anytrans == . 
			 
* Graph 2 - Russian Troika network
* FATF effectiveness
binscatter anytrans IOmean 														 ///
		    , scheme(modern_dark)													 ///
			  xtitle("Average FATF effectiveness score" "(higher = more effective)") ///
			  ytitle("Probability jurisdiction in Troika network") 					 ///
			  subtitle(AML institutions) name(f1, replace) linetype(qfit)

* FSI Secrecy Score 
binscatter anytrans Secrecy 														 ///
		    , scheme(modern_dark)													 ///
			  xtitle("100 - Secrecy Score" "(higher = more transparent)") 			 ///
			  ytitle("Probability jurisdiction in Troika network") 					 ///
			  subtitle(Financial transparency) name(f2, replace) linetype(qfit)

* Corruption Perceptions Index
binscatter anytrans cpi_2019 ///
		    , scheme(modern_dark)	///
			  xtitle("Corruption Perceptions Index" "(higher = fewer perceptions of corruption)") ///
			  ytitle("Probability jurisdiction in Troika network") ///
			  subtitle(Perceived corruption) name(f3, replace)  linetype(qfit)
graph combine f1 f2 f3, ycommon rows(1) note("*Data is binned for ease of interpretation" "**Sources: OCCRP, Tax Justice Network, Transparency International") ///
title("The Russian Troika network operated in similar" ///
	  "types of countries")
graph play "$do/troika_graph.grec"
graph export "prgraph_troika.png", as(png) width(2000)	replace	

* FATF blacklisting probability
binscatter f_black lnny , scheme(modern_dark)	///
			  xtitle("Log(GDP per capita)*") ///
			  ytitle("Probability of being listed by the FATF (2010-2019)") ///
			   linetype(qfit)  xlabel(6.9 "1,000" 9.2 "10,000" 11.5 "100,000") ///
			   title("Lower income countries are more likely to be listed by FATF") ///
			   note(*Data binned)
graph play "$do\fatf_bin.grec"
graph export "fatf.png", as(png) width(2000)	replace	


exit	 			 
