function xsim = simulateModelUnderZlb(M,oo,qpos,rpos,rspos,rb,options,Nsample,Nburnin,shock)
% FUNCTION:
% xsim = simulateModelUnderZlb(M,oo,qpos,rpos,rspos,rb,options,Nsample,Nburnin,shock)
%
% OUTPUTS:
%   xsim : simulated path for all the model variables
%
% INPUTS
%   M        : Dynare info structure
%   oo       : Dynare model structure
%   qpos     : Position of risk-premium shock
%   rpos     : position of Fed Funds rate
%   rspos    : position of shadow rate
%   rb       : bound on Fed Funds rate
%   options  : options from Dynare
%   Nsample  : length of simulation
%   Nburinin : burn in
%   shock    : time-series of model shocks
%
% Based on the codes from Coibion, Gorodnichenko, & Wieland, ReStud 

warning('off','all');

% mystream = RandStream.create('mrg32k3a','NumStreams',1);
% mystream.Substream = 1;

numshock = M.exo_nbr;
snum     = M.endo_nbr ;
nlag     = 1;
bound    = M.equations_tags{1}; % Row of the max operator R = max(Rbound,Rs)

[P,Q,d]   = my_transition_matrix(M,oo,options);
[A,B,C,D] = make_ABCD(M,oo);

captlimit=200;


%----------------------------------------------------------------------
% Implementing the Bodenstein et al. algorithm , drawing on CGW
% Rewriting the interest rate equation in the ELB/ZLB case
%----------------------------------------------------------------------
BS=B;
BS(bound,:)=zeros(1,nlag*snum);
BS(bound,rpos)=B(bound,rpos);
AS=A;
AS(bound,:)=zeros(1,nlag*snum);
CS=C;
CS(bound,:)=zeros(1,nlag*snum);
DS=D;
DS(bound,:)=zeros(1,numshock);

% And interest rates equal the lower bound
% ---------------------------------------------------------------------
% rb = - 1000000 ;
d(bound,1)=-rb*BS(bound,rpos);

% Calculating the necessary inverses
% -----------------------------------------------------------------
I=eye(nlag*snum);
AB=-BS\AS;
CB=-BS\CS;
db=-BS\d;
DB=-BS\DS;
ABb=-B\A;
CBb=-B\C;
dbb=zeros(nlag*snum,1);
DBb=-B\D;

%================Simulating Time series=======================================


T=0;                %initial guess
nc=0;               %stores nonconverging series

serieslength = Nsample+Nburnin;

% shock = randn(mystream,numshock,serieslength);

epsilon=chol(M.Sigma_e)*shock;  % Shock series
x=zeros(nlag*snum,serieslength); % Time series to be filled

%zlb=zeros(1,serieslength);    % Keep the flag for the time when zero rate is binding

maxt=0;

for i=2:serieslength
    adj=0;
    checklb=0;
    checkub=0;
    checkblb=0;
    checkbub=0;
    
    it=0;
    Tb=0;
    while checklb==0 || checkub==0 || checkblb==0 || checkbub==0
        
        % August 20 :  try 200 rather than 100
        if it>100 && checkub==1              %breaks non-converging iterations
            nc=nc+1;
            break
        end
        
        if T==0
            
            s=zeros(nlag*snum,T+2);
            
            s(:,1)=P*x(:,i-1)+Q*epsilon(:,i);   % When the liquidity trap is not expected to bind, it follows the normal laws of motion
            s(:,2)=P*s(:,1);
            
            checklb=1;                   %cannot move the liquidity trap length to T=-1
            checkub=(rb<s(rspos,1));   %checks that the zero lower bound does not bind today
            
        else
            
            G=zeros(nlag*snum,nlag*snum*T);       %Cashing variables
            h=zeros(nlag*snum,T);
            s=zeros(nlag*snum,T+2);
            
            G(:,1:nlag*snum)=-inv(AS*P+BS)*CS;
            h(:,1)=-inv(AS*P+BS)*d;
            
            for t=2:T-Tb
                G(:,1+(t-1)*nlag*snum:t*nlag*snum)=(I-AB*G(:,1+(t-2)*nlag*snum:(t-1)*nlag*snum))\CB;
                h(:,t)=(I-AB*G(:,1+(t-2)*nlag*snum:(t-1)*nlag*snum))\(AB*h(:,t-1)+db);
            end
            
            for t=T-Tb+1:T
                G(:,1+(t-1)*nlag*snum:t*nlag*snum)=(I-ABb*G(:,1+(t-2)*nlag*snum:(t-1)*nlag*snum))\CBb;
                h(:,t)=(I-ABb*G(:,1+(t-2)*nlag*snum:(t-1)*nlag*snum))\(ABb*h(:,t-1)+dbb);
            end
            
            G2=[P,G];
            
            if Tb==0
                s(:,1)=G2(:,1+T*nlag*snum:(T+1)*nlag*snum)*x(:,i-1)+(I-AB*G2(:,1+(T-1)*nlag*snum:T*nlag*snum))\DB*epsilon(:,i)+h(:,T);
            else
                s(:,1)=G2(:,1+T*nlag*snum:(T+1)*nlag*snum)*x(:,i-1)+(I-ABb*G2(:,1+(T-1)*nlag*snum:T*nlag*snum))\DBb*epsilon(:,i)+h(:,T);
            end
            
            for t=2:T
                s(:,t)=G2(:,1+(T-t+1)*nlag*snum:(T-t+2)*nlag*snum)*s(:,t-1)+h(:,T-t+1);
            end
            
            s(:,T+1)=P*s(:,T);
            s(:,T+2)=P*s(:,T+1);
            
            
            checklb=(s(rpos,T)>s(rspos,T));     %checks that the zero lower bound binds at T
            checkub=(rb<s(rspos,T+1));        %checks that the zero lower bound does not bind at T+1
        end
        
        if checklb==0 && checkub==0
            T=T+1;
        else
            T=T+(checklb-1)+(1-checkub);        %adjusts T according to check values
            Tb=max(min(T-1,Tb),0);
        end
        
        if checklb==1 && checkub==1
            if Tb==0
                checkblb=1;
            else
                checkblb=(rb<s(rspos,Tb));
            end
            if T==0
                checkbub=1;
            else
                checkbub=(s(rpos,Tb+1)>s(rspos,Tb+1));
            end
            Tb=Tb+(checkblb-1)+(1-checkbub);
            if Tb>0
                T=max(T,Tb+1);
            end
        end
        
        if T>captlimit
            T=captlimit;
            x(qpos,i-1)=x(qpos,i-1)*(0.97^adj);
            adj=adj+1;
        end
        
        
        it=it+1;
        
    end
    maxt=max(T,maxt);
    x(:,i)=s(:,1);
end

xsim = x ;

if nc > 0
    fprintf('Nb. of nc sequences: %-2d\n',nc)
end