function [] = printParametersInFile(fname,location)
% printParametersInFile
%
% Generate a file [fname]printParametersInFile[loc].m
%
% location = 1 -> loc = Mode
% location = 2 -> loc = Mean
% location = 3 -> loc = Median

if nargin < 2
	location = 1;
end

load([fname,'_results'])

if location == 1
	pnam = fieldnames(oo_.posterior_mode.parameters) ; 
	pval = oo_.posterior_mode.parameters;
    loc = 'Mode';
elseif location == 2
    pnam = fieldnames(oo_.posterior_mean.parameters) ; 
    pval = oo_.posterior_mean.parameters;
    loc = 'Mean';
elseif location == 3
    pnam = fieldnames(oo_.posterior_median.parameters) ; 
    pval = oo_.posterior_median.parameters;
    loc = 'Median';
else
    error('No such central tendency measure available')
end
zz   = char(pnam);

fid = fopen([fname,'EstimatedParameters',loc,'.m'],'w+');
for i = 1:size(pnam,1)
    fprintf(fid,'%s =  \t %4.25f; \n',zz(i,:),eval(['pval.',pnam{i}]));
end
fclose(fid);