function [beta,se,resid,r2,rb2]=ols(X,y)
%OLS   Ordinary least-square estimation
%
%      Syntax : [beta,se,resid,r2,rb2]=ols(X,y);
%
%      [beta,se,resid,r2] calculates the ordinary least squares 
%      estimates, beta, for the equation(s):
% 
%           y=X*beta+u,     E[u]=0, E[u*u']=sigma^2 * I
%     
%      where y is a Txn matrix of T observations on the n dependent 
%      variables, X is a Txk matrix of T observations on k independent
%      variables, and u is a Txn matrix of residuals.  If requested, 
%      OLS also returns the standard errors of beta, se, the estimated 
%      residuals, u, the R^2 statistic, and the Rbar^2 statistic.
%

%      Ellen R. McGrattan, 10-13-87
%      Revised, 11-23-88, ERM
%
beta=(X'*X)\(X'*y);
if nargout>1
  resid=y-X*beta;
  [T,k]=size(X);
  df=T-k;
  se=sqrt(diag(inv(X'*X)/df))*sqrt(diag(resid'*resid))';
end
if nargout>3
  p=X*((X'*X)\X');
  l=eye(T)-ones(T)/T;
  r2=((diag(y'*X*beta)-(sum(y)').^2/T).^2)./(diag(y'*l*y).*diag(y'*p*l*p*y));
  rb2=(T*r2-k)/df;
end
