function [P,Q,d] = my_transition_matrix(M,oo,opt)
% This is a function "hacked" from Dynare
%
% function [A,B] = kalman_transition_matrix(dr,iv,ic,exo_nbr)
% Builds the transition equation of the state space representation out of ghx and ghu for Kalman filter
% 
% INPUTS
%    dr:      structure of decisions rules for stochastic simulations
%    iv:      selected variables
%    ic:      state variables position in the transition matrix columns
%    exo_nbr: number of exogenous variables
%    
% OUTPUTS
%    A:       matrix of predetermined variables effects in linear solution (ghx)
%    B:       matrix of shocks effects in linear solution (ghu)
%        
% SPECIAL REQUIREMENTS
%    none

% Copyright (C) 2003-2011 Dynare Team
%
% This file is part of Dynare.
%
% Dynare is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% Dynare is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with Dynare.  If not, see <http://www.gnu.org/licenses/>.

% dr = resol(0,M, opt, oo);


k2 = oo.dr.kstate(find(oo.dr.kstate(:,2) <= M.maximum_lag+1),[1 2]);
k2 = k2(:,1)+(M.maximum_lag+1-k2(:,2))*M.endo_nbr;

I  = eye(M.endo_nbr);
T = I(oo.dr.order_var(k2),:) ;

klen = M.maximum_lag + M.maximum_lead + 1;
exo_simul = [repmat(oo.exo_steady_state',klen,1) repmat(oo.exo_det_steady_state',klen,1)];
z = repmat(oo.steady_state,1,klen);
iyv = M.lead_lag_incidence';
iyv = iyv(:);
iyr0 = find(iyv) ;
it_ = M.maximum_lag + 1 ;


[junk,jacobiaAbs,hessian1] = feval([M.fname '_dynamic'],z(iyr0),...
                                         exo_simul, ...
                                         M.params, oo.steady_state, it_);
[dr,info] = dyn_first_order_solver(jacobiaAbs,M,oo.dr,opt,2);





% dr = oo.dr ;
% iv = dr.restrict_var_list;
% ic = dr.restrict_columns;
% exo_nbr = M.exo_nbr ;


% n_iv = length(iv);
%
% A = zeros(n_iv,n_iv);
%
% i_n_iv = 1:n_iv;
% A(i_n_iv,ic) = dr.ghx(iv,:);
%
% if nargout>1
%     B = zeros(n_iv,exo_nbr);
%     B(i_n_iv,:) = dr.ghu(iv,:);
% end

P = zeros(M.endo_nbr);
P(dr.order_var,dr.order_var(k2)) = dr.ghx;
Q(dr.order_var,:) = dr.ghu;

d = feval([M.fname,'_steadystate2'],[],[], M.params)';