function [A,B,C,D] = make_ABCD(M,oo)
% Function desinged by Michel Juillard
% Extracts the Jacobian and reformat it in terms of  A, B, C, D
% with model under the form
% E_t \{ Ax_{t+1} + Bx_t + Dx_{t-1} + D\epsilon_t \} = 0

klen = M.maximum_lag + M.maximum_lead + 1;
exo_simul = [repmat(oo.exo_steady_state',klen,1) ...
    repmat(oo.exo_det_steady_state',klen,1)];
z = repmat(oo.steady_state,1,klen);
iyv = M.lead_lag_incidence';
iyv = iyv(:);
iyr0 = find(iyv) ;
it_ = M.maximum_lag + 1 ;

[~,jacobian,~] = feval([M.fname '_dynamic'],...
    z(iyr0),...
    exo_simul, ...
    M.params, oo.steady_state, it_);	



neq = size(jacobian,1);
nsfwrd = M.nsfwrd;
[~,iv_fwrd,ic_fwrd] = find(M.lead_lag_incidence(3,:));
[~,iv_cur,ic_cur] =  find(M.lead_lag_incidence(2,:));
[~,iv_pred,ic_pred] = find(M.lead_lag_incidence(1,:));

A = zeros(neq,neq);
B = A;
C = A;
D = zeros(neq,M.exo_nbr);

A(:,iv_fwrd) = jacobian(:,ic_fwrd);
B(:,iv_cur) = jacobian(:,ic_cur);
C(:,iv_pred) = jacobian(:,ic_pred);
D = jacobian(:,(end-M.exo_nbr+1):end);
