function [Welfare,stdWelfare,LAMY,LAMP,LAMW] = computeWelfare(M,Xsim)


pip = Xsim(1,:);
piw = Xsim(2,:);
x   = Xsim(3,:);
Ts  = length(x);
Ts1 = 2:Ts; 
Ts0 = 1:Ts-1;

% ---------------------------------------------------------------------
% Assign Parameters Values
% ---------------------------------------------------------------------
RHO    = my_get_param_by_name('RHO',M);
ETA    = my_get_param_by_name('ETA',M);
IOTAP  = my_get_param_by_name('IOTAP',M);
IOTAW  = my_get_param_by_name('IOTAW',M);
GAMMAP = my_get_param_by_name('GAMMAP',M);
GAMMAW = my_get_param_by_name('GAMMAW',M);
NU     = my_get_param_by_name('NU',M);
GAMMAZ = my_get_param_by_name('GAMMAZ',M);
MUZ    = my_get_param_by_name('MUZ',M);
THETAP = my_get_param_by_name('THETAP',M);
THETAW = my_get_param_by_name('THETAW',M);
PHI    = my_get_param_by_name('PHI',M);
ALPHAP = my_get_param_by_name('ALPHAP',M);
ALPHAW = my_get_param_by_name('ALPHAW',M);
PISTAR = my_get_param_by_name('PISTAR',M);

% ---------------------------------------------------------------------
% Loss function
% ---------------------------------------------------------------------
% ---> Auxiliary parameters
% ---------------------------------------------------------------------
BETA    = 1/(1+RHO) ;
VARFI   = 1/((1-BETA*ETA)*(1-ETA)) ;
OMEGAP  = PHI-1;
OMEGAW  = NU*PHI;
OMEGA   = OMEGAP+OMEGAW;
OMEGAKP = BETA*ALPHAP*(1+PISTAR)^((1-GAMMAP)*PHI*THETAP);
OMEGAFP = BETA*ALPHAP*(1+PISTAR)^((1-GAMMAP)*(THETAP-1));
OMEGAKW = BETA*ALPHAW*(exp((1-GAMMAZ)*MUZ)*(1+PISTAR)^(1-GAMMAW))^((1+NU)*THETAW);
OMEGAFW = BETA*ALPHAW*(exp((1-GAMMAZ)*MUZ)*(1+PISTAR)^(1-GAMMAW))^(THETAW-1);
OMEGAXI = ALPHAP*(1+PISTAR)^(PHI*THETAP*(1-GAMMAP));
% ---------------------------------------------------------------------
% ---> Steady-state distorsion
% ---------------------------------------------------------------------
AAA  = (1-OMEGAKW)/(1-OMEGAFW);
BBB  = (BETA*(1-ALPHAW)/(BETA-OMEGAFW))^((1+THETAW*NU)/(THETAW-1));
CCC  = (1-OMEGAKP)/(1-OMEGAFP);
DDD  = (BETA*(1-ALPHAP)/(BETA-OMEGAFP))^((1+THETAP*OMEGA)/(THETAP-1));
EEE  = ((1-OMEGAXI)/(1-ALPHAP))^NU;
xbar = log(AAA*BBB*CCC*DDD*EEE)/(PHI*(1+NU));
% ---------------------------------------------------------------------
% ---> Loss parameters
% ---------------------------------------------------------------------
CHI    = (OMEGA+VARFI*(1+BETA*ETA^2))/(BETA*VARFI);
VARK   = .5*BETA*(CHI+sqrt(CHI^2-4*ETA^2/BETA));
DELTA  = ETA/VARK;
DELTA0 = VARK*VARFI;
LAMY   = DELTA0;
LAMP   = ALPHAP*THETAP*(OMEGAP*THETAP+1)/(1-ALPHAP)/(1-BETA*ALPHAP);
LAMW   = ALPHAW*THETAW*(NU*THETAW+1)/(1-ALPHAW)/(1-BETA*ALPHAW)/PHI;
xstar  = 0; %*((THETAP-1)/THETAP*(THETAW-1))/THETAW*DELTA/ETA/VARFI/(1-BETA*DELTA);


Loss    = ...
    LAMY*...
    (x(Ts1)-DELTA*x(Ts0)+(1-DELTA)*xbar-xstar).^2 ...
    + ...
    LAMP*...
    ((1-GAMMAP)*PISTAR+pip(Ts1)-GAMMAP*IOTAP*pip(Ts0)).^2 ...
    + ...
    LAMW*...
    ((1-GAMMAZ)*MUZ+(1-GAMMAW)*PISTAR+piw(Ts1)-GAMMAW*IOTAW*piw(Ts0)).^2;

Welfare    =  - .5*(1-BETA*ETA)/(1-ETA)*mean(Loss)/(1-BETA) ;
stdWelfare =  - .5*(1-BETA*ETA)/(1-ETA)*std(Loss)/(1-BETA) ;
