function [ WelfareBk, WelfareCf ] = retrieveBayesianWelfareAlt(idCountry)
% [ WelfareBk, WelfareCf ] = retrieveBayesianWelfareAlt(idCountry)
%  
% This function loads simulation results for US or EA model for 
% the purpose of computing the Bayesian welfare, assuming that MP
% parameters are frozen at the posterior mean (all other parameters are
% drawn from the joint posterior distribution)

% 1. --- Retrieve the results
% -------------------------------------------------------------------------

% Initialze
chkDraw   = [];
Welfare   = [];
chkDrawCf = [];
WelfareCf = [];

    

if strcmp(idCountry,'US')
    % US case
    fname1 = '../RESULTS/pissSimulationAltMPUS';
    fname2 = '../RESULTS/pissSimulationCfAltMPUS';
    
end

chk1 = isfile([fname1,'.mat']);
chk2 = isfile([fname2,'.mat']);

% Check that result files exist and if so, prepare material
if chk1 && chk2
    
    x1 = load(fname1);
    x2 = load(fname2);
    
    % Right-concatenate the results for benchmark
    chkDraw = x1.chkDraw';
    Welfare = x1.Welfare;
    
    % Right-concatenate the results for counterfactual
    chkDrawCf = x2.chkDraw';
    WelfareCf = x2.Welfare;
    
end

% Get rid of bad draws
sel1      = find((chkDraw>0).*(chkDrawCf>0)>0) ;
w         = Welfare(:,sel1);
wCf       = WelfareCf(:,sel1);
Nw        = size(wCf,2);
[~,i1]    = find(w<-1e2);
[~,i2]    = find(wCf<-1e2);
sel2      = setdiff(1:Nw,unique([unique(i1);unique(i2)]));
w         = w(:,sel2);
wCf       = wCf(:,sel2);
WelfareBk = mean(w,2);
WelfareCf = mean(wCf,2);


end

