function [ WelfareBk, WelfareCf ] = retrieveBayesianWelfare(idCountry)
% [ WelfareBk, WelfareCf ] = retrieveBayesianWelfare(idCountry)
%  
% This function loads simulation results for US or EA model for 
% the purpose of computing the Bayesian welfare, all the parameters being
% drawn from the joint posterior distribution

% 1. --- Retrieve the results
% -------------------------------------------------------------------------

% Initialze
chkDraw   = [];
Welfare   = [];
drawsid   = [];
chkDrawCf = [];
WelfareCf = [];
drawsidCf = [];

    

% US case
fname1 = '../RESULTS/pissSimulationUS';
fname2 = '../RESULTS/pissSimulationCfUS';

chk1 = isfile([fname1,'.mat']);
chk2 = isfile([fname2,'.mat']);

% Check that result files exist and if so, prepare material
if chk1 && chk2
    
    x1 = load(fname1);
    x2 = load(fname2);
    
    % Right-concatenate the results for benchmark
    chkDraw = [chkDraw x1.chkDraw'];
    Welfare = [Welfare x1.Welfare];
    drawsid = [drawsid x1.drawsid ];
    
    % Right-concatenate the results for counterfactual
    chkDrawCf = [chkDrawCf x2.chkDraw'];
    WelfareCf = [WelfareCf x2.Welfare];
    drawsidCf = [drawsidCf x2.drawsid ];
    
end

sel1 = find((chkDraw>0).*(chkDrawCf>0)>0) ;
w    = Welfare(:,sel1);
wCf  = WelfareCf(:,sel1);

Nw     = size(wCf,2);
[~,i1] = find(w<-1e2);
[~,i2] = find(wCf<-1e2);
sel2   = setdiff(1:Nw,unique([unique(i1);unique(i2)]));
w      = w(:,sel2);
wCf    = wCf(:,sel2);

WelfareBk = mean(w,2);
WelfareCf = mean(wCf,2);

end

