xp1 = load('../RESULTS/fullSimulationEZBlock1PHA');
xh1 = load('../RESULTS/fullSimulationEZBlock1HLB');
xj1 = load('../RESULTS/fullSimulationEZBlock1JUM');

chkDraw = [xp1.chkDraw' xh1.chkDraw' xj1.chkDraw'];
Welfare = [xp1.Welfare xh1.Welfare xj1.Welfare];
PiGrid  = [xp1.PiGrid xh1.PiGrid xj1.PiGrid];
[~,N0]  = size(Welfare);
pm      = load('paramDrawsFile');
parm    = pm.coll(:,1:N0);
% -------------------------------------------------------------------------
Welfare = Welfare(:,chkDraw>0);
PiGrid  = PiGrid(:,chkDraw>0);
parm    = parm(:,chkDraw>0);
% -------------------------------------------------------------------------
MUZ     = parm(2,:)';  
RHO     = parm(1,:)';




[NN,Ndraw] = size(Welfare);
piStar = zeros(Ndraw,1);
for iter = 1:Ndraw
    [M,I] = max(Welfare(:,iter),[],1);
    piStar(iter) = PiGrid(I,iter);
end
x = mean(100*(piStar-1)) ;
% -------------------------------------------------------------------------
[f,xi]=ksdensity(100*(piStar-1),'npoint',50);
figure(1)
hp = plot(xi,f);
c1 = [0 .2 .7];
set(hp(1),'linewidth',2,'color',c1)
set(gca,'fontname','times')
ylim = get(gca,'ylim');
hold on
hl = line([x x],ylim);
set(hl,'linestyle','--','color',[0.5 0 0],'linewidth',2)
xlabel('Annualized Inflation Rate')
ylabel('PDF')
grid on
% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
set(gcf,'PaperType','<custom>','PaperSize',[20.4 15.25],'PaperPosition',[0.1 0.02158 20.3046 15.2284]);
%print(gcf,'-dpdf','../FIGURES/piPdfFigure')


rStar  = 400*(MUZ+RHO);
piStar = 100*(piStar-1);
[beta,se,resid,r2,rb2]=ols([ones(size(rStar)) rStar],piStar);
xr = linspace(min(rStar),max(rStar),1000);
xp = beta(2)*xr+beta(1);
% exy = confellipse3([rStar,piStar],0.9);
figure
hp = plot(rStar,piStar,xr,xp);
set(hp(1),'linestyle','none','marker','o','markerfacecolor',c1,'markeredgecolor',c1)
set(hp(2),'linestyle','-','color',[0.5 0 0])
set(gca,'fontname','times')
xlabel('Annualized Real Steady-State Interest Rate')
ylabel('Annualized Inflation Target')
% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
set(gcf,'PaperType','<custom>','PaperSize',[20.4 15.25],'PaperPosition',[0.1 0.02158 20.3046 15.2284]);
%print(gcf,'-dpdf','../FIGURES/scatterPlotFigure')
