% This code produces FIGURE 9 for BPEA paper Andrade Gali Le Bihan Matheron
%
% Generate the figure that plots the (rstar,pistar) locus depending
% whether rstar changes due to MUZ or RHO
% With alternative Indexation degree

addpath ../UTILITIES


% 1. -- Do the figures
% -------------------------------------------------------------------------
strLabel   = {'$\pi^\star$ baseline','$\pi^\star$ with $\gamma_p=0$ and $\gamma_w=0$','$\pi^\star$ with $\gamma_p=0.7$ and $\gamma_w$=0.7','$\pi^\star$ with $\gamma_p=0.9$ and $\gamma_w$=0.9'};

cb = [0 .2 .7];
c1 = [.8 0 .4];
c2 = [.5 .6 .4];
c3 = [210,105,30]/255;

estUs   = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ   = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO   = estUs.oo_.posterior_mean.parameters.RHO ;
UsbMUZ  = load('../RESULTS/resultsMUZBasicMeanUS.mat');
UsxMUZ1 = load('../RESULTS/resultsMUZ_IndexLOMeanUS.mat');
UsxMUZ2 = load('../RESULTS/resultsMUZ_IndexMEDMeanUS.mat');
UsxMUZ3 = load('../RESULTS/resultsMUZ_IndexHIMeanUS.mat');

idUsx1  = find(UsxMUZ1.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));
idUsx2  = find(UsxMUZ2.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));
idUsx3  = find(UsxMUZ3.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));
idUsb   = find(UsbMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));

figure
hp = plot(...
    UsbMUZ.vecrStar,UsbMUZ.vecPiStar,...
    UsxMUZ1.vecrStar,UsxMUZ1.vecPiStar,...
    UsxMUZ2.vecrStar,UsxMUZ2.vecPiStar,...
    UsxMUZ3.vecrStar,UsxMUZ3.vecPiStar);
set(hp(1),'marker','o','markerfacecolor',cb,'markeredgecolor',cb,'linestyle','--','color',cb)
set(hp(2),'marker','s','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--','color',c1)
set(hp(3),'marker','^','markerfacecolor',c2,'markeredgecolor',c2,'linestyle','--','color',c2)
set(hp(4),'marker','*','markerfacecolor',c3,'markeredgecolor',c3,'linestyle','--','color',c3)
grid on
set(gca,'fontname','times','fontsize',15);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('$\pi^\star$ (annualized)');
set(ylb,'interpreter','latex')
set(gca,'ylim',[-4 8],'xtick',0:12)
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
hold on
% -------------------------------------------------------------------------
% Adding dashed lines to please Jordi and mark baseline values
% -------------------------------------------------------------------------
hl1 = line(UsbMUZ.vecrStar([idUsb idUsb]),[ylim(1) UsxMUZ1.vecPiStar(idUsx1)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsbMUZ.vecrStar(idUsb)],UsbMUZ.vecPiStar([idUsb idUsb]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])

hl1 = line([xlim(1) UsxMUZ1.vecrStar(idUsx1)],UsxMUZ1.vecPiStar([idUsx1 idUsx1]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ2.vecrStar(idUsx2)],UsxMUZ2.vecPiStar([idUsx2 idUsx2]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])

hl1 = line(UsbMUZ.vecrStar([idUsb idUsb]),[ylim(1) UsxMUZ3.vecPiStar(idUsx3)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ3.vecrStar(idUsx3)],UsxMUZ3.vecPiStar([idUsx3 idUsx3]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])



hold off
lgd = legend([hp(1) hp(2) hp(3) hp(4)],strLabel);
set(lgd,'box','off','interpreter','latex','fontsize',12)

% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure9');


% [UsbMUZ.vecrStar,UsbMUZ.vecPiStar,UsxMUZ1.vecrStar,UsxMUZ1.vecPiStar,UsxMUZ2.vecrStar,UsxMUZ2.vecPiStar,[UsxMUZ3.vecrStar;NaN(10,1)],[UsxMUZ3.vecPiStar;NaN(10,1)]]

headers = {'Rstar 1','Pistar Baseline','Rstar 2','Pistar Alternative 1','Rstar 3','Pistar Alternative 2','Rstar 4','Pistar Alternative 3'};
values  = num2cell([UsbMUZ.vecrStar,UsbMUZ.vecPiStar,UsxMUZ1.vecrStar,UsxMUZ1.vecPiStar,UsxMUZ2.vecrStar,UsxMUZ2.vecPiStar,[UsxMUZ3.vecrStar;NaN(10,1)],[UsxMUZ3.vecPiStar;NaN(10,1)]]);    
xlswrite('.\XLSFILES\dataForFigure9.xlsx', [headers; values]);