% This code produces FIGURE 8 for BPEA paper Andrade Gali Le Bihan Matheron
%
% Generate the figure that plots the (rstar,pistar) locus depending on
% whether rstar changes due to MUZ or RHO; this is done for the US and the 
% euro zone, alternatively with parameters set at the posterior mode, 
% median, or mean 

addpath ../UTILITIES

% 1. -- Do the figures
% -------------------------------------------------------------------------
% Now, we just pick the mean and stack the (r,pi) loci in one single graph

strParam   = {'RHO','MUZ'};
strLabel   = {'$\pi^\star$ baseline','$\pi^\star$ with high $\theta_w$','$\pi^\star$ with low $\theta_w$'};

c1 = [0 .2 .7];
c2 = [.8 0 .4];
c3 = [.5 .6 .4];

estUs   = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ   = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO   = estUs.oo_.posterior_mean.parameters.RHO ;
UsbMUZ  = load('../RESULTS/resultsMUZBasicMeanUS.mat');
UsxMUZ1 = load('../RESULTS/resultsMUZ_THETAWHIMeanUS.mat');
UsxMUZ2 = load('../RESULTS/resultsMUZ_THETAWLOMeanUS.mat');
idUsx1  = find(UsxMUZ1.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));
idUsx2  = find(UsxMUZ2.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));
idUsb   = find(UsbMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));

pzlbUsb  = UsbMUZ.vecZLB(idUsb);
pzlbUsx1 = UsxMUZ1.vecZLB(idUsx1);
pzlbUsx2 = UsxMUZ2.vecZLB(idUsx2);
piUsb    = UsbMUZ.vecPiStar(idUsb);
piUsx1   = UsxMUZ1.vecPiStar(idUsx1);
piUsx2   = UsxMUZ1.vecPiStar(idUsx2);

figure
hp = plot(UsbMUZ.vecrStar,UsbMUZ.vecPiStar,UsxMUZ1.vecrStar,UsxMUZ1.vecPiStar,UsxMUZ2.vecrStar,UsxMUZ2.vecPiStar);
set(hp(1),'marker','o','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--','color',c1)
set(hp(2),'marker','s','markerfacecolor',c2,'markeredgecolor',c2,'linestyle','--','color',c2)
set(hp(3),'marker','^','markerfacecolor',c3,'markeredgecolor',c3,'linestyle','--','color',c3)
grid on
set(gca,'fontname','times','fontsize',15);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('$\pi^\star$ (annualized)');
set(ylb,'interpreter','latex')
set(gca,'ylim',[-2.5 6],'xtick',0:12)
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
hold on
% -------------------------------------------------------------------------
% Adding dashed lines to please Jordi and mark baseline values
% -------------------------------------------------------------------------
hl1 = line(UsbMUZ.vecrStar([idUsb idUsb]),[ylim(1) UsxMUZ1.vecPiStar(idUsx1)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsbMUZ.vecrStar(idUsb)],UsbMUZ.vecPiStar([idUsb idUsb]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ1.vecrStar(idUsx1)],UsxMUZ1.vecPiStar([idUsx1 idUsx1]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ2.vecrStar(idUsx2)],UsxMUZ2.vecPiStar([idUsx2 idUsx2]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hold off
lgd = legend([hp(1) hp(2) hp(3)],strLabel);
set(lgd,'box','off','interpreter','latex','fontsize',12)


% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure8');


headers = {'Rstar 1','Pistar Baseline','Rstar 2','Pistar Alternative 1','Rstar 3','Pistar Alternative 2'};
values  = num2cell([UsbMUZ.vecrStar,UsbMUZ.vecPiStar,UsxMUZ1.vecrStar,UsxMUZ1.vecPiStar,UsxMUZ2.vecrStar,UsxMUZ2.vecPiStar]);    
xlswrite('.\XLSFILES\dataForFigure8.xlsx', [headers; values]);