% This code produces FIGURE 6 for BPEA paper Andrade Gali Le Bihan Matheron
%
% Generate the figure that plots the (rstar,pistar) locus depending on
% whether rstar changes due to MUZ or RHO; this is done for the US and the 
% euro zone, alternatively with parameters set at the posterior mode, 
% median, or mean 

addpath ../UTILITIES

% 1. -- Prepare everything
% -------------------------------------------------------------------------


% Define colors and alpha degrees
c1 = [0 .2 .7];
%c2 = 0.5*c1+0.5*[1 1 1];
c3 = 0.3*c1+0.7*[1 1 1];

% 2. -- Do the figures
% -------------------------------------------------------------------------
% Now, we just pick the mean and stack the (r,pi) loci in one single graph

strParam   = {'RHO','MUZ'};
strLabel   = {'$\pi^\star$ baseline','$\pi^\star$ with larger demand shocks'};

c1 = [0 .2 .7];
c2 = [.8 0 .4];


estUs  = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ  = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO  = estUs.oo_.posterior_mean.parameters.RHO ;
UsbMUZ = load('../RESULTS/resultsMUZBasicMeanUS.mat');
UsxMUZ = load('../RESULTS/resultsMUZshockMeanUS.mat');
idUsx  = find(UsxMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));
idUsb  = find(UsbMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));

pzlbUsb = UsbMUZ.vecZLB(idUsb);
pzlbUsx = UsxMUZ.vecZLB(idUsx);
piUsb   = UsbMUZ.vecPiStar(idUsb);
piUsx   = UsxMUZ.vecPiStar(idUsx);



figure
hp = plot(UsbMUZ.vecrStar,UsbMUZ.vecPiStar,UsxMUZ.vecrStar,UsxMUZ.vecPiStar);
set(hp(1),'marker','o','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--','color',c1)
set(hp(2),'marker','s','markerfacecolor',c2,'markeredgecolor',c2,'linestyle','--','color',c2)
grid on
set(gca,'fontname','times','fontsize',15);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('$\pi^\star$, $\bar{\pi}$ (annualized)');
set(ylb,'interpreter','latex')
set(gca,'ylim',[-1.5 6],'xtick',0:12)
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
hold on
hl1 = line(UsxMUZ.vecrStar([idUsx idUsx]),[ylim(1) UsxMUZ.vecPiStar(idUsx)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ.vecrStar(idUsx)],UsxMUZ.vecPiStar([idUsx idUsx]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ.vecrStar(idUsx)],UsbMUZ.vecPiStar([idUsx idUsx]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hold off
lgd = legend(hp,strLabel);
set(lgd,'box','off','interpreter','latex','fontsize',12)

% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure6');

headers = {'Rstar 1','Pistar Baseline','Rstar 2','Pistar Alternative'};
values  = num2cell([[UsbMUZ.vecrStar,UsbMUZ.vecPiStar,UsxMUZ.vecrStar,UsxMUZ.vecPiStar]]);    
xlswrite('.\XLSFILES\dataForFigure6.xlsx', [headers; values]);