% This code produces FIGURE 5 for BPEA paper Andrade Gali Le Bihan Matheron
%
% Generates the figures for Welfare at the posterior mean as a function 
% of pistar using two different values for muz: the first one is the 
% benchmark and the second is 100 basis points lower


addpath ../RESULTS
addpath ../ESTIMTMP

%NOTE HERVE and JULIEN need this to have access to "isfile.m":
%addpath('C:\Program Files (x86)\Dynare\4.4.3\matlab\utilities\general')

idCountry = 'US';
radical = 'spswUs' ;

load([radical,'EstimV1_results']);
MUZ    = oo_.posterior_mean.parameters.MUZ ;
RHO    = oo_.posterior_mean.parameters.RHO ;
rstar0 = 400*((1+MUZ)*(1+RHO)-1);
rstar1 = 400*((1+MUZ-1/400)*(1+RHO)-1);


fname = ['resultsRstarZlb','Mean',idCountry] ;
eval(['x1 = load(''',fname,''');'])

idr0 = find(x1.vecrStar(:,1)==rstar0);
idr1 = find(x1.vecrStar(:,1)==rstar1);
s1 = sprintf('Target inflation set at $\\pi^\\star(r^\\star)$ with $r^\\star=2.48\\%%$.');
s2 = sprintf('Target inflation set at $\\pi^\\star(r^\\star)$ with $r^\\star=1.48\\%%$.');
s3 = sprintf('Target inflation set at optimal inflation');

estUs  = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ  = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO  = estUs.oo_.posterior_mean.parameters.RHO ;
UsxRHO = load('../RESULTS/resultsRHOBasicMeanUS.mat');
UsxMUZ = load('../RESULTS/resultsMUZBasicMeanUS.mat');
idUs   = find(UsxMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));



c3 = [0.0 0.2 0.7];
c2 = [85,107,47]/255;
c1 = [139,69,19]/255;



figure
plot(x1.vecrStar,x1.vecZLB);
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
hold on
% -------------------------------------------------------------------------
% First vertical blue line - baseline rstar
% -------------------------------------------------------------------------
hl1 = line(x1.vecrStar([idr0 idr0],1),[ylim(1) x1.vecZLB(idr0,1)]);
set(hl1,'linewidth',2,'linestyle','--','color',c1)
% -------------------------------------------------------------------------
% First horizontal blue line  - baseline rstar
% -------------------------------------------------------------------------
hl1 = line([xlim(1) x1.vecrStar(idr0,1)],x1.vecZLB([idr0 idr0],1));
set(hl1,'linewidth',2,'linestyle','--','color',c1)
% -------------------------------------------------------------------------
% Second vertical blue line - lower rstar
% -------------------------------------------------------------------------
hl1 = line(x1.vecrStar([idr1 idr1],1),[ylim(1) x1.vecZLB(idr1,2)]);
set(hl1,'linewidth',2,'linestyle','--','color',c2)
% -------------------------------------------------------------------------
% Then extend this line and change the color
% -------------------------------------------------------------------------
hl1 = line(x1.vecrStar([idr1 idr1],1),[x1.vecZLB(idr1,2) x1.vecZLB(idr1,1)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
% -------------------------------------------------------------------------
% Horizontal grey line
% -------------------------------------------------------------------------
hl1 = line([xlim(1) x1.vecrStar(idr1,1)],x1.vecZLB([idr1 idr1],1));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
% -------------------------------------------------------------------------
% Horizontal red line
% -------------------------------------------------------------------------
hl1 = line([xlim(1) x1.vecrStar(idr1,1)],x1.vecZLB([idr1 idr1],2));
set(hl1,'linewidth',2,'linestyle','--','color',c2)
% -------------------------------------------------------------------------
% Main figure
% -------------------------------------------------------------------------
hp = plot(x1.vecrStar,x1.vecZLB,UsxMUZ.vecrStar,UsxMUZ.vecZLB);
set(hp(1),'marker','s','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--','color',c1)
set(hp(2),'marker','^','markerfacecolor',c2,'markeredgecolor',c2,'linestyle','--','color',c2)
set(hp(3),'marker','o','markerfacecolor',c3,'markeredgecolor',c3,'linestyle','--','color',c3,'MarkerSize',7)
set(gca,'fontname','times','fontsize',15)
if strcmp(idCountry,'US')
    set(gca,'ylim',[0 14],'xtick',0:12,'ytick',0:2:14)
elseif strcmp(idCountry,'EZ')
    set(gca,'ylim',[0 22],'xtick',0:12,'ytick',0:2:22)
end
set(gca,'xlim',xlim)
hold off
grid
lgd = legend(hp([1 2 3]),s1,s2,s3);
set(lgd,'box','off','interpreter','latex','location','northeast','fontsize',12);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('Probability of ZLB');
set(ylb,'interpreter','latex')
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure5');

headers = {'Rstar 1','P(ZLB) 1','Rstar 2','P(ZLB) 2','Rstar 3','P(ZLB) 3'};
values  = num2cell([x1.vecrStar(:,1),x1.vecZLB(:,1),x1.vecrStar(:,2),x1.vecZLB(:,2),[UsxMUZ.vecrStar;NaN],[UsxMUZ.vecZLB;NaN]]);    
xlswrite('.\XLSFILES\dataForFigure5.xlsx', [headers; values]);
