% This code produces FIGURE 4 for BPEA paper Andrade Gali Le Bihan Matheron
%
% Generate the figure that plots the (rstar,pistar) locus depending on
% whether rstar changes due to MUZ or RHO; this is done for the US and the 
% euro zone, alternatively with parameters set at the posterior mode, 
% median, or mean 

addpath ../UTILITIES

% 1. -- Prepare everything
% -------------------------------------------------------------------------

% String of param id's
strParam   = {'RHO','MUZ'};

% String of labels for the graphs
strLabel   = {'$r^\star(\rho)$','$r^\star(\mu_z)$'};

% Define colors and alpha degrees
c1 = [0 .2 .7];
c2 = 0.5*c1+0.5*[1 1 1];
c3 = 0.3*c1+0.7*[1 1 1];

% 2. -- Do the figures
% -------------------------------------------------------------------------

%strLabel   = {'$r^\star(\mu_z)$','$r^\star(\rho)$'};

c1 = [0 .2 .7];
c2 = [.8 0 .4];

estUs  = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ  = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO  = estUs.oo_.posterior_mean.parameters.RHO ;
UsxRHO = load('../RESULTS/resultsRHOBasicMeanUS.mat');
UsxMUZ = load('../RESULTS/resultsMUZBasicMeanUS.mat');
idUs   = find(UsxMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));


figure
hp = plot(UsxMUZ.vecrStar,UsxMUZ.vecZLB,UsxRHO.vecrStar,UsxRHO.vecZLB);
set(hp(1),'marker','o','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--','color',c1)
set(hp(2),'marker','s','markerfacecolor',c2,'markeredgecolor',c2,'linestyle','--','color',c2)
grid on
set(gca,'fontname','times','fontsize',15);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('Probability of ZLB at optimal inflation');
set(ylb,'interpreter','latex')
set(gca,'ylim',[0 8],'xtick',0:12,'ytick',0:8)
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
hold on
hl1 = line(UsxMUZ.vecrStar([idUs idUs]),[ylim(1) UsxMUZ.vecZLB(idUs)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ.vecrStar(idUs)],UsxMUZ.vecZLB([idUs idUs]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
lgd = legend(hp,strLabel);
set(lgd,'box','off','interpreter','latex','fontsize',12)
% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure4');

headers = {'Rstar 1','P(ZLB) MUZ','Rstar 2','P(ZLB) RHO'};
values  = num2cell([UsxMUZ.vecrStar,UsxMUZ.vecZLB,UsxRHO.vecrStar,UsxRHO.vecZLB]);    
xlswrite('.\XLSFILES\dataForFigure4.xlsx', [headers; values]);
