% This code produces FIGURE 3 for BPEA paper Andrade Gali Le Bihan Matheron
%
% Generate the figure that plots the (rstar,pistar) locus depending on
% whether rstar changes due to MUZ or RHO; this is done for the US and the 
% euro zone, alternatively with parameters set at the posterior mode, 
% median, or mean 

addpath ../UTILITIES

% 1. -- Prepare everything
% -------------------------------------------------------------------------
% Now, we just pick the mean and stack the (r,pi) loci in one single graph

strCountry = {'EZ','US'};
strParam   = {'RHO','MUZ'};
strLabel   = {'$r^\star(\mu_z)$','$r^\star(\rho)$'};

c1 = [0 .2 .7];
c2 = [.8 0 .4];


estUs  = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ  = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO  = estUs.oo_.posterior_mean.parameters.RHO ;
UsxRHO = load('../RESULTS/resultsRHOBasicMeanUS.mat');
UsxMUZ = load('../RESULTS/resultsMUZBasicMeanUS.mat');
idUs   = find(UsxMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));

figure
hp = plot(UsxMUZ.vecrStar,UsxMUZ.vecPiStar,UsxRHO.vecrStar,UsxRHO.vecPiStar);
set(hp(1),'marker','o','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--','color',c1)
set(hp(2),'marker','s','markerfacecolor',c2,'markeredgecolor',c2,'linestyle','--','color',c2)
grid on
set(gca,'fontname','times','fontsize',15);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('Optimal inflation target (annualized)');
set(ylb,'interpreter','latex')
set(gca,'ylim',[-1.5 4],'xtick',0:12)
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
hold on
hl1 = line(UsxMUZ.vecrStar([idUs idUs]),[ylim(1) UsxMUZ.vecPiStar(idUs)]);
set(hl1,'linewidth',1,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ.vecrStar(idUs)],[UsxMUZ.vecPiStar(idUs) UsxMUZ.vecPiStar(idUs)]);
set(hl1,'linewidth',1,'linestyle','--','color',[0.5 0.5 0.5])
hold off
lgd = legend([hp(1) hp(2)],strLabel);
set(lgd,'box','off','interpreter','latex','fontsize',12)
% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure3');

headers = {'Rstar 1','Pitar MUZ','Rstar  2','Pistar RHO'};
values  = num2cell([UsxMUZ.vecrStar,UsxMUZ.vecPiStar,UsxRHO.vecrStar,UsxRHO.vecPiStar]);    
xlswrite('.\XLSFILES\dataForFigure3.xlsx', [headers; values]);

