% This code produces FIGURE 1 and 2 for BPEA paper Andrade Gali Le Bihan Matheron
addpath ../RESULTS
addpath ../UTILITIES

% % User provided information
% % -------------------------------------------------------------------------
idCountry = 'US';


% Load the results
% -------------------------------------------------------------------------
vlocation = {'Mean','Median','Mode'};
for iter=1:length(vlocation)
    loc   = vlocation{iter}; 
    fname = ['basicResults',loc,idCountry] ;
    eval(['x',num2str(iter),'= load(''',fname,''');'])
end


% Prepare local variables with interpretable names
% -------------------------------------------------------------------------
pi1 = 100*(x1.vpistar-1);
pi2 = 100*(x2.vpistar-1);
pi3 = 100*(x3.vpistar-1);
w1  = x1.Welfare;
w2  = x2.Welfare;
w3  = x3.Welfare;
im1 = find(w1==max(w1));
im2 = find(w2==max(w2));
im3 = find(w3==max(w3));
z1  = x1.vpZLB;
z2  = x2.vpZLB;
z3  = x3.vpZLB;

% Retrive numerical values
% -------------------------------------------------------------------------
s1 = sprintf('Posterior mean, $4\\pi^\\star = %1.2f$',pi1(im1));
s2 = sprintf('Posterior median, $4\\pi^\\star = %1.2f$',pi2(im2));
s3 = sprintf('Posterior mode, $4\\pi^\\star = %1.2f$',pi3(im3));

% Define colors with alpha degrees
% -------------------------------------------------------------------------
c1 = [0 0 0];
c2 = [0.5 0.5 0.5];
c3 = [0.8 0.8 0.8];

% Generate figure # 1
% -------------------------------------------------------------------------
%figure('Position', get(0, 'Screensize'));
figure
hp = plot(...
    pi1,w1-w1(im1),...
    pi1(im1),0,...
    pi2,w2-w2(im2),...
    pi2(im2),0,...
    pi3,w3-w3(im3),...
    pi3(im3),0);
set(hp(1),'linewidth',2,'color',c1)
set(hp(2),'linestyle','none','marker','o','markerfacecolor',c1,'markeredgecolor',c1)
set(hp(3),'linewidth',2,'color',c2)
set(hp(4),'linestyle','none','marker','o','markerfacecolor',c2,'markeredgecolor',c2)
set(hp(5),'linewidth',2,'color',c3)
set(hp(6),'linestyle','none','marker','o','markerfacecolor',c3,'markeredgecolor',c3)
if strcmp(idCountry,'US')
    set(gca,'xlim',[1.5 4])
end
yy = get(gca,'ylim');
dd = 0.125*(yy(2)-yy(1));
set(gca,'fontname','times','ylim',[yy(1)-dd yy(2)+dd],'fontsize',15)
lgd = legend(hp([1 3 5]),s1,s2,s3);
if strcmp(idCountry,'US')
    set(lgd,'box','off','interpreter','latex','fontsize',12,'location','southwest');
else
    set(lgd,'box','off','interpreter','latex','fontsize',12,'location','southwest');
end
xlabel('Annualized inflation rate')
ylabel('Welfare')
grid on
% set(gcf,'Units','inches');
% screenposition = get(gcf,'Position');
% set(gcf,...
%     'PaperPosition',[0 0 screenposition(3:4)],...
%     'PaperSize',screenposition(3:4));

pp1 = NaN(size(pi1'));
ww1  = NaN(size(w1));
pp2 = NaN(size(pi2'));
ww2  = NaN(size(w2));
pp3 = NaN(size(pi3'));
ww3  = NaN(size(w3));
pp1(1) = pi1(im1);
ww1(1)  = 0;
pp2(1) = pi2(im2);
ww2(1)  = 0;
pp3(1) = pi3(im3);
ww3(1)  = 0;

headers = {'Inflation Grid 1','Welfare (Mean)','Inflation Grid 2','Welfare (Median)','Inflation Grid 3','Welfare (Mode)','Inflation Dot 1','Dot (Mean)','Inflation Dot 2','Dot (Median)','Inflation Dot 3','Dot (Mode)'};
values  = num2cell([pi1',w1-w1(im1),pi2',w2-w2(im2),pi3',w3-w3(im3),pp1,ww1,pp2,ww2,pp3,ww3]);    
xlswrite('.\XLSFILES\dataForFigure1.xlsx', [headers; values]);



%Save the figure in the appropriate directory
%-------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure1')


% Retrive numerical values
% -------------------------------------------------------------------------
s1 = sprintf('Posterior mean');
s2 = sprintf('Posterior median');
s3 = sprintf('Posterior mode');


%figure('Position', get(0, 'Screensize'));
figure
hp = plot(...
    pi1,z1,...
    pi1(im1),z1(im1),...
    pi2,z2,...
    pi2(im2),z2(im2),...
    pi3,z3,...
    pi3(im3),z3(im3));
set(hp(1),'linewidth',2,'color',c1)
set(hp(2),'linestyle','none','marker','o','markerfacecolor',c1,'markeredgecolor',c1)
set(hp(3),'linewidth',2,'color',c2)
set(hp(4),'linestyle','none','marker','o','markerfacecolor',c2,'markeredgecolor',c2)
set(hp(5),'linewidth',2,'color',c3)
set(hp(6),'linestyle','none','marker','o','markerfacecolor',c3,'markeredgecolor',c3)
if strcmp(idCountry,'US')
    set(gca,'xlim',[1.5 4])
end
yy = get(gca,'ylim');
dd = 0.125*(yy(2)-yy(1));
set(gca,'fontname','times','ylim',[yy(1)-dd yy(2)+dd],'fontsize',15)
lgd = legend(hp([1 3 5]),s1,s2,s3);
if strcmp(idCountry,'US')
    set(lgd,'box','off','interpreter','latex','fontsize',12,'location','southwest');
else
    set(lgd,'box','off','interpreter','latex','fontsize',12,'location','southwest');
end
xlabel('Annualized inflation rate')
ylabel('Probability of hitting ZLB')
grid on

pp1 = NaN(size(pi1'));
zz1  = NaN(size(z1));
pp2 = NaN(size(pi2'));
zz2  = NaN(size(z2));
pp3 = NaN(size(pi3'));
zz3  = NaN(size(z3));
pp1(1) = pi1(im1);
zz1(1)  = z1(im1);
pp2(1) = pi2(im2);
zz2(1)  = z2(im2);
pp3(1) = pi3(im3);
zz3(1)  = z3(im3);



headers = {'Inflation Grid 1','p(ZLB) (Mean)','Inflation Grid 2','p(ZLB) (Median)','Inflation Grid 3','p(ZLB) (Mode)',...
    'Inflation Dot 1','p(ZLB) (Mean)','Inflation Dot 2','p(ZLB) (Median)','Inflation Dot 3','p(ZLB) (Mode)'};
values  = num2cell([pi1',z1,pi2',z2,pi3',z3,pp1,zz1,pp2,zz2,pp3,zz3]);    
xlswrite('.\XLSFILES\dataForFigure2.xlsx', [headers; values]);


% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure2');