% This code produces variant  FIGURE 18 for BPEA paper Andrade Gali Le Bihan Matheron

addpath ../UTILITIES

% 1. -- Do the figures
% -------------------------------------------------------------------------

strLabel   = {'PLT with low reaction to price level gap','PLT with large reaction to price level gap'};

c1 = [0 .2 .7];
c2 = [.8 0 .4];
c3 = [.5 .6 .4];

estUs   = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ   = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO   = estUs.oo_.posterior_mean.parameters.RHO ;
UsxMUZ1 = load('../RESULTS/resultsPltMUZ_FIPLOMeanUS.mat');
idUsx1  = find(UsxMUZ1.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));
UsxMUZ2 = load('../RESULTS/resultsPltMUZ_FIPMEMeanUS.mat');
idUsx2  = find(UsxMUZ2.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));


piUsx1   = UsxMUZ1.vecPiStar(idUsx1);
piUsx2   = UsxMUZ2.vecPiStar(idUsx2);

figure
hp = plot(UsxMUZ1.vecrStar,UsxMUZ1.vecPiStar,UsxMUZ2.vecrStar,UsxMUZ2.vecPiStar);
set(hp(1),'marker','o','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--','color',c1)
set(hp(2),'marker','s','markerfacecolor',c2,'markeredgecolor',c2,'linestyle','--','color',c2)
grid on
set(gca,'fontname','times','fontsize',15);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('$\pi^\star$ (annualized)');
set(ylb,'interpreter','latex')
set(gca,'ylim',[-1.5 4],'xtick',0:12)
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
hold on
% -------------------------------------------------------------------------
% Adding dashed lines to please Jordi and mark baseline values
% -------------------------------------------------------------------------
hl1 = line(UsxMUZ1.vecrStar([idUsx1 idUsx1]),[ylim(1) UsxMUZ1.vecPiStar(idUsx1)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ1.vecrStar(idUsx1)],UsxMUZ1.vecPiStar([idUsx1 idUsx1]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])

hl1 = line(UsxMUZ2.vecrStar([idUsx2 idUsx2]),[ylim(1) UsxMUZ2.vecPiStar(idUsx2)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ2.vecrStar(idUsx2)],UsxMUZ2.vecPiStar([idUsx2 idUsx2]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])

lgd = legend(hp,strLabel);
set(lgd,'box','off','interpreter','latex','fontsize',12)



hold off
% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure18');

headers = {'Rstar 1','Pistar Baseline','Rstar 2','Pistar Alt'};
values  = num2cell([UsxMUZ1.vecrStar,UsxMUZ1.vecPiStar,UsxMUZ2.vecrStar,UsxMUZ2.vecPiStar]);    
xlswrite('.\XLSFILES\dataForFigure18.xlsx', [headers; values]);
