% This code produces FIGURE 17 for BPEA paper Andrade Gali Le Bihan Matheron

estUs   = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ   = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO   = estUs.oo_.posterior_mean.parameters.RHO ;
UsxMUZ  = load('../RESULTS/resultsMUZBasicMeanUs.mat');
idUs    = find(UsxMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));




% HLB : Load results for NoShadow TR case
e1  = load('../RESULTS/resultsNoShadowTR_MeanUS');

% Format a little bit
x   = e1.vecrStar;
y1  = e1.vecPiStar;
N   = length(x);

% Interpolate on a denser grid
xf  = UsxMUZ.vecrStar;
yf1 = interp1(x,y1,xf,'pchip');

% Define colors
c1 = [0 .2 .7];
c2 = [.8 0 .4];


figure
hp = plot(...
    xf,UsxMUZ.vecPiStar,...
    xf,yf1);
set(hp(1),'color',c1,'marker','o','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--')
set(hp(2),'color',c2,'marker','s','markerfacecolor',c2,'markeredgecolor',c2,'linestyle','--')
strLabel   = {'$\pi^\star$ baseline','$\pi^\star$ ``no shadow rate'' rule'};
lgd = legend(strLabel);
set(lgd,'interpreter','latex')
grid
set(gca,'fontname','times','fontsize',15);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('$\pi^\star$ (annualized)');
set(ylb,'interpreter','latex')
set(gca,'fontname','times')
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
% -------------------------------------------------------------------------
hl1 = line(UsxMUZ.vecrStar([idUs idUs]),[ylim(1) UsxMUZ.vecPiStar(idUs)]);
set(hl1,'linewidth',1,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ.vecrStar(idUs)],UsxMUZ.vecPiStar([idUs idUs]));
set(hl1,'linewidth',1,'linestyle','--','color',[0.5 0.5 0.5])
% % -------------------------------------------------------------------------
hl1 = line([xlim(1) UsxMUZ.vecrStar(idUs)],yf1([idUs idUs]));
set(hl1,'linewidth',1,'linestyle','--','color',[0.5 0.5 0.5])

lgd = legend([hp(1) hp(2) ],strLabel);
set(lgd,'box','off','interpreter','latex','fontsize',12)
set(lgd,'box','off','fontsize',15)


% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure17');

headers = {'Rstar 1','Pistar Baseline','Rstar 2','Pistar Alt'};
values  = num2cell([xf,UsxMUZ.vecPiStar,xf,yf1]);    
xlswrite('.\XLSFILES\dataForFigure17.xlsx', [headers; values]);

