% This code produces FIGURE 16 for BPEA paper Andrade Gali Le Bihan Matheron

addpath ../UTILITIES

% 1. -- Do the figures
% -------------------------------------------------------------------------
strParam   = {'RHO','MUZ'};


strLabel   = {'$\pi^\star$ baseline','$\pi^\star$ under Taylor rule with yoy inflation and $\rho_{i}=0$'};

c1 = [0 .2 .7];
c2 = [.8 0 .4];
c3 = c2;

estUs   = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ   = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO   = estUs.oo_.posterior_mean.parameters.RHO ;
UsbMUZ  = load('../RESULTS/resultsMUZBasicMeanUS.mat');
UsxMUZ1 = load('../RESULTS/resultsMUZ_FIRLOMeanUS.mat');
UsxMUZ2 = load('../RESULTS/resultsMUZ_FIRKILEYMeanUS.mat');
idUsx1  = find(UsxMUZ1.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));
idUsx2  = find(UsxMUZ2.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));
idUsb   = find(UsbMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));

figure
hp = plot(...
    UsbMUZ.vecrStar,UsbMUZ.vecPiStar,...   %  UsxMUZ1.vecrStar,UsxMUZ1.vecPiStar,...
    UsxMUZ2.vecrStar,UsxMUZ2.vecPiStar);
set(hp(1),'marker','o','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--','color',c1)
set(hp(2),'marker','s','markerfacecolor',c3,'markeredgecolor',c3,'linestyle','--','color',c3)
grid on
set(gca,'fontname','times','fontsize',15);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('$\pi^\star$ (annualized)');
set(ylb,'interpreter','latex')
set(gca,'ylim',[-2.5 7.5],'xtick',0:12)
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
hold on
% -------------------------------------------------------------------------
% Adding dashed lines to please Jordi and mark baseline values
% -------------------------------------------------------------------------
hl1 = line(UsbMUZ.vecrStar([idUsb idUsb]),[ylim(1) UsxMUZ2.vecPiStar(idUsx2)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsbMUZ.vecrStar(idUsb)],UsbMUZ.vecPiStar([idUsb idUsb]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ2.vecrStar(idUsx2)],UsxMUZ2.vecPiStar([idUsx2 idUsx2]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hold off
lgd = legend([hp(1) hp(2) ],strLabel);
set(lgd,'box','off','interpreter','latex','fontsize',10)
% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure16');



headers = {'Rstar 1','Pistar Baseline','Rstar 2','Pistar Alt'};
values  = num2cell([UsbMUZ.vecrStar,UsbMUZ.vecPiStar,[UsxMUZ2.vecrStar;NaN(19,1)],[UsxMUZ2.vecPiStar;NaN(19,1)]]);    
xlswrite('.\XLSFILES\dataForFigure16.xlsx', [headers; values]);


