% This code produces FIGURE 13 for BPEA paper Andrade Gali Le Bihan Matheron

% Generate the figure that plots the (rstar,pistar) locus depending on
% whether rstar changes due to MUZ or RHO; parameters set at the posterior mode, 
% median, or mean 

addpath ../UTILITIES

% 1. -- Prepare everything
% -------------------------------------------------------------------------


% Define colors and alpha degrees
c1 = [0 .2 .7];
c3 = 0.3*c1+0.7*[1 1 1];

% 2. -- Do the figures
% -------------------------------------------------------------------------
% Now, we just pick the mean and stack the (r,pi) loci in one single graph

strParam   = {'RHO','MUZ'};
strLabel   = {'$\pi^\star$','Average realized inflation'};

c1 = [0 .2 .7];
c2 = [.8 0 .4];


estUs  = load('../ESTIMTMP/spswUsEstimV1_results');
UsMUZ  = estUs.oo_.posterior_mean.parameters.MUZ ;
UsRHO  = estUs.oo_.posterior_mean.parameters.RHO ;
UsxMUZ = load('../RESULTS/resultsMUZBasicMeanUS.mat');
idUs   = find(UsxMUZ.vecrStar==400*((1+UsMUZ)*(1+UsRHO)-1));

figure
hp = plot(UsxMUZ.vecrStar,UsxMUZ.vecPiStar,UsxMUZ.vecrStar,UsxMUZ.vecEPiStar);
set(hp(1),'marker','o','markerfacecolor',c1,'markeredgecolor',c1,'linestyle','--','color',c1)
set(hp(2),'marker','s','markerfacecolor',c2,'markeredgecolor',c2,'linestyle','--','color',c2)
grid on
set(gca,'fontname','times','fontsize',15);
xlb = xlabel('Annualized steady-state real interest rate');
set(xlb,'interpreter','latex')
ylb = ylabel('$\pi^\star$, $\bar{\pi}$ (annualized)');
set(ylb,'interpreter','latex')
set(gca,'ylim',[-1.5 4],'xtick',0:12)
ylim = get(gca,'ylim');
xlim = get(gca,'xlim');
hold on
hl1 = line(UsxMUZ.vecrStar([idUs idUs]),[ylim(1) UsxMUZ.vecEPiStar(idUs)]);
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])
hl1 = line([xlim(1) UsxMUZ.vecrStar(idUs)],UsxMUZ.vecEPiStar([idUs idUs]));
set(hl1,'linewidth',2,'linestyle','--','color',[0.5 0.5 0.5])

lgd = legend([hp(1) hp(2)],strLabel);
set(lgd,'box','off','interpreter','latex','fontsize',12)

% -------------------------------------------------------------------------
% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure13');


headers = {'Rstar 1','Pistar Baseline','Rstar 2','Pistar Alternative'};
values  = num2cell([UsxMUZ.vecrStar,UsxMUZ.vecPiStar,UsxMUZ.vecrStar,UsxMUZ.vecEPiStar]);    
xlswrite('.\XLSFILES\dataForFigure13.xlsx', [headers; values]);