% This code produces FIGURE 12 for BPEA paper Andrade Gali Le Bihan Matheron

% Generates the figures for the Bayesian Welfare as a function of pistar
% using two different sets of distributions: the first one is the benchmark
% and the second is the tilted distribution when muz is uniformly set
% 100 basis points lower than its actual draw
% Importantly, all the MP parameters are frozen at the posterior mean

addpath ../RESULTS

%NOTE HERVE needs this to have access to "isfile.m":
%addpath('C:\Program Files (x86)\Dynare\4.4.3\matlab\utilities\general')

addpath('C:\Program Files (x86)\Dynare\4.5.3\matlab\utilities\general')
addpath('C:\Program Files (x86)\Dynare\4.5.3\matlab\missing\isfile')
addpath('C:\Program Files (x86)\Dynare\4.5.3\matlab')


idCountry = 'US';


% Retrieve Bayesian welfare from this information
% -------------------------------------------------------------------------
[ Welfare1, Welfare2 ] = retrieveBayesianWelfareAlt(idCountry);

% Prepare the graph
% -------------------------------------------------------------------------
NN       = 51;
pmin     = 1.020;
pmax     = 1.040;
vpistar1 = linspace(pmin,pmax,NN) ;
vpistar2 = vpistar1;
id1      = find(Welfare1==max(Welfare1));
id2      = find(Welfare2==max(Welfare2));
s1       = sprintf('Average welfare over posterior distribution of $\\theta$');
s2       = sprintf('Average welfare over perturbed posterior distribution of $\\theta$');
c1       = [0.0 0.2 0.7];
c2       = [0.9 0.0 0.1];


% Final plot
% -------------------------------------------------------------------------
figure
hp = plot(...
    100*(vpistar1-1),Welfare1-Welfare1(id1),...
    100*(vpistar2-1),Welfare2-Welfare2(id2));
set(hp,'linewidth',2)
set(hp(1),'color',c1)
set(hp(2),'color',c2,'linestyle',':')
set(gca,'fontname','times','ylim',[-4 0],'xlim',[2 5],'fontsize',15)
xlabel('Annualized inflation rate')
ylabel('Welfare (normalized)')
grid on
ylim = get(gca,'ylim');
h1 = line([100*(vpistar1(id1)-1) 100*(vpistar1(id1)-1)],ylim);
set(h1,'linestyle','--','color',c1);
h2 = line([100*(vpistar2(id2)-1) 100*(vpistar2(id2)-1)],ylim);
set(h2,'linestyle','--','color',c2);

lgd = legend(hp,s1,s2);
set(lgd,'box','off','interpreter','latex','location','southeast','fontsize',10);

% Create text
s1 = sprintf('$4\\pi^{\\star\\star}=%1.2f$',100*(vpistar1(id1)-1));
text('Parent',gca,'VerticalAlignment','baseline','FontName','Times',...
    'fontsize',15,...
    'Interpreter','latex',...
    'String',s1,...
    'Position',[100*(vpistar1(id1)-1) -2 0],...
    'Color',[0 0.2 0.7],...
    'backgroundcolor',[1 1 1]);

% Create text
s2 = sprintf('$4\\pi^{\\star\\star}=%1.2f$',100*(vpistar2(id2)-1));
text('Parent',gca,'VerticalAlignment','baseline','FontName','Times',...
    'fontsize',15,...
    'Interpreter','latex',...
    'String',s2,...
    'Position',[100*(vpistar2(id2)-1) -3 0],...
    'Color',[0.7 0.2 0],...
    'backgroundcolor',[1 1 1]);



% Save the figure in the appropriate directory
% -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure12');

headers = {'Pistar 1','Welfare Baseline','Pistar 2','Welfare Counterfactual'};
values  = num2cell([100*(vpistar1-1)',Welfare1-Welfare1(id1),100*(vpistar2-1)',Welfare2-Welfare2(id2)]);    
xlswrite('.\XLSFILES\dataForFigure12.xlsx', [headers; values]);
