% This code produces FIGURE 10 for BPEA paper Andrade Gali Le Bihan Matheron
%
% Generates the figures for the PDFs of pistar and rstar as well as the
% counterfactual pdf's with a lower rstar

addpath ../UTILITIES
addpath ../RESULTS


addpath('C:\Program Files (x86)\Dynare\4.5.3\matlab\utilities\general')
addpath('C:\Program Files (x86)\Dynare\4.5.3\matlab\missing\isfile')
addpath('C:\Program Files (x86)\Dynare\4.5.3\matlab')

idCountry = 'US';


% List of registered users
idUserCell = {'PHA','HLB','JUM'} ;

% Max number of blocks considered
Nblocks = 7;

% Useful variable
indulge_HLB = 0;


% 1. --- Retrieve the results
% -------------------------------------------------------------------------

% Initialze
chkDraw   = [];
chkDrawCf = chkDraw;
Welfare   = [];
WelfareCf = Welfare;
PiGrid    = [];
PiGridCf  = PiGrid;
drawsid   = [];

% Loop over users
for iter=1:length(idUserCell)
    
    % Loop over blocks
    for idBlock = 1:Nblocks
        
        % US case
        fname1 = ['../RESULTS/fullSimulationUSBlock',num2str(idBlock),idUserCell{iter}];
        fname2 = ['../RESULTS/fullSimulationCfUSBlock',num2str(idBlock),idUserCell{iter}];
        
        
        chk1 = isfile([fname1,'.mat']);
        chk2 = isfile([fname2,'.mat']);
        
        % Check that result files exist
        if chk1 && chk2
            
            x1 = load(fname1);
            x2 = load(fname2);
            
            % Right-concatenate the results
            chkDraw   = [chkDraw x1.chkDraw'];
            chkDrawCf = [chkDrawCf x2.chkDraw'];
            Welfare   = [Welfare x1.Welfare];
            WelfareCf = [WelfareCf x2.WelfareCf];
            PiGrid    = [PiGrid x1.PiGrid ];
            PiGridCf  = [PiGridCf x2.PiGridCf ];
            drawsid   = [drawsid x1.drawsid ];
            
        end
        
    end
    
end

pm      =  load(['paramDrawsFile',idCountry]);  % With idCountry
parm    = pm.coll(:,drawsid);
% -------------------------------------------------------------------------


tol = -1e2;


sel1      = find((chkDraw>0).*(chkDrawCf>0)>0) ;
w         = Welfare(:,sel1);
wCf       = WelfareCf(:,sel1);
PiGrid    = PiGrid(:,sel1);
PiGridCf  = PiGridCf(:,sel1);
parm      = parm(:,sel1);

Nw        = size(wCf,2);
[~,i1]    = find(w<tol);
[~,i2]    = find(wCf<tol);
sel2      = setdiff(1:Nw,unique([unique(i1);unique(i2)]));


Welfare   = w;
WelfareCf = wCf;


% 2. --- Plots
% -------------------------------------------------------------------------
Welfare   = Welfare(:,sel2);
PiGrid    = PiGrid(:,sel2);
WelfareCf = WelfareCf(:,sel2);
PiGridCf  = PiGridCf(:,sel2);
parm      = parm(:,sel2);
% -------------------------------------------------------------------------
MUZ     = parm(2,:)';  
RHO     = parm(1,:)';
rStar   = 400*(MUZ+RHO);


[~,Ndraw] = size(Welfare);
piStar = zeros(Ndraw,1);
for iter = 1:Ndraw
    [M,I] = max(Welfare(:,iter),[],1);
    piStar(iter) = PiGrid(I,iter);
end


[~,Ndraw] = size(WelfareCf);
piStarCf = zeros(Ndraw,1);
for iter = 1:Ndraw
    [M,I] = max(WelfareCf(:,iter),[],1);
    piStarCf(iter) = PiGridCf(I,iter);
end


if ~indulge_HLB
    x = mean(100*(piStar-1)) ;
    xCf = mean(100*(piStarCf-1)) ;
else
    x = median(100*(piStar-1)) ;
    xCf = median(100*(piStarCf-1)) ;
end


% Compute pistarstar
Nblocks = 2;
[ Welfare1, Welfare2 ] = retrieveBayesianWelfare(idCountry);
NN       = 51;
pmin     = 1.020;
pmax     = 1.070;
vpistar1 = linspace(pmin,pmax,NN) ;
vpistar2 = vpistar1;
id1      = find(Welfare1==max(Welfare1));
id2      = find(Welfare2==max(Welfare2));



% PLOT DISTRIBUTION OF R-STAR AND CONTERFACTUAL
% -------------------------------------------------------------------------
[f,xi]=ksdensity(rStar,'npoint',50,'width',0.4);
[fCf,xiCf]=ksdensity(rStar-1,'npoint',50,'width',0.4);

figure
hp = plot(xi,f,xiCf,fCf);
c1 = [0.0 0.0 0.0]; %[0.0 0.2 0.7];
c2 = [0.5 0.5 0.5]; %[0.9 0.0 0.1];
set(hp(1),'linewidth',2,'color',c1)
set(hp(2),'linewidth',2,'color',c2)
set(gca,'fontname','times','fontsize',15)
ylim = get(gca,'ylim');
hold on
if ~indulge_HLB
    hl1 = line([mean(rStar) mean(rStar)],ylim);
else
    hl1 = line([median(rStar) median(rStar)],ylim);
end
set(hl1,'linestyle','--','color',c1,'linewidth',2)
hold on
hl2 = line([mean(rStar) mean(rStar)]-1,ylim);
set(hl2,'linestyle','--','color',c2,'linewidth',2)
xlabel('Annualized steady-state real interest rate')
ylabel('PDF')
grid on
hold off
set(gca,'xlim',[0 5],'ylim',ylim)

% Create arrow
[fx,fy] = dsxy2figxy(gca,[mean(rStar),mean(rStar)-1],[0.5*ylim(2),0.5*ylim(2)]);
annotation(gcf,'arrow',fx,fy);

% % -------------------------------------------------------------------------
% % Save the figure in the appropriate directory
% % -------------------------------------------------------------------------
screen2pdf('../../TEXFILES/FIGURES/Figure10');

headers = {'Rstar 1','PDF Baseline','Rstar 2','PDF Counterfactual'};
values  = num2cell([xi',f',xiCf',fCf']);    
xlswrite('.\XLSFILES\dataForFigure10.xlsx', [headers; values]);
