% This file automatically retrieves all the information contained in the
% estimation files and generates a LaTeX table (to be included in the
% source LaTeX file


% Pass the directory pathes
addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

% Parameters that are to be multiplied by 100
test = {'RHO','MUZ','PISTAR'};

% Names of the prior
priorNames = {'Beta';'Gamma';'Normal';'Inverse Gamma'};

% US Results
idCountry = 'US' ;
radical = 'spswUs' ;
load([radical,'EstimV1_results']);
priorType = bayestopt_.pshape;
pnames = fieldnames(oo_.posterior_mean.parameters) ;
prior_mean = oo_.prior.mean;
prior_std  = sqrt(diag(oo_.prior.variance));
texnames   = M_.param_names_tex(estim_params_.param_vals(:,1),:);


fid = fopen(['../TABLES/EstimationTable',idCountry,'.tex'],'w+');
fprintf(fid,'%s \n','\begin{tabularx}{\textwidth}{llYYYYYY}');
fprintf(fid,'\\toprule \n');
fprintf(fid,'%-14s & %-15s & %-10s & %-10s & %-10s & %-10s & %-10s & %-10s \\\\ \n',...
    'Parameter',...
    'Prior Shape',...
    'Prior Mean',...
    'Priod std',...
    'Post. Mean',...
    'Post. std',...
    'Low',...
    'High');
fprintf(fid,'\\midrule \n');
for iter = 1:length(pnames)
    
    id = any(strcmp(pnames{iter},test));

    if ~id
        fprintf(fid,'$%-12s$ & %-15s & %-10.2f & %-10.2f & %-10.2f & %-10.2f & %-10.2f  & %-10.2f \\\\\n',...
            texnames(iter,:),...
            priorNames{priorType(iter)},...
            prior_mean(iter),...
            prior_std(iter),...        
            oo_.posterior_mean.parameters.(pnames{iter}),...
            oo_.posterior_std.parameters.(pnames{iter}),...
            oo_.posterior_hpdinf.parameters.(pnames{iter}),...
            oo_.posterior_hpdsup.parameters.(pnames{iter})...
            );
    else
        fprintf(fid,'$%-12s$ & %-15s & %-10.2f & %-10.2f & %-10.2f & %-10.2f & %-10.2f  & %-10.2f \\\\\n',...
            texnames(iter,:),...
            priorNames{priorType(iter)},...
            100*prior_mean(iter),...
            100*prior_std(iter),...        
            100*oo_.posterior_mean.parameters.(pnames{iter}),...
            100*oo_.posterior_std.parameters.(pnames{iter}),...
            100*oo_.posterior_hpdinf.parameters.(pnames{iter}),...
            100*oo_.posterior_hpdsup.parameters.(pnames{iter})...
            );
    end 
end
fprintf(fid,'\\bottomrule\n');
fprintf(fid,'%s \n','\end{tabularx}');
fclose(fid);

% Euro Area Results
idCountry = 'EZ' ;
radical = 'spswEz';
load([radical,'EstimV1_results']);
priorType = bayestopt_.pshape;
pnames = fieldnames(oo_.posterior_mean.parameters) ;
prior_mean = oo_.prior.mean;
prior_std  = sqrt(diag(oo_.prior.variance));
texnames   = M_.param_names_tex(estim_params_.param_vals(:,1),:);


fid = fopen(['../TABLES/EstimationTable',idCountry,'.tex'],'w+');
fprintf(fid,'%s \n','\begin{tabularx}{\textwidth}{llYYYYYY}');
fprintf(fid,'\\toprule \n');
fprintf(fid,'%-14s & %-15s & %-10s & %-10s & %-10s & %-10s & %-10s & %-10s \\\\ \n',...
    'Parameter',...
    'Prior Shape',...
    'Prior Mean',...
    'Priod std',...
    'Post. Mean',...
    'Post. std',...
    'Low',...
    'High');
fprintf(fid,'\\midrule \n');
for iter = 1:length(pnames)
    
    id = any(strcmp(pnames{iter},test));

    if ~id
        fprintf(fid,'$%-12s$ & %-15s & %-10.2f & %-10.2f & %-10.2f & %-10.2f & %-10.2f  & %-10.2f \\\\\n',...
            texnames(iter,:),...
            priorNames{priorType(iter)},...
            prior_mean(iter),...
            prior_std(iter),...        
            oo_.posterior_mean.parameters.(pnames{iter}),...
            oo_.posterior_std.parameters.(pnames{iter}),...
            oo_.posterior_hpdinf.parameters.(pnames{iter}),...
            oo_.posterior_hpdsup.parameters.(pnames{iter})...
            );
    else
        fprintf(fid,'$%-12s$ & %-15s & %-10.2f & %-10.2f & %-10.2f & %-10.2f & %-10.2f  & %-10.2f \\\\\n',...
            texnames(iter,:),...
            priorNames{priorType(iter)},...
            100*prior_mean(iter),...
            100*prior_std(iter),...        
            100*oo_.posterior_mean.parameters.(pnames{iter}),...
            100*oo_.posterior_std.parameters.(pnames{iter}),...
            100*oo_.posterior_hpdinf.parameters.(pnames{iter}),...
            100*oo_.posterior_hpdsup.parameters.(pnames{iter})...
            );
    end 
end
fprintf(fid,'\\bottomrule\n');
fprintf(fid,'%s \n','\end{tabularx}');
fclose(fid);
