% basicSim.m: basic simulation for a fixed structural parameter to draw 
% welfare as function of pistar
% ---> pick a country, by selecting idCountry, 
% ---> freeze the parameters at their posterior mean (mode, median)
% by selecting idLocation,

addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

%warning('off','all');

sep = '--------------------------------------------------------------';

idCountry = 'US';
idLocation = 'Mean';
radical = 'spswUs' ;

switch idLocation
    
    case 'Mean'
        
        loc = 'posterior_mean';
        
    case 'Median'
        
        loc = 'posterior_median';
        
    case 'Mode'
        
        loc = 'posterior_mode';
        
    otherwise
        
        warning('No such location available')
        return;        
end


% Load estimated model info
% -------------------------------------------------------------------------
load([radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_

% Then run your model with Dynare
% -------------------------------------------------------------------------
modnam   = 'spswSim' ;
eval(['dynare ',modnam,' noclearall nolog '])
% -------------------------------------------------------------------------
% After the above step, the M_ and oo_ in the workspace are those of the
% simulated model


% Assign estimated parameter values to the proper M_
% -------------------------------------------------------------------------
chkParams = zeros(size(M_.params,1),2) ;
chkParams(:,1) = M_.params ;
pnames = fieldnames(ooest.(loc).parameters);
for iter = 1:length(pnames)
    M_ = set_myparam_value(M_,pnames{iter},ooest.(loc).parameters.(pnames{iter}));
end
chkParams(:,2) = M_.params ;


% Create internal indexing of variables
% -------------------------------------------------------------------------
for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end
for iter = 1:size(M_.exo_names,1)
    eval([deblank(M_.exo_names(iter,:)),'pos = ',num2str(iter),';']);
end

% Indices of variables concerned by ZLB
% -------------------------------------------------------------------------
rpos  = Rpos ;
rspos = Rspos ;

MUZ = my_get_param_by_name('MUZ',M_) ;
RHO = my_get_param_by_name('RHO',M_) ;
ALPHAP = my_get_param_by_name('ALPHAP',M_) ;
ALPHAW = my_get_param_by_name('ALPHAW',M_) ;
FIR = my_get_param_by_name('FIR',M_) ;
FIP = my_get_param_by_name('FIP',M_) ;
FIY = my_get_param_by_name('FIY',M_) ;
FIX = my_get_param_by_name('FIX',M_) ;
R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
rb = - R + ELBBAR;


% Time-series length of each simulation
% ---------------------------------------------------------------------
Nburnin     = 0;
Nsample     = 100;
Nseries     = 1;
tolR        = 1e-6;





% Create the shocks
% -------------------------------------------------------------------------
% Preallocate
% -------------------------------------------------------------------------
shock = zeros(M_.exo_nbr,Nburnin+Nsample);
% -------------------------------------------------------------------------
% Set risk premium shock
% -------------------------------------------------------------------------
shock(eqpos,2:6) = 3;
x1 = simulateModelUnderZlb(M_,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);

% Our rule is of the form:
%  Rs = FIR*Rs(-1) 
%     + (1-FIR)*(FIP*pip + .25*FIX*x+ .25*FIY*(x-x(-1))) + zeR; with 
% With FYI = 0
%
% What if instead it had the form 
%  Rs = FIR*R(-1) 
%     + (1-FIR)*(FIP*pip + .25*FIX*x+ .25*FIY*(x-x(-1))) + zeR;
%
pipsim = x1(pippos,:);
xsim   = x1(xpos,:);
Rsim   = x1(Rpos,:);
Rscf  = zeros(size(Rsim));
for it=2:length(Rscf)
    Rscf(it) = FIR*max(-R,Rscf(it-1)) + (1-FIR)*(FIP*pipsim(it) + 0.25*FIX*xsim(it)) ;
end
Rcf    = max(-R,Rscf);


c1 = [70,130,180]/255;
figure
smpl = 1:41;
subplot(3,1,1)
hp = plot(smpl-1,400*x1(rpos,smpl),smpl-1,400*Rcf(smpl));
set(hp,'linewidth',2);
set(hp(1),'color',c1)
set(hp(2),'linestyle','--','color',c1)
set(gca,'fontname','times')
title('Short-term nominal interest rate (annualized)')

subplot(3,1,2)
hp = plot(smpl-1,400*x1(pippos,smpl));
set(hp,'linewidth',2,'color',c1);
set(gca,'fontname','times')
title('Quarterly inflation rate (annualized)')

subplot(3,1,3)
hp = plot(smpl-1,100*x1(ypos,smpl));
set(hp,'linewidth',2,'color',c1);
set(gca,'fontname','times')
title('Output')

set(gcf,'PaperType','<custom>','PaperSize',[20.4 15.25],'PaperPosition',[0.1 0.02158 20.3046 15.2284]);
print(gcf,'-dpdf','../FIGURES/figLower4Longer.pdf')