
idCountry  = 'US';
idLocation = 'Mean'; 
radical = 'spswUs' ;
xlim = [1.5 4];

switch idLocation
    
    case 'Mean'
        
        loc = 'posterior_mean';
        
    case 'Median'
        
        loc = 'posterior_median';
        
    case 'Mode'
        
        loc = 'posterior_mode';
        
    otherwise
        
        warning('No such location available')
        return;        
end


% Load results
% -------------------------------------------------------------------------
fname = ['../RESULTS/basicResults',idLocation,idCountry] ;
load([radical,'EstimV1_results']);
load(fname)
% Mest  = M_ ;
ooest = oo_;



% Assign estimated parameter values to the proper M_
% -------------------------------------------------------------------------
chkParams = zeros(size(M_.params,1),2) ;
chkParams(:,1) = M_.params ;
pnames = fieldnames(ooest.(loc).parameters);
for iter = 1:length(pnames)
    M_ = set_myparam_value(M_,pnames{iter},ooest.(loc).parameters.(pnames{iter}));
end
chkParams(:,2) = M_.params ;


% Compute WelCost
% -------------------------------------------------------------------------
RHO         = my_get_param_by_name('RHO',M_) ;
BETA        = 1/(1+RHO);
idMax       = find(Welfare==max(Welfare)) ;
WelfareCost = exp((Welfare(idMax)-Welfare)*(1-BETA))-1;

c1 = [0 .2 .5];

figure
hp = plot(100*(vpistar-1),100*WelfareCost);
set(hp,'linewidth',2,'color',c1)
set(gca,'fontname','times','fontsize',15,'xlim',xlim)
xlb = xlabel('Annualized inflation rate');
ylb = ylabel({'Steady-state welfare cost of inflation','(in % of consumption at optimal inflation)'});
grid

%Save the figure in the appropriate directory
%-------------------------------------------------------------------------
set(gcf,'PaperType','<custom>','PaperSize',[20.4 15.25],'PaperPosition',[0.1 0.02158 20.3046 15.2284]);
print(gcf,'-dpdf',['../FIGURES/basicWelfareCostFigure',idCountry])
