%---  Exercize_muzBasic : Computes Pi_star for a range of values of Mu_z 
%---  User can choose Country and select one parameter (Location) draw; 

addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP
addpath ../RESULTS

sep = '--------------------------------------------------------------';

idCountry  = 'US' ;

idLocation = 'Mean' ; % Mean, Median, Mode

fname = ['basicResults','Mean',idCountry] ;
eval(['x1 = load(''',fname,''');'])
vpistar1 = x1.vpistar;
Welfare1 = x1.Welfare;
id1      = find(Welfare1==max(Welfare1));
fname = ['basicResultsCf','Mean',idCountry] ;
eval(['x2 = load(''',fname,''');'])
vpistar2 = x2.vpistar;
Welfare2 = x2.Welfare;
id2      = find(Welfare2==max(Welfare2));

vpistar  = [vpistar1(id1) vpistar2(id2)] ;


% Creates information relative to the estimation file
% -------------------------------------------------------------------------
switch idCountry
    
    case 'EZ'
        
        radical = 'spswEz';
        
    case 'US'
        
        radical = 'spswUs' ;
        
    otherwise
        
        warning('No such country available')
        return;        
end

% Picks the appropriate location parameter
% -------------------------------------------------------------------------
switch idLocation
    
    case 'Mean'
        
        loc = 'posterior_mean';
        
    case 'Median'
        
        loc = 'posterior_median';
        
    case 'Mode'
        
        loc = 'posterior_mode';
        
    otherwise
        
        warning('No such location available')
        return;        
end

fname = ['../RESULTS/resultsMUZBasic',idLocation,idCountry];
checkForFile = exist([fname,'.mat'],'file')>0 ;
if checkForFile
    fprintf('===> Initial results available\n')
    init = load(fname) ;
end
        
% Load estimated model info
% -------------------------------------------------------------------------
load([radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_

% Then run your model with Dynare - this creates M_ and oo_
% -------------------------------------------------------------------------
modnam   = 'spswSim' ;
eval(['dynare ',modnam,' noclearall nolog '])


% Assign estimated parameter values to the proper M_
% -------------------------------------------------------------------------
chkParams = zeros(size(M_.params,1),2) ;
chkParams(:,1) = M_.params ;
pnames = fieldnames(ooest.(loc).parameters);
for iter = 1:length(pnames)
    M_ = set_myparam_value(M_,pnames{iter},ooest.(loc).parameters.(pnames{iter}));
end
chkParams(:,2) = M_.params ;


% Create internal indexing of variables
% -------------------------------------------------------------------------
for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end


% Indices of variables concerned by ZLB
% ---------------------------------------------------------------------
rpos  = Rpos ;
rspos = Rspos ;


% Size of the vector of values for annual inflation target
% ---------------------------------------------------------------------
NN            = 51;

% Number of values of MUZ considered (Posterior Mean is included)  
% -------------------------------------------------------------------------
NumberOfMUZs  = 30;
MUZ           = my_get_param_by_name('MUZ',M_) ;
aaa           = 3 ;
MUZmin        = 0.0010;
MUZmax        = 0.0250;
vMUZ          = (exp(linspace(0,log(400*MUZmax+1-400*MUZmin),NumberOfMUZs))-1+400*MUZmin)/400 ;
vMUZ          = sort([vMUZ,MUZ,MUZ-1/400]);
KK            = length(vMUZ);

% Time-series length of each simulation
% ---------------------------------------------------------------------
Nburnin       = 1000;
Nsample       = 100000;
tolR          = 1e-6;

% Create the shocks
% -------------------------------------------------------------------------
shock = generateTheShocks(M_.exo_nbr,Nburnin+Nsample);


% Preallocate storage matrices
% -------------------------------------------------------------------------
Npi         = length(vpistar);
vecPiStar   = zeros(KK,Npi) ;
vecrStar    = zeros(KK,Npi) ;
vecInfoSim  = zeros(KK,Npi) ;
vecEPiStar  = zeros(KK,Npi) ;
vecZLB      = zeros(KK,Npi) ;


% Main Loop over MUZs
% -------------------------------------------------------------------------
for ids = 1:KK
    
    Mt0 = M_ ;
    MUZ  = vMUZ(ids) ;
    fprintf('\t MUZ = %1.4f ---> ',MUZ)
    Mt0 = set_myparam_value(Mt0,'MUZ',MUZ) ;

    RHO = my_get_param_by_name('RHO',Mt0) ;
    
    fprintf('Real Rate (annualized) = %1.8f\n',400*(MUZ+RHO))
    
    
    t0 = clock ;
    Welfare  = zeros(NN,1);   
    EPIP     = zeros(NN,1);   
    vpZLB    = zeros(NN,1);   
    
    for iter=1:length(vpistar)    
        Mt = Mt0 ;
        
        % -----------------------------------------------------------------
        PISTAR = vpistar(iter)^.25-1;
        fprintf('\t\t PISTAR = %1.4f \n',PISTAR)
        R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
        rb = - R + ELBBAR;
                
        %------------------------------------------------------------------
        Mt = set_myparam_value(Mt,'PISTAR',PISTAR) ;
        x  = simulateModelUnderZlb(Mt,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);
        X = x(:,Nburnin+1:Nsample+Nburnin);
        
        % Compute ZLB proba
        %------------------------------------------------------------------
        dumZLB = X(rpos,:)<=rb+tolR;
        pZLB   = 100*mean(dumZLB);
        
        
        % Compute Welfare
        % -----------------------------------------------------------------
        PIPSIM        = X(pippos,:);
        PIWSIM        = X(piwpos,:);
        XSIM          = X(xpos,:);
        Xsim          = [PIPSIM;PIWSIM;XSIM] ;

        t1 = clock ;
        
        vecZLB(ids,iter)   = pZLB;
        vecrStar(ids,iter) = 400*((1+MUZ)*(1+RHO)-1);

    end
end


fname = ['../RESULTS/resultsRstarZlb',idLocation,idCountry];
save(fname,'vecrStar','vecZLB','vpistar')
