%---  Exercize_RHObasic : Computes Pi_star for a range of values of Mu_z 
%---  User can choose Country and select one parameter (Location) draw; 

addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

sep = '--------------------------------------------------------------';

% idCountry  = 'EZ' ;
% idLocation = 'Mean' ; % Mean, Median, Mode


% Creates information relative to the estimation file
% -------------------------------------------------------------------------
idCountry = 'US';
radical = 'spswUs' ;

% Picks the appropriate location parameter
% -------------------------------------------------------------------------
switch idLocation
    
    case 'Mean'
        
        loc = 'posterior_mean';
        
    case 'Median'
        
        loc = 'posterior_median';
        
    case 'Mode'
        
        loc = 'posterior_mode';
        
    otherwise
        
        warning('No such location available')
        return;        
end

fname = ['../RESULTS/resultsRHOBasic',idLocation,idCountry];
checkForFile = exist([fname,'.mat'],'file')>0 ;
if checkForFile
    fprintf('===> Initial results available\n')
    init = load(fname) ;
end


% Load estimated model info
% -------------------------------------------------------------------------
load([radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_

% Then run your model with Dynare - this creates M_ and oo_
% -------------------------------------------------------------------------
modnam   = 'spswSim' ;
eval(['dynare ',modnam,' noclearall nolog '])


% Assign estimated parameter values to the proper M_
% -------------------------------------------------------------------------
chkParams = zeros(size(M_.params,1),2) ;
chkParams(:,1) = M_.params ;
pnames = fieldnames(ooest.(loc).parameters);
for iter = 1:length(pnames)
    M_ = set_myparam_value(M_,pnames{iter},ooest.(loc).parameters.(pnames{iter}));
end
chkParams(:,2) = M_.params ;


% Create internal indexing of variables
% -------------------------------------------------------------------------
for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end


% Indices of variables concerned by ZLB
% ---------------------------------------------------------------------
rpos  = Rpos ;
rspos = Rspos ;


% Size of the vector of values for annual inflation target
% ---------------------------------------------------------------------
NN            = 51;

% Number of values of RHO considered (Posterior Mean is included) 
% -------------------------------------------------------------------------
NumberOfRHOs  = 30;
RHO           = my_get_param_by_name('RHO',M_) ;
aaa           = 3 ;
RHOmin        = 0.0010;
RHOmax        = 0.0250;
vRHO          = (exp(linspace(0,log(400*RHOmax+1-400*RHOmin),30))-1+400*RHOmin)/400 ;
vRHO          = sort([vRHO,RHO]);
KK            = length(vRHO);


% Time-series length of each simulation
% ---------------------------------------------------------------------
Nburnin       = 1000;
Nsample       = 100000;
tolR          = 1e-6;

% Create the shocks
% -------------------------------------------------------------------------
shock = generateTheShocks(M_.exo_nbr,Nburnin+Nsample);

% Preallocate storage matrices
% -------------------------------------------------------------------------
vecPiStar   = zeros(KK,1) ;
vecrStar    = zeros(KK,1) ;
vecInfoSim  = zeros(KK,1) ;
vecEPiStar  = zeros(KK,1) ;
vecZLB      = zeros(KK,1) ;


% Main Loop over MUZs
% -------------------------------------------------------------------------
for ids = 1:KK
    
    Mt0 = M_ ;
    RHO  = vRHO(ids) ;
    fprintf('\t RHO = %1.4f ---> ',RHO)
    Mt0 = set_myparam_value(Mt0,'RHO',RHO) ;
    MUZ = my_get_param_by_name('MUZ',Mt0) ;
    
    if ~checkForFile
        pmin = 0.99;
        if 400*(MUZ+RHO) < 4
            pmin = 1.005;
        end
        pmax = 1.05;
    else
        z = init.vecPiStar(ids)/100 ;
        pmin = (1+z)-0.25*z;
        pmax = (1+z)+0.25*z;
    end
    
    
    fprintf('Real Rate (annualized) = %1.8f\n',400*(MUZ+RHO))
    vpistar  = linspace(pmin,pmax,NN) ;
    
    t0 = clock ;
    Welfare  = zeros(NN,1);
    EPIP     = zeros(NN,1);
    vpZLB    = zeros(NN,1);

    % Loop over PISTAR
    % ---------------------------------------------------------------------
    parfor iter = 1:length(vpistar)
        
        
        Mt = Mt0 ;
        
        % -----------------------------------------------------------------
        PISTAR = vpistar(iter)^.25-1;
        fprintf('\t\t PISTAR = %1.4f \n',PISTAR)
        R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
        rb = - R + ELBBAR;
                
        %------------------------------------------------------------------
        Mt = set_myparam_value(Mt,'PISTAR',PISTAR) ;
        x  = simulateModelUnderZlb(Mt,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);
        X = x(:,Nburnin+1:Nsample+Nburnin);
        
        % Compute ZLB proba
        %------------------------------------------------------------------
        dumZLB = X(rpos,:)<=rb+tolR;
        pZLB   = 100*mean(dumZLB);
        
        
        % Compute Welfare
        % -----------------------------------------------------------------
        PIPSIM        = X(pippos,:);
        PIWSIM        = X(piwpos,:);
        XSIM          = X(xpos,:);
        Xsim          = [PIPSIM;PIWSIM;XSIM] ;
        Welfare(iter) = computeWelfare(Mt,Xsim) ;
        EPIP(iter)    = PISTAR + mean(PIPSIM) ;
        vpZLB(iter)   = pZLB;
        
        
    end
    t1 = clock ;
    
    vecPiStar(ids)  = 100*(vpistar(Welfare==max(Welfare))-1);
    vecEPiStar(ids) = 400*EPIP(Welfare==max(Welfare));
    vecZLB(ids)     = vpZLB(Welfare==max(Welfare));
    vecrStar(ids)   = 400*((1+MUZ)*(1+RHO)-1);
    vecInfoSim(ids) = etime(t1,t0);
    
end


fname = ['../RESULTS/resultsRHOBasic',idLocation,idCountry];
save(fname,'vRHO','vecPiStar','vecEPiStar','vecInfoSim','vecrStar','vecZLB')

plot(400*vRHO,vecPiStar,'o')

