%---  Exercize_muzBasic : Computes Pi_star for a range of values of Mu_z 
%---  User can choose Country and select one parameter (Location) draw; 

addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

sep = '--------------------------------------------------------------';

idCountry  = 'US' ;
idLocation = 'Mean' ; % Mean, Median, Mode
radical = 'spswUs' ;


% Picks the appropriate location parameter
% -------------------------------------------------------------------------
switch idLocation
    
    case 'Mean'
        
        loc = 'posterior_mean';
        
    case 'Median'
        
        loc = 'posterior_median';
        
    case 'Mode'
        
        loc = 'posterior_mode';
        
    otherwise
        
        warning('No such location available')
        return;        
end

fname = ['../RESULTS/resultsMUZBasic',idLocation,idCountry];
checkForFile = exist([fname,'.mat'],'file')>0 ;
if checkForFile
    fprintf('===> Initial results available\n')
    init = load(fname) ;
end
        
% Load estimated model info
% -------------------------------------------------------------------------
load([radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_

% Then run your model with Dynare - this creates M_ and oo_
% -------------------------------------------------------------------------
modnam   = 'spswSim2' ;
eval(['dynare ',modnam,' noclearall nolog '])


% Assign estimated parameter values to the proper M_
% -------------------------------------------------------------------------
chkParams = zeros(size(M_.params,1),2) ;
chkParams(:,1) = M_.params ;
pnames = fieldnames(ooest.(loc).parameters);
for iter = 1:length(pnames)
    M_ = set_myparam_value(M_,pnames{iter},ooest.(loc).parameters.(pnames{iter}));
end
chkParams(:,2) = M_.params ;


% Create internal indexing of variables
% -------------------------------------------------------------------------
for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end


% Indices of variables concerned by ZLB
% ---------------------------------------------------------------------
rpos  = Rpos ;
rspos = Rspos ;


% Size of the vector of values for annual inflation target
% ---------------------------------------------------------------------
NN            = 51;

% Number of values of MUZ considered (Posterior Mean is included)  
% -------------------------------------------------------------------------
NumberOfMUZs  = 30;
MUZ           = my_get_param_by_name('MUZ',M_) ;
aaa           = 3 ;
MUZmin        = 0.0010;
MUZmax        = 0.0250;
vMUZ          = (exp(linspace(0,log(400*MUZmax+1-400*MUZmin),NumberOfMUZs))-1+400*MUZmin)/400 ;
vMUZ          = sort([vMUZ,MUZ]);
KK            = length(vMUZ);

% Time-series length of each simulation
% ---------------------------------------------------------------------
Nburnin       = 1000;
Nsample       = 100000;
tolR          = 1e-6;

% Create the shocks
% -------------------------------------------------------------------------
shock = generateTheShocks(M_.exo_nbr,Nburnin+Nsample);


% Preallocate storage matrices
% -------------------------------------------------------------------------
vecPiStar          = zeros(KK,1) ;
vecrStar           = zeros(KK,1) ;
vecInfoSim         = zeros(KK,1) ;
vecEPiStar         = zeros(KK,1) ;
vecZLB             = zeros(KK,1) ;
vMeanDuration      = zeros(KK,1) ;
vStdDuration       = zeros(KK,1) ;



% Main Loop over MUZs
% -------------------------------------------------------------------------
for ids = 1:KK
    
    Mt0 = M_ ;
    MUZ  = vMUZ(ids) ;
    fprintf('\t MUZ = %1.4f ---> ',MUZ)
    Mt0 = set_myparam_value(Mt0,'MUZ',MUZ) ;

    RHO = my_get_param_by_name('RHO',Mt0) ;
    
    if ~checkForFile
        pmin = 0.99;
        if 400*(MUZ+RHO) < 4
            pmin = 1.005;
        end
        pmax = 1.05;
    else
        z = init.vecPiStar(ids)/100 ;
        pmin = (1+z)-0;
        pmax = (1+z)+0.001;
    end
    fprintf('Real Rate (annualized) = %1.8f\n',400*(MUZ+RHO))
    vpistar  = linspace(pmin,pmax,NN) ;
    
    t0 = clock ;
    Welfare  = zeros(NN,1);   
    EPIP     = zeros(NN,1);   
    vpZLB    = zeros(NN,1);   
    
    % Loop over PISTAR
    % ---------------------------------------------------------------------
    parfor iter = 1:length(vpistar)
        
        Mt = Mt0 ;
        
        % -----------------------------------------------------------------
        PISTAR = vpistar(iter)^.25-1;
        fprintf('\t\t PISTAR = %1.4f \n',PISTAR)
        R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
        rb = - R + ELBBAR;
                
        %------------------------------------------------------------------
        Mt = set_myparam_value(Mt,'PISTAR',PISTAR) ;
        x  = simulateModelUnderZlb(Mt,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);
        X = x(:,Nburnin+1:Nsample+Nburnin);
        
        % Compute ZLB proba
        %------------------------------------------------------------------
        dumZLB = X(rpos,:)<=rb+tolR;
        pZLB   = 100*mean(dumZLB);
        
        % Duration
        % --------------------------------------------------------------------
        nbp = size(dumZLB,2);
        ix  = [ (find(dumZLB(1:nbp-1) ~= dumZLB(2:nbp)))' ; nbp];
        lengthEpisode = diff([ 0; ix ]);
        val = dumZLB(ix);
        ZLB_spells=lengthEpisode(val);
               
        
        % Compute Welfare
        % -----------------------------------------------------------------
        PIPSIM              = X(pippos,:);
        PIWSIM              = X(piwpos,:);
        XSIM                = X(xpos,:);
        Xsim                = [PIPSIM;PIWSIM;XSIM] ;
        Welfare(iter)       = computeWelfare(Mt,Xsim) ;
        EPIP(iter)          = PISTAR + mean(PIPSIM) ;
        vpZLB(iter)         = pZLB;
        vMeanDuration(iter) = mean(ZLB_spells);
        vStdDuration(iter)  = std(ZLB_spells);

    end
    t1 = clock ;
    
    vecPiStar(ids)  = 100*(vpistar(Welfare==max(Welfare))-1);
    vecEPiStar(ids) = 400*EPIP(Welfare==max(Welfare));
    vecZLB(ids)     = vpZLB(Welfare==max(Welfare));
    vecrStar(ids)   = 400*((1+MUZ)*(1+RHO)-1);
    vecInfoSim(ids) = etime(t1,t0);
    
end


save(fname,'vMUZ','vecPiStar','vecEPiStar','vecInfoSim','vecrStar','vecZLB')

figure
plot(400*vMUZ,vecPiStar,'o',400*vMUZ,vecEPiStar,'d')
grid

