% calculationsFigure1And2.m: basic simulation for a fixed structural parameter to draw 
% welfare as function of pistar

% by selecting idLocation,

addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

warning('off','all');

sep = '--------------------------------------------------------------';

idCountry = 'US' ;
radical = 'spswUs' ;

switch idLocation
    
    case 'Mean'
        
        loc = 'posterior_mean';
        
    case 'Median'
        
        loc = 'posterior_median';
        
    case 'Mode'
        
        loc = 'posterior_mode';
        
    otherwise
        
        warning('No such location available')
        return;        
end


% Load estimated model info
% -------------------------------------------------------------------------
load([radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_

% Then run your model with Dynare
% -------------------------------------------------------------------------
modnam   = 'spswSim' ;
eval(['dynare ',modnam,' noclearall nolog '])
% -------------------------------------------------------------------------
% After the above step, the M_ and oo_ in the workspace are those of the
% simulated model


% Assign estimated parameter values to the proper M_
% -------------------------------------------------------------------------
chkParams = zeros(size(M_.params,1),2) ;
chkParams(:,1) = M_.params ;
pnames = fieldnames(ooest.(loc).parameters);
for iter = 1:length(pnames)
    M_ = set_myparam_value(M_,pnames{iter},ooest.(loc).parameters.(pnames{iter}));
end
chkParams(:,2) = M_.params ;


% Create internal indexing of variables
% -------------------------------------------------------------------------

for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end

% Indices of variables concerned by ZLB
% -------------------------------------------------------------------------
rpos  = Rpos ;
rspos = Rspos ;


% Vector of values for annual inflation target
% -------------------------------------------------------------------------
NN            = 51;

% Time-series length of each simulation
% ---------------------------------------------------------------------
Nburnin     = 1000;
Nsample     = 100000;
Nseries     = 1;
tolR        = 1e-6;

MUZ = my_get_param_by_name('MUZ',M_) ;
RHO = my_get_param_by_name('RHO',M_) ;
ALPHAP = my_get_param_by_name('ALPHAP',M_) ;
ALPHAW = my_get_param_by_name('ALPHAW',M_) ;

pmin = 1.005;
pmax = 1.050;
vpistar  = linspace(pmin,pmax,NN) ;


Welfare = zeros(NN,Nseries);
EPIP    = zeros(NN,Nseries);
vpZLB   = zeros(NN,Nseries);

% Create the shocks
% -------------------------------------------------------------------------
shock = generateTheShocks(M_.exo_nbr,Nburnin+Nsample);

    
% Loop over PISTAR
% ---------------------------------------------------------------------
t00 = clock ;
parfor iter = 1:length(vpistar)
    
    t0 = clock ;
    % -----------------------------------------------------------------
    PISTAR = vpistar(iter)^.25-1;
    R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
    rb = - R + ELBBAR;
    
    
    %------------------------------------------------------------------
    M = M_;
    M = set_myparam_value(M,'PISTAR',PISTAR) ;
    
    
    x1 = simulateModelUnderZlb(M,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);
    X1 = x1(:,Nburnin+1:Nsample+Nburnin);
    
    % Compute ZLB proba
    %------------------------------------------------------------------
    dumZLB = X1(rpos,:)<=rb+tolR;
    pZLB   = 100*mean(dumZLB);

    
    % Compute Welfare
    % -----------------------------------------------------------------
    PIPSIM1 = X1(pippos,:);
    PIWSIM1 = X1(piwpos,:);
    XSIM1   = X1(xpos,:);
    Xsim1   = [PIPSIM1;PIWSIM1;XSIM1] ;
    Welfaret = computeWelfare(M,Xsim1);
    Welfare(iter) = Welfaret;
    EPIP(iter) = mean(PIPSIM1);
    vpZLB(iter) = pZLB;
    
    % -----------------------------------------------------------------    
    t1 = clock ;
        
    fprintf('Simulation # %-3d -- Elapsed time: %-10.5f\n',iter,etime(t1,t0))

end

% Draw a picture (not the final one)
idMax = find(Welfare==max(Welfare));
figure('Name',idCountry)
hp = plot(100*(vpistar-1),Welfare,100*(vpistar(idMax)-1),Welfare(idMax));
set(hp(1),'linestyle','-','color',[0 .2 .6])
set(hp(2),'linestyle','none','marker','o','markerfacecolor',[.5 0 0],'markeredgecolor',[.5 0 0])
grid on



% Save the results
fname = ['../RESULTS/basicResults',idLocation,idCountry] ;
save(fname,'vpistar','Welfare','EPIP','vpZLB');