%--- AGLBM : robustness exercize with no shadow rate in Taylor Rule (actual
%rate rather)
%---  Exercize_muzBasic : Computes Pi_star for a range of values of Mu_z 
%---  User can choose Country and select one parameter (Location) draw; 

addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

t0=clock;
sep = '--------------------------------------------------------------';

idCountry  = 'US' ;
idLocation = 'Mean' ; % Mean, Median, Mode
radical = 'spswUs' ;


% Picks the appropriate location parameter
% -------------------------------------------------------------------------
switch idLocation
    
    case 'Mean'
        
        loc = 'posterior_mean';
        
    case 'Median'
        
        loc = 'posterior_median';
        
    case 'Mode'
        
        loc = 'posterior_mode';
        
    otherwise
        
        warning('No such location available')
        return;        
end

        
% Load estimated model info
% -------------------------------------------------------------------------
load([radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_


% Type of counterfaxctual
% -------------------------------------------------------------------------


cfId = '_';

%cfId = 'FIPLO';

%switch cfId
%    
%        
%    case 'FIPLO'
%        
%        cfpnames = {'FIP','FIR'};
%        cfpval   = [0.10 0]; 
%        
%    case 'FIPME'
%        
%        cfpnames = {'FIP','FIR'};
%        cfpval   = [0.50 0];
%        
%    case 'FIPHI'
%        
%        cfpnames = {'FIP','FIR'};
%        cfpval   = [1.00 0];
%
%    otherwise
%        
%        error('No such counterfactual')
%        
%end

%Checks whether inital values/results exist
fname = ['../RESULTS/resultsNoShadowTR',cfId,idLocation,idCountry];
checkForFile = exist([fname,'.mat'],'file')>0 ;
if checkForFile
    fprintf('===> Initial results available\n')
    init = load(fname) ;
    init_vecPiStar =init.vecPiStar; 
end


% Then run your model with Dynare - this creates M_ and oo_
% -------------------------------------------------------------------------
% Note model is different from baseline model
modnam   = 'spswNoShadowTRSim.mod' ;
eval(['dynare ',modnam,' noclearall nolog '])


% Assign estimated parameter values to the proper M_
% -------------------------------------------------------------------------
chkParams = zeros(size(M_.params,1),2) ;
chkParams(:,1) = M_.params ;
pnames = fieldnames(ooest.(loc).parameters);
for iter = 1:length(pnames)
    M_ = set_myparam_value(M_,pnames{iter},ooest.(loc).parameters.(pnames{iter}));
end
chkParams(:,2) = M_.params ;

% % Then assign correct values to chosen elasticities of substitution
% % -------------------------------------------------------------------------
% for iter = 1:length(cfpnames)
%     M_ = set_myparam_value(M_,cfpnames{iter},cfpval(iter)); %%%%
% end
% chkParams = [chkParams M_.params] ;


% Create internal indexing of variables
% -------------------------------------------------------------------------
for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end


% Indices of variables concerned by ZLB
% ---------------------------------------------------------------------
rpos  = Rpos ;
rspos = Rspos ;
tolR  = 1e-6;


%------- IMPORTANT PARAMETER OF THE CODE:
%
% Size of the vector of values for annual inflation target- benchmark value= 51 
% otherwise 21 is not bad
% -----------------------------------------------------------------------------
NN            = 21;


% Number of values of MUZ considered (Posterior Mean is included in addition )  
% -------------------------------------------------------------------------
NumberOfMUZs  = 10;
MUZ           = my_get_param_by_name('MUZ',M_) ;
MUZmin        = 0.0010;
MUZmax        = 0.0250;
vMUZ          = (exp(linspace(0,log(400*MUZmax+1-400*MUZmin),NumberOfMUZs))-1+400*MUZmin)/400 ;
vMUZ          = sort([vMUZ,MUZ]);
KK            = length(vMUZ);


% INTERPOLATE INTIAL VALUES -- (c) HERVE August 2019
% % Format a little bit
 x   = init.vMUZ;
 y1  = init.vecPiStar;
% % Interpolate on a (possibly) denser grid
 xf  = vMUZ;
 init_vecPiStar = interp1(x,y1,xf,'pchip');



% Time-series length of each simulation
% ---------------------------------------------------------------------
Nburnin       = 1000;
Nsample       = 100000;

% Create the shocks
% -------------------------------------------------------------------------
shock = generateTheShocks(M_.exo_nbr,Nburnin+Nsample);


% Preallocate storage matrices
% -------------------------------------------------------------------------
vecPiStar   = zeros(KK,1) ;
vecrStar    = zeros(KK,1) ;
vecInfoSim  = zeros(KK,1) ;
vecEPiStar  = zeros(KK,1) ;
vecZLB      = zeros(KK,1) ;

% Attention : ELB defined here !
ELBBAR = 0 ;

% Main Loop over MUZs
% -------------------------------------------------------------------------






for ids = 1:KK    
    
    
    Mt0 = M_ ;

    
    
    MUZ  = vMUZ(ids) ;
    fprintf('\t MUZ = %1.4f ---> ',MUZ)
    
    Mt0 = set_myparam_value(Mt0,'MUZ',MUZ) ;

    RHO = my_get_param_by_name('RHO',Mt0) ;
    
    
    if ~checkForFile
        
         if 400*(MUZ+RHO) <= 5 % values below are for LOW RHO
             pistar_init= 5 - 400*(MUZ+RHO)  ; %% based on ocular shape of decreasing part of 'hockey stick' graph
             pimin = pistar_init + 2  ;% 2pct annualized
             pimax = pistar_init - 1;% 4pct annualized
         elseif (400*(MUZ+RHO) > 5) 
             pimin = -1;                  %% flatter part- around zero
             pimax = 1;
         end

        pmin = 1+ pimin/100;
        pmax = 1+pimax/100;
        
    else           %%Case when intial estimate exist
        pistar_init  = init_vecPiStar(ids) ;
             
        
          if 400*(MUZ+RHO) <= 4 % values below are for LOW RHO        
             pimin = pistar_init + 0.25  ;% 0.4pct annualized
             pimax = pistar_init - 0.25;% 0.4pct annualized
          elseif 400*(MUZ+RHO) >4 % values below are for LOW RHO        
             
             pimin = pistar_init + 0.1  ;% 0.4pct annualized
             pimax = pistar_init - 0.5;% 0.4pct annualized
          end  
             
        pmin = 1+ pimin/100;
        pmax = 1+pimax/100; 
             
    end
    fprintf('Real Rate (annualized) = %1.8f\n',400*(MUZ+RHO))
    vpistar  = linspace(pmin,pmax,NN) ;
    
    t0 = clock ;
    Welfare  = zeros(NN,1);   
    EPIP     = zeros(NN,1);   
    vpZLB    = zeros(NN,1);  
    % Loop over PISTAR
    % ---------------------------------------------------------------------
    parfor iter = 1:length(vpistar)
        
        Mt = Mt0 ;
        
        % -----------------------------------------------------------------
        PISTAR = vpistar(iter)^.25-1;
        fprintf('\t\t PISTAR = %1.4f \n',PISTAR)
        R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
        rb = - R + ELBBAR;
                
        %------------------------------------------------------------------
        Mt = set_myparam_value(Mt,'PISTAR',PISTAR) ;
        x  = simulateModelUnderZlb(Mt,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);
        X = x(:,Nburnin+1:Nsample+Nburnin);
        
        % Compute ZLB proba
        %------------------------------------------------------------------
        dumZLB = X(rpos,:)<=rb+tolR;
        pZLB   = 100*mean(dumZLB);
        
        % Compute Welfare
        % -----------------------------------------------------------------
        PIPSIM        = X(pippos,:);
        PIWSIM        = X(piwpos,:);
        XSIM          = X(xpos,:);
        Xsim          = [PIPSIM;PIWSIM;XSIM] ;
        Welfare(iter) = computeWelfare(Mt,Xsim) ;
        EPIP(iter)    = PISTAR + mean(PIPSIM) ;
        vpZLB(iter)   = pZLB;
    end
    t1 = clock ;
    
    vecPiStar(ids)  = 100*(vpistar(Welfare==max(Welfare))-1);
    vecEPiStar(ids) = 400*EPIP(Welfare==max(Welfare));
    vecZLB(ids)     = vpZLB(Welfare==max(Welfare));
    vecrStar(ids)   = 400*((1+MUZ)*(1+RHO)-1);
    vecInfoSim(ids) = etime(t1,t0);

    disp('--------------------------------------------------------------------------------');
    fprintf('\n');
    fprintf('\t\t ---------> OPTIMAL PISTAR FOR THIS RSTAR= %1.4f \n',vecPiStar(ids))
    fprintf('\n');
    disp('--------------------------------------------------------------------------------');
    fprintf('\n');
    
end


save(fname,'vMUZ','vecPiStar','vecEPiStar','vecInfoSim','vecrStar','vecZLB')

disp('Elapsed time for running script');
t1=clock;
etime(t1,t0);



%compare initial with new results
figure
plot(vecrStar,vecPiStar,'o',init.vecrStar,init.vecPiStar,'--')
grid
ylabel('Pistar or Average realized Pi')

if ~checkForFile
plot(vecrStar,vecPiStar,'o')
grid
ylabel('Pistar ')
end



figure
plot(vecrStar,vecZLB,'o')
ylabel('Probability of ZLB (at optimal target)')
grid
title('The P(ZLB) curve with alternative RHO')