% bayesianWelfareCfAltTotal.m : 
%
% Compute Bayesian Welfare over a fixed grid of inflation 
% for different structural parameters drawn from the posterior
% distribution and for an rstar 100 bps lower than normal, assuming that MP
% parameters are frozen at their posterior mean
%
% Required to compute pistarstar
%
% This script is called by another program (computeBayesianWelfareAlt)

addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

warning('off','all');

% users     = {'JUM'} ;
% idCountry = 'EZ';
% idRound   = 1;
% idUser    = users{1};

% Pick location parameter
loc  = 'posterior_mean';


%Loads US or EZ file with parameter draws
x = load(['paramDrawsFile',idCountry]);


% To run program with short sample for testing purposes : Set to 1 
% This will set Nburnin     = 100 and Nsample     = 100
TEST_MODE = 0;


sep = '--------------------------------------------------------------';
idCountry = 'US' ;
radical = 'spswUs' ;
exclusion = [278 300]; % list of draws not BK consistent

cfId = 'MP';

switch cfId
    
    case 'MP'
        
        cfpnames = {'FIR','FIP','FIX'};
                
    otherwise
        
        error('No such counterfactual')
        
end

drawsid = 1:300 ;
mydraws = x.coll(:,drawsid);
clear x

% Load estimated model info
% -------------------------------------------------------------------------
load(['../ESTIMTMP/',radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_

% Then run your model with Dynare
% -------------------------------------------------------------------------
modnam   = 'spswSim' ;
eval(['dynare ',modnam,' noclearall nolog '])
% -------------------------------------------------------------------------
% After the above step, the M_ and oo_ in the workspace are those of the
% simulated model

% Create internal indexing of variables
% -------------------------------------------------------------------------
for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end

% Indices of variables concerned by ZLB & est parm names
% -------------------------------------------------------------------------
rpos   = Rpos ;
rspos  = Rspos ;
pnames = fieldnames(ooest.posterior_mean.parameters);


% Vector of values for annual inflation target
% -------------------------------------------------------------------------
NN            = 51;

% Time-series length of each simulation  (Note :Nsample should be 100 000 for convergence)
% ---------------------------------------------------------------------
Nburnin     = 1000;
Nsample     = 100000;

%run program with short sample for testing purposes
if TEST_MODE ==1
    Nburnin     = 100;
    Nsample     = 100;
end
    
% Create the shocks
% -------------------------------------------------------------------------
shock = generateTheShocks(M_.exo_nbr,Nburnin+Nsample);

[Np,Ndraws] = size(mydraws);
Welfare     = zeros(NN,Ndraws);
Ctime       = zeros(NN,Ndraws);
PiGrid      = zeros(NN,Ndraws);
chkDraw     = ones(Ndraws,1);



pmin = 1.020;
pmax = 1.040;
vpistar  = linspace(pmin,pmax,NN) ;


t00 = clock;
for jter = 1:Ndraws
    
    % Assign draw to M_
    Mouter = M_ ;
    draw = mydraws(:,jter) ;
    for iter = 1:length(pnames)
        Mouter = set_myparam_value(Mouter,pnames{iter},draw(iter));
    end
    % Make sure the CF parameters are set to desired values
    for iter = 1:length(cfpnames)
        Mouter = set_myparam_value(Mouter,cfpnames{iter},ooest.(loc).parameters.(cfpnames{iter}));
    end
            
    % Retrieve parameters from draw
    MUZ    = my_get_param_by_name('MUZ',Mouter) ;
    RHO    = my_get_param_by_name('RHO',Mouter) ;
    RHOQ   = my_get_param_by_name('RHOQ',Mouter) ;

    % Shift MUZ
    Mouter = set_myparam_value(Mouter,'MUZ',MUZ-1/400);
    MUZ    = my_get_param_by_name('MUZ',Mouter) ;
    
    FIR    = my_get_param_by_name('FIR',Mouter) ;
    
    
    if (RHOQ <= 0.99) && all(jter~=exclusion) % The loop over PISTAR is doable
        
        
        fprintf('Simulation # %-3d FEASIBLE LOOP \n',jter)       
        
        % Loop over PISTAR
        % -----------------------------------------------------------------
        parfor iter = 1:length(vpistar)
            
            fprintf('\t Inflation # %-3d',iter)
            Minner = Mouter ;
            
            t0 = clock ;
            % -----------------------------------------------------------------
            PISTAR = vpistar(iter)^.25-1;
            R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
            rb = - R + ELBBAR;
            
            
            %------------------------------------------------------------------
            Minner = set_myparam_value(Minner,'PISTAR',PISTAR) ;
            
            x1 = simulateModelUnderZlb(Minner,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);
            X1 = x1(:,Nburnin+1:Nsample+Nburnin);
            
            % Compute Welfare
            % -----------------------------------------------------------------
            PIPSIM1  = X1(pippos,:);
            PIWSIM1  = X1(piwpos,:);
            XSIM1    = X1(xpos,:);
            Xsim1    = [PIPSIM1;PIWSIM1;XSIM1] ;
            Welfaret = computeWelfare(Minner,Xsim1);
            Welfare(iter,jter) = Welfaret;
            
            % -----------------------------------------------------------------
            t1 = clock ;
            fprintf('Elapsed time: %-4.4f\n',etime(t1,t0))
            Ctime(iter,jter) = etime(t1,t0);
            
        end
    else % The loop is infeasible for this particular draw
        fprintf('Simulation # %-3d \t INFEASIBLE LOOP - calculations aborted\n',jter)
        Welfare(:,jter) = NaN;
        Ctime(:,jter)   = NaN;
        chkDraw(jter)   = 0;
    end
end
t11 = clock;
fprintf('\\ Overall simulation time: %-4.4f\n',etime(t11,t00))


save(['../RESULTS/pissSimulationCfAlt',cfId,idCountry,],'Welfare','Ctime','drawsid','chkDraw','vpistar')
