addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

warning('off','all');

x = load(['paramDrawsFile',idCountry]);

if idRound > 49
    error('idRound is too large - maximal value is 49')
end


sep = '--------------------------------------------------------------';

idCountry = 'US';
radical = 'spswUs' ;
idUser  = 'PHA'; 

% Warning: if you want to parallelize this program even further, create as
% many additional programs as there are different users (each labelled with
% an idUser)


switch idUser
    
    case 'PHA'
        
        drawsid = 100*(idRound-1)+1:100*(idRound-1)+33;
        
    case 'HLB'
        
        drawsid = 100*(idRound-1)+34:100*(idRound-1)+66;
        
    case 'JUM'
        
        drawsid = 100*(idRound-1)+67:100*(idRound-1)+100;
        
    otherwise
        
        warning('No such economist available at DEMFI -> please contact le cabinet de la DGEI')
        return;        
end

mydraws = x.coll(:,drawsid);
clear x

% Load estimated model info
% -------------------------------------------------------------------------
load(['../ESTIMTMP/',radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_

% Then run your model with Dynare
% -------------------------------------------------------------------------
modnam   = 'spswSim' ;
eval(['dynare ',modnam,' noclearall nolog '])
% -------------------------------------------------------------------------
% After the above step, the M_ and oo_ in the workspace are those of the
% simulated model

% Create internal indexing of variables
% -------------------------------------------------------------------------
for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end

% Indices of variables concerned by ZLB & est parm names
% -------------------------------------------------------------------------
rpos   = Rpos ;
rspos  = Rspos ;
pnames = fieldnames(ooest.posterior_mean.parameters);


% Vector of values for annual inflation target
% -------------------------------------------------------------------------
NN            = 51;

% Time-series length of each simulation
% ---------------------------------------------------------------------
Nburnin     = 1000;
Nsample     = 100000;

% Create the shocks
% -------------------------------------------------------------------------
shock = generateTheShocks(M_.exo_nbr,Nburnin+Nsample);

[Np,Ndraws] = size(mydraws);
WelfareCf   = zeros(NN,Ndraws);
Ctime       = zeros(NN,Ndraws);
PiGridCf    = zeros(NN,Ndraws);
chkDraw     = ones(Ndraws,1);


checkForFile = isfile(['../RESULTS/fullSimulationCf',idCountry,'Block',num2str(idRound),idUser,'.mat'])>0 ;
if checkForFile
    init = load(['../RESULTS/fullSimulationCf',idCountry,'Block',num2str(idRound),idUser]);
end


t00 = clock;
for jter = 1:Ndraws
    
    % Assign draw to M_
    Mouter = M_ ;
    draw = mydraws(:,jter) ;
    for iter = 1:length(pnames)
        Mouter = set_myparam_value(Mouter,pnames{iter},draw(iter));
    end
    
    % Overide input value for MUZ and subtract 1% APR
    MUZ    = my_get_param_by_name('MUZ',Mouter) ;
    Mouter = set_myparam_value(Mouter,'MUZ',MUZ-1/400);
    
    % Retrieve parameters from draw
    MUZ    = my_get_param_by_name('MUZ',Mouter) ;
    RHO    = my_get_param_by_name('RHO',Mouter) ;
    ALPHAP = my_get_param_by_name('ALPHAP',Mouter) ;
    ALPHAW = my_get_param_by_name('ALPHAW',Mouter) ;
    RHOQ   = my_get_param_by_name('RHOQ',Mouter) ;
    
    if RHOQ <= 0.991 % The loop over PISTAR is doable
        
        % Tailor the inflation grid bounds to the particular draw
        % -----------------------------------------------------------------
        if checkForFile
            [M,I] = max(init.WelfareCf(:,jter),[],1);
            pinit = init.PiGridCf(I,jter);
            if pinit~=1
                zinit = 0.25*abs(pinit-1);
            else
                zinit = 0.0025;
            end
            pmin  = pinit-zinit;
            pmax   = pinit+zinit; 
        else
            % -------------------------------------------------------------
            pmin = 1.010;
            pmax = 1.050;
            % -----------------------------------------------------------------
            if 400*(RHO+MUZ) > 3.00
                pmin = 0.99;
                pmax = 1.04;
            end
            if RHOQ > 0.96
                pmax = 1.060;
                pmin = 1.010;
            end
        end
        vpistar  = linspace(pmin,pmax,NN) ;
        fprintf('Simulation # %-3d \t Min PISTAR = %-2.2f \n',jter,100*(pmin-1))
        PiGridCf(:,jter) = vpistar;
        
        
        % Loop over PISTAR
        % -----------------------------------------------------------------
        parfor iter = 1:length(vpistar)
            
            fprintf('\t Inflation # %-3d',iter)
            Minner = Mouter ;
            
            t0 = clock ;
            % -----------------------------------------------------------------
            PISTAR = vpistar(iter)^.25-1;
            R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
            rb = - R + ELBBAR;
            
            
            %------------------------------------------------------------------
            Minner = set_myparam_value(Minner,'PISTAR',PISTAR) ;
            
            x1 = simulateModelUnderZlb(Minner,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);
            X1 = x1(:,Nburnin+1:Nsample+Nburnin);
            
            % Compute Welfare
            % -----------------------------------------------------------------
            PIPSIM1  = X1(pippos,:);
            PIWSIM1  = X1(piwpos,:);
            XSIM1    = X1(xpos,:);
            Xsim1    = [PIPSIM1;PIWSIM1;XSIM1] ;
            Welfaret = computeWelfare(Minner,Xsim1);
            WelfareCf(iter,jter) = Welfaret;
            
            % -----------------------------------------------------------------
            t1 = clock ;
            fprintf('Elapsed time: %-4.4f\n',etime(t1,t0))
            Ctime(iter,jter) = etime(t1,t0);
            
        end
    else % The loop is infeasible for this particular draw
        fprintf('Simulation # %-3d \t Infeasible loop - calculations aborted\n',jter)
        WelfareCf(:,jter) = NaN;
        Ctime(:,jter)     = NaN;
        chkDraw(jter)     = 0;
    end
end
t11 = clock;
fprintf('\\ Overall simulation time: %-4.4f\n',etime(t11,t00))

save(['../RESULTS/fullSimulationCf',idCountry,'Block',num2str(idRound),idUser],'WelfareCf','Ctime','drawsid','chkDraw','PiGridCf')
