% trickySimParallel: simulate the main US or EZ mode for a number of
% parameter draws; and for a grid of inflatio
%
% This mfile is trigerred by running file e.g. trickySimParallel_JUM.m
% Because we run it in parallel from different computers called JUM, PHA ,HLB
% The latter scripts do define idCountry and idRound and idUser that are
% needed her

addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

warning('off','all');

%Loads file with parameter draws
x = load(['paramDrawsFile',idCountry]);

if idRound > 49
    error('idRound is too large - maximal value is 49')
end

% To run program with short sample for testing purposes : Set to 1 
% This will set Nburnin     = 100 and Nsample     = 100
TEST_MODE =0;


sep = '--------------------------------------------------------------';

idCountry = 'US' ;
radical = 'spswUs' ;
idUser  = 'PHA'; 
% Warning: if you want to parallelize this program even further, create as
% many additional programs as there are different users (each labelled with
% an idUser)

switch idUser
    
    case 'PHA'
        
        drawsid = 100*(idRound-1)+1:100*(idRound-1)+33;
        
    case 'HLB'
        
        drawsid = 100*(idRound-1)+34:100*(idRound-1)+66;
        
    case 'JUM'
        
        drawsid = 100*(idRound-1)+67:100*(idRound-1)+100;
        
    otherwise
        
        warning('No such economist available at DEMFI -> please contact le cabinet de la DGEI')
        return;        
end

mydraws = x.coll(:,drawsid);
clear x

% Load estimated model info
% -------------------------------------------------------------------------
load(['../ESTIMTMP/',radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_

% Then run your model with Dynare
% -------------------------------------------------------------------------
modnam   = 'spswSim' ;
eval(['dynare ',modnam,' noclearall nolog '])
% -------------------------------------------------------------------------
% After the above step, the M_ and oo_ in the workspace are those of the
% simulated model

% Create internal indexing of variables
% -------------------------------------------------------------------------
for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end

% Indices of variables concerned by ZLB & est parm names
% -------------------------------------------------------------------------
rpos   = Rpos ;
rspos  = Rspos ;
pnames = fieldnames(ooest.posterior_mean.parameters);


% Vector of values for annual inflation target
% -------------------------------------------------------------------------
NN            = 51;

% Time-series length of each simulation  (Note :Nsample should be 100 000 for convergence)
% ---------------------------------------------------------------------
Nburnin     = 1000;
Nsample     = 100000;

%run program with short sample for testing purposes
if TEST_MODE ==1
    Nburnin     = 100;
    Nsample     = 100;
end
    
% Create the shocks
% -------------------------------------------------------------------------
shock = generateTheShocks(M_.exo_nbr,Nburnin+Nsample);

[Np,Ndraws] = size(mydraws);
Welfare     = zeros(NN,Ndraws);
Ctime       = zeros(NN,Ndraws);
PiGrid      = zeros(NN,Ndraws);
chkDraw     = ones(Ndraws,1);


%Check whether there is already a file with Grids of Pi
checkForFile = isfile(['../RESULTS/fullSimulation',idCountry,'Block',num2str(idRound),idUser,'.mat'])>0 ;

if checkForFile
    init = load(['../RESULTS/fullSimulation',idCountry,'Block',num2str(idRound),idUser]);
end


t00 = clock;
for jter = 1:Ndraws
    
    % Assign draw to M_
    Mouter = M_ ;
    draw = mydraws(:,jter) ;
    for iter = 1:length(pnames)
        Mouter = set_myparam_value(Mouter,pnames{iter},draw(iter));
    end
    
    % Retrieve parameters from draw
    MUZ    = my_get_param_by_name('MUZ',Mouter) ;
    RHO    = my_get_param_by_name('RHO',Mouter) ;
    ALPHAP = my_get_param_by_name('ALPHAP',Mouter) ;
    ALPHAW = my_get_param_by_name('ALPHAW',Mouter) ;
    RHOQ   = my_get_param_by_name('RHOQ',Mouter) ;
    
    if RHOQ <= 0.99 % The loop over PISTAR is doable
        
        % Tailor the inflation grid bounds to the particular draw
        % -----------------------------------------------------------------
        % If checkForFile=1; a first grid exists; then refine
        if checkForFile
            [M,I] = max(init.Welfare(:,jter),[],1);
            pinit = init.PiGrid(I,jter);
            if pinit~=1
                zinit = 0.5*abs(pinit-1);
                % Mid-july Herve adds the restriction below to deal with crashes
                if 100*(pmin-1)> 2.5 ;
                    zinit = 0.25*abs(pinit-1);
                end                      
            else
                zinit = 0.0025;
            end
            pmin = pinit-zinit;
            pmax = pinit+zinit; 
        else
            % -------------------------------------------------------------
            % If checkForFile=0; case of a first pass
            pmin = 1.001;
            pmax = 1.050;
            % -----------------------------------------------------------------
            if 400*(RHO+MUZ) > 3.00
                pmin = 0.99;
                pmax = 1.05;
            end
            if RHOQ > 0.96
                pmax = 1.080;
                pmin = 1.005;
            end
        end
        vpistar  = linspace(pmin,pmax,NN) ;
        fprintf('Simulation # %-3d \t Min PISTAR = %-2.2f \n',jter,100*(pmin-1))
        PiGrid(:,jter) = vpistar;
        
        
        % Loop over PISTAR
        % -----------------------------------------------------------------
        parfor iter = 1:length(vpistar)
            
            fprintf('\t Inflation # %-3d',iter)
            Minner = Mouter ;
            
            t0 = clock ;
            % -----------------------------------------------------------------
            PISTAR = vpistar(iter)^.25-1;
            R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
            rb = - R + ELBBAR;
            
            
            %------------------------------------------------------------------
            Minner = set_myparam_value(Minner,'PISTAR',PISTAR) ;
            
            x1 = simulateModelUnderZlb(Minner,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);
            X1 = x1(:,Nburnin+1:Nsample+Nburnin);
            
            % Compute Welfare
            % -----------------------------------------------------------------
            PIPSIM1  = X1(pippos,:);
            PIWSIM1  = X1(piwpos,:);
            XSIM1    = X1(xpos,:);
            Xsim1    = [PIPSIM1;PIWSIM1;XSIM1] ;
            Welfaret = computeWelfare(Minner,Xsim1);
            Welfare(iter,jter) = Welfaret;
            
            % -----------------------------------------------------------------
            t1 = clock ;
            fprintf('Elapsed time: %-4.4f\n',etime(t1,t0))
            Ctime(iter,jter) = etime(t1,t0);
            
        end
    else % The loop is infeasible for this particular draw
        fprintf('Simulation # %-3d \t Infeasible loop - calculations aborted\n',jter)
        Welfare(:,jter) = NaN;
        Ctime(:,jter)   = NaN;
        chkDraw(jter)   = 0;
    end
end
t11 = clock;
fprintf('\\ Overall simulation time: %-4.4f\n',etime(t11,t00))

save(['../RESULTS/fullSimulation',idCountry,'Block',num2str(idRound),idUser],'Welfare','Ctime','drawsid','chkDraw','PiGrid')
