% ComputeModelProeperties.m: 
%basic simulation for a fixed structural parameter to draw 
%Provides Moments and IRF

% ---> pick a country, by selecting idCountry, 
% ---> freeze the parameters at their posterior mean (mode, median)
% by selecting idLocation,

addpath ../UTILITIES
addpath ../COMFILES
addpath ../ESTIMTMP

%warning('off','all');

sep = '--------------------------------------------------------------';

idCountry = 'US';
idLocation = 'Mean';
radical = 'spswUs' ;


switch idLocation
    
    case 'Mean'
        
        loc = 'posterior_mean';
        
    case 'Median'
        
        loc = 'posterior_median';
        
    case 'Mode'
        
        loc = 'posterior_mode';
        
    otherwise
        
        warning('No such location available')
        return;        
end


% Load estimated model info
% -------------------------------------------------------------------------
load([radical,'EstimV1_results']);
Mest  = M_ ;
ooest = oo_;
clear M_ 
clear oo_

% Then run your model with Dynare
% -------------------------------------------------------------------------
modnam   = 'spswSim2' ;
eval(['dynare ',modnam,' noclearall nolog '])
% -------------------------------------------------------------------------
% After the above step, the M_ and oo_ in the workspace are those of the
% simulated model


% Assign estimated parameter values to the proper M_
% -------------------------------------------------------------------------
chkParams = zeros(size(M_.params,1),2) ;
chkParams(:,1) = M_.params ;
pnames = fieldnames(ooest.(loc).parameters);
for iter = 1:length(pnames)
    M_ = set_myparam_value(M_,pnames{iter},ooest.(loc).parameters.(pnames{iter}));
end
chkParams(:,2) = M_.params ;


% Create internal indexing of variables
% -------------------------------------------------------------------------
for iter = 1:size(M_.endo_names,1)
    eval([deblank(M_.endo_names(iter,:)),'pos = ',num2str(iter),';']);
end
for iter = 1:size(M_.exo_names,1)
    eval([deblank(M_.exo_names(iter,:)),'pos = ',num2str(iter),';']);
end

% Indices of variables concerned by ZLB
% -------------------------------------------------------------------------
rpos  = Rpos ;
rspos = Rspos ;

% MUZ = my_get_param_by_name('MUZ',M_) ;
% RHO = my_get_param_by_name('RHO',M_) ;
% ALPHAP = my_get_param_by_name('ALPHAP',M_) ;
% ALPHAW = my_get_param_by_name('ALPHAW',M_) ;
% FIR = my_get_param_by_name('FIR',M_) ;
% FIP = my_get_param_by_name('FIP',M_) ;
% FIY = my_get_param_by_name('FIY',M_) ;
% FIX = my_get_param_by_name('FIX',M_) ;
% ELBBAR = -10000;
 R = (1+MUZ)*(1+PISTAR)*(1+RHO)-1;
 rb = - R + ELBBAR;


Nburnin     = 500;
Nsample     = 100000;
Nseries     = 1;
tolR        = 1e-6;


% Do you wish to have moments calulated and displayed?
% ---------------------------------------------------------------------
DO_MOMENTS = 1 ;

if DO_MOMENTS==1
%------------------------------------------------------
%              Computing Non-Conditionnal Moment with BOOTSTRAP
%------------------------------------------------------

% Time-series length of each simulation
% ---------------------------------------------------------------------
Nburnin     = 100;
Nsample     = 95 + 1;
Nsim        = 1000;
std_pi      = NaN(Nsim,1);
std_pia     = NaN(Nsim,1);
std_dy      = NaN(Nsim,1);
std_R       = NaN(Nsim,1);
std_x       = NaN(Nsim,1);

% Create the shocks
% -------------------------------------------------------------------------
%shock = generateTheShocks(M_.exo_nbr,Nburnin+Nsample);
%     'ez'
%     'eg'
%     'eR'
%     'eh'
%     'eq'
%     'eu'
shockModel = [oo_.SmoothedShocks.ez oo_.SmoothedShocks.eg oo_.SmoothedShocks.eR oo_.SmoothedShocks.eh oo_.SmoothedShocks.eq oo_.SmoothedShocks.eu];

rng(17891492);


for iter=1:Nsim
    shock = [ zeros(1,6) ;
        randn(Nburnin,6) ;
        shockModel(ceil(rand(95,6)*95))]';
    
    %  simulateModelUnderZlb
    % ---------------------------------------------------------------------
    x1 = simulateModelUnderZlb(M_,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);
    x1 = x1(:,Nburnin+1:end);

    %  Extract simulated variables
    % ---------------------------------------------------------------------
    pipsim      = x1(pippos,:);
    xsim        = x1(xpos,:);
    dysim       = x1(dypos,:);
    Rsim        = x1(Rpos,:);
    inflation4Q = pipsim(4:end)+ pipsim(3:end-1)+pipsim(2:end-2)+pipsim(1:end-3);
    
    % Store resulting stds
    % ---------------------------------------------------------------------
    std_pi(iter)  = std(pipsim);
    std_pia(iter) = std(inflation4Q);
    std_dy(iter)  = std(dysim);
    std_R(iter)   = std(Rsim);
    std_x(iter)   = std(xsim);
    
end

%--------------------------------------------------------------

disp('MODEL GENERATED MOMENTS');
disp('Standard dev of 4Q-inflation');
disp(100*mean(std_pia))
disp('---------------');

disp('Standard dev of inflation');
disp(100*mean(std_pi))
disp('---------------');


disp('Standard dev of output gap');
disp(100*mean(std_x))
disp('---------------');

disp('Standard dev of output growth');
disp(100*mean(std_dy))
disp('---------------');


disp('Standard dev of interest rate');
disp(400*mean(std_R))
disp('---------------');





%--- Loading historical data
load ../DATA/estimationUSData

T = find(qdate==2008.5);
smp = 1:T;
dP_o = dP_o(smp);
dY_o = dY_o(smp);
R_o  = R_o(smp);


inflation4Q=dP_o(4:end)+ dP_o(3:end-1)+dP_o(2:end-2)+dP_o(1:end-3);

% -------------------------------------------------------------------------


disp('DATA (lhs) vs MODEL (rhs)');

disp('Standard dev of 4Q-inflation');
disp([std(inflation4Q),100*mean(std_pia)])
disp('---------------');

disp('Standard dev of inflation');
disp([std(dP_o),100*mean(std_pi)])
disp('---------------');


disp('Standard dev of output growth');
disp([std(dY_o),100*mean(std_dy)])
disp('---------------');


disp('Standard dev of interest rate');
disp([std(R_o),400*mean(std_R)])
disp('---------------');


%--------------------------------------------------------------






% 
% disp('Standard dev of everything');
% for iter = 1:size(M_.endo_names,1)
%     disp( M_.endo_names(iter,:) );
%     eval(['hlb=x1(',deblank(M_.endo_names(iter,:)),'pos,:);']);
%     disp(std(hlb));
% end


end  %end condition on DO_MOMENTS

%disp('NOW: DATA MOMENTS');
%datatmp

return
% % -------------------------------------------------------------------------
% %  --------- IRF s -----------------------------------------------------
% % -------------------------------------------------------------------------

Nburnin     = 0;
Nsample     = 44;


% % Create the shocks
% % -------------------------------------------------------------------------
% % Preallocate
% % -------------------------------------------------------------------------
shock = zeros(M_.exo_nbr,Nburnin+Nsample);

% % -------------------------------------------------------------------------
% % % IRF to Monetary policy  shock (Expansionnary so ZLB will not be  binding
% % % -------------------------------------------------------------------------
shock(eRpos,2:2) = -1;
x1 = simulateModelUnderZlb(M_,oo_,zeqpos,rpos,rspos,rb,options_,Nsample,Nburnin,shock);

c1 = [70,130,180]/255;
figure
smpl = 2:21;

R  = 4*x1(rpos,smpl);
dp = 4*x1(pippos,smpl);
y  = x1(ypos,smpl);   

coeff  = 0.25/abs(R(1));


subplot(3,1,1)
hp = plot(smpl-1,coeff*R);
set(hp,'linewidth',2);
set(hp(1),'color',c1)
%set(hp(2),'linestyle','--','color',c1)
set(gca,'fontname','times')
title('Short-term nominal interest rate (annualized)')

subplot(3,1,2)
hp = plot(smpl-1,coeff*dp);
set(hp,'linewidth',2,'color',c1);
set(gca,'fontname','times')
title('Quarterly inflation rate (annualized)')

subplot(3,1,3)
hp = plot(smpl-1,coeff*y);
set(hp,'linewidth',2,'color',c1);
set(gca,'fontname','times')
title('Output')

set(gcf,'PaperType','<custom>','PaperSize',[20.4 15.25],'PaperPosition',[0.1 0.02158 20.3046 15.2284]);
print(gcf,'-dpdf','../FIGURES/figBasicMonPolShock.pdf')


