//% -----------------------------------------------------------------------
//% -----------------------------------------------------------------------
//% This mod file is used essentially for compilation purposes
//% Dynare per se is not used in the simulations
//% -----------------------------------------------------------------------

var 
    lam y h R pip Kp Fp pstar w piw Kw Fw wstar xip
    Rs
    yn x dy xHP
    zeg zez zeh zeq zeR zeu
    dY_o dP_o dW_o R_o
;

varexo 
    ez eg eR eh eq eu
;

parameters 
    RHO     $\rho$
    ETA     $\eta$
    IOTAP   $\iota_p$
    IOTAW   $\iota_w$
    GAMMAP  $\gamma_p$
    GAMMAW  $\gamma_w$
    NU      $\nu$
    GAMMAZ  $\gamma_z$
    MUZ     $\mu_z$
    THETAP  $\theta_p$
    THETAW  $\theta_w$
    PHI     $\phi$
    ALPHAP  $\alpha_p$
    ALPHAW  $\alpha_w$
    FIR     $\rho_{TR}$
    FIP     $a_\pi$
    FIX     $a_y$
    FIY     $a_{\Delta y}$
    PISTAR  $\pi^\star$
    SIGMAZ  $\sigma_z$
    SIGMAR  $\sigma_R$
    SIGMAH  $\sigma_h$
    SIGMAG  $\sigma_g$
    SIGMAQ  $\sigma_q$
    SIGMAU  $\sigma_u$
    RHOZ    $\rho_z$
    RHOR    $\rho_R$
    RHOH    $\rho_h$
    RHOG    $\rho_g$
    RHOQ    $\rho_q$
    RHOU    $\rho_u$
    GW      $C_W$
    ELBBAR  $\delta_R$
    LAMHP   $\lambda_{HP}$
;





model(linear);
    # BETA    = 1/(1+RHO) ;
    # GY      = 100*MUZ ;
    # GP      = 100*PISTAR;
    # GR      = 400*((1+MUZ)*(1+PISTAR)/BETA-1);
    # VARFI   = 1/((1-BETA*ETA)*(1-ETA)) ;
    # OMEGAP  = PHI-1;
    # OMEGAW  = NU*PHI;
    # OMEGA   = OMEGAP+OMEGAW;
    # OMEGAKP = BETA*ALPHAP*(1+PISTAR)^((1-GAMMAP)*PHI*THETAP);
    # OMEGAFP = BETA*ALPHAP*(1+PISTAR)^((1-GAMMAP)*(THETAP-1));
    # OMEGAKW = BETA*ALPHAW*(exp((1-GAMMAZ)*MUZ)*(1+PISTAR)^(1-GAMMAW))^((1+NU)*THETAW);
    # OMEGAFW = BETA*ALPHAW*(exp((1-GAMMAZ)*MUZ)*(1+PISTAR)^(1-GAMMAW))^(THETAW-1);
    # OMEGAXI = ALPHAP*(1+PISTAR)^(PHI*THETAP*(1-GAMMAP));

    //% 1. Euler equation on bonds
    lam = lam(+1) + R - pip(+1) + zeq - zez(+1) ;

    //% 2. MU of consumption
    (1/VARFI)*lam = BETA*ETA*y(+1) - (1+BETA*ETA^2)*y + ETA*y(-1) + zeg - ETA*(zez-BETA*zez(+1)) ; 

    //% 3. NKPC-P-1
    (1+THETAP*(PHI-1))*pstar = Kp - Fp ;

    //% 4. NKPC-P-2
    Kp = (1-OMEGAKP)*(lam+w+PHI*y+zeu) + 
        OMEGAKP*(Kp(+1)+PHI*THETAP*( pip(+1)-IOTAP*GAMMAP*pip ));

    //% 5. NKPC-P-3
    Fp = (1-OMEGAFP)*(lam+y) + 
        OMEGAFP*(Fp(+1)+(THETAP-1)*( pip(+1)-IOTAP*GAMMAP*pip ));

    //% 6. NKPC-P-4
    pstar = OMEGAFP/(BETA-OMEGAFP)*( pip-IOTAP*GAMMAP*pip(-1)) ;

    //% 7. NKPC-W-1
    (1+THETAW*NU)*(wstar-w) = Kw - Fw ;

    //% 8. NKPC-W-2
    Kw = (1-OMEGAKW)*((1+NU)*h+zeh) + 
        OMEGAKW*(Kw(+1)+THETAW*(1+NU)*( piw(+1)-IOTAW*GAMMAW*pip ));

    //% 9. NKPC-W-3
    Fw = (1-OMEGAFW)*(lam+w+h) + 
        OMEGAFW*(Fw(+1)+(THETAW-1)*( piw(+1)-IOTAW*GAMMAW*pip ));

    //% 10. NKPC-W-4
    wstar-w = OMEGAFW/(BETA-OMEGAFW)*( piw-IOTAW*GAMMAW*pip(-1)) ;

    //% 11. Identity
    piw = w - w(-1) + pip + zez ;

    //% 12. Production function
    h = PHI*(y-THETAP*xip);

    //% 13. xip's dynamics
    xip = (1-OMEGAXI)*pstar + 
        OMEGAXI*( xip(-1) - (pip-IOTAP*GAMMAP*pip(-1) ) );

    //% 12. Interest Rate rule (Equation 7.1)
    //Rs = FIR*Rs(-1) 
    //+ (1-FIR)*(FIP*pip + .25*FIX*xHP+ .25*FIY*(xHP-xHP(-1))) + zeR;
    Rs = FIR*Rs(-1) 
    + (1-FIR)*(FIP*pip + .25*FIX*x+ .25*FIY*(x-x(-1))) + zeR;


    //% 13. "[max_operator]" puts a tag on this eq. - required later
    [max_operator]         
    R = Rs;

    //% 14. Output gap *
    x = y - yn ;

    //% 15. HP gap *
    xHP + LAMHP*( xHP(-2) - 4*xHP(-1) + 6*xHP - 4*xHP(+1) + xHP(+2) ) 
    = LAMHP*( -dy(-1) + 3*dy - 3*dy(+1) + dy(+2) );

    //% 16. Natural Output *
    (OMEGA+VARFI*(1+BETA*ETA^2))*yn - VARFI*ETA*yn(-1) - 
        VARFI*BETA*ETA*yn(+1) = VARFI*zeg-zeh-VARFI*ETA*(zez-BETA*zez(+1)) ;

    //%17 dy
    dy = y - y(-1) + zez ;

    //% 18. Productivity shock
    zez = RHOZ*zez(-1) + (SIGMAZ/100)*ez ;

    //% 19. Demand shock
    zeg = RHOG*zeg(-1) + (SIGMAG/100)*eg ;

    //% 20. Labor supply shock
    zeh = RHOH*zeh(-1) + (SIGMAH/100)*eh ;

    //% 21. Risk-premium shock
    zeq = RHOQ*zeq(-1) + (SIGMAQ/100)*eq ;

    //% 22. MP shock
    zeR = RHOR*zeR(-1) + (SIGMAR/100)*eR ;

    //% 23. MP shock
    zeu = RHOU*zeu(-1) + (SIGMAU/100)*eu ;

    //% 24. GDP growth
    dY_o = GY + 100*(y-y(-1)+zez);

    //% 25. GDP deflator growth
    dP_o = GP + 100*pip;

    //% 26. Compensation growth
    dW_o = GP + GY + 100*piw;

    //% 27. 3 month Euribor
    R_o  = GR + 400*R;

end;

// ------------------------------------------------------------------------
// Steady-state block
// ------------------------------------------------------------------------
steady_state_model ;
    lam   = 0;
    y     = 0;
    h     = 0;
    R     = 0;
    pip   = 0;
    Kp    = 0;
    Fp    = 0;
    pstar = 0;
    w     = 0;
    piw   = 0;
    Kw    = 0;
    Fw    = 0;
    wstar = 0;
    xip   = 0;
    Rs    = 0;
    yn    = 0;
    x     = 0;
    xHP   = 0;
    zeg   = 0;
    zez   = 0;
    zeh   = 0;
    zeq   = 0;
    zeR   = 0;
    zeu   = 0;
    dY_o  = 100*MUZ;
    dP_o  = 100*PISTAR;
    dW_o  = 100*PISTAR+100*MUZ;
    R_o   = 400*((1+MUZ)*(1+PISTAR)*(1+RHO)-1);

end ;

shocks;
    var eg; stderr 1;
    var ez; stderr 1;
    var eR; stderr 1;
    var eh; stderr 1;
    var eq; stderr 1;
    var eu; stderr 1;
end;

