function [residual, g1, g2] = spswUsEstimV1_static(y, x, params)
%
% Status : Computes static model for Dynare
%
% Inputs : 
%   y         [M_.endo_nbr by 1] double    vector of endogenous variables in declaration order
%   x         [M_.exo_nbr by 1] double     vector of exogenous variables in declaration order
%   params    [M_.param_nbr by 1] double   vector of parameter values in declaration order
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the static model equations 
%                                          in order of declaration of the equations
%   g1        [M_.endo_nbr by M_.endo_nbr] double    Jacobian matrix of the static model equations;
%                                                     columns: variables in declaration order
%                                                     rows: equations in order of declaration
%   g2        [M_.endo_nbr by (M_.endo_nbr)^2] double   Hessian matrix of the static model equations;
%                                                       columns: variables in declaration order
%                                                       rows: equations in order of declaration
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

residual = zeros( 32, 1);

%
% Model equations
%

BETA__ = 1/(1+params(1));
GY__ = 100*params(9);
GP__ = 100*params(19);
GR__ = 400*((1+params(9))*(1+params(19))/BETA__-1);
VARFI__ = 1/((1-BETA__*params(2))*(1-params(2)));
OMEGAP__ = params(12)-1;
OMEGAW__ = params(12)*params(7);
OMEGA__ = OMEGAP__+OMEGAW__;
OMEGAKP__ = BETA__*params(13)*(1+params(19))^(params(12)*(1-params(5))*params(10));
OMEGAFP__ = BETA__*params(13)*(1+params(19))^((1-params(5))*(params(10)-1));
OMEGAKW__ = BETA__*params(14)*(exp(params(9)*(1-params(8)))*(1+params(19))^(1-params(6)))^((1+params(7))*params(11));
OMEGAFW__ = BETA__*params(14)*(exp(params(9)*(1-params(8)))*(1+params(19))^(1-params(6)))^(params(11)-1);
OMEGAXI__ = params(13)*(1+params(19))^((1-params(5))*params(12)*params(10));
T89 = 1+BETA__*params(2)^2;
lhs =y(1);
rhs =y(1)+y(4)-y(5)+y(23)-y(21);
residual(1)= lhs-rhs;
lhs =y(1)*1/VARFI__;
rhs =BETA__*params(2)*y(2)-y(2)*T89+params(2)*y(2)+y(20)-params(2)*(y(21)-BETA__*y(21));
residual(2)= lhs-rhs;
lhs =(1+(params(12)-1)*params(10))*y(8);
rhs =y(6)-y(7);
residual(3)= lhs-rhs;
lhs =y(6);
rhs =(1-OMEGAKP__)*(y(1)+y(9)+params(12)*y(2)+y(25))+OMEGAKP__*(y(6)+params(12)*params(10)*(y(5)-y(5)*params(5)*params(3)));
residual(4)= lhs-rhs;
lhs =y(7);
rhs =(1-OMEGAFP__)*(y(1)+y(2))+OMEGAFP__*(y(7)+(params(10)-1)*(y(5)-y(5)*params(5)*params(3)));
residual(5)= lhs-rhs;
lhs =y(8);
rhs =(y(5)-y(5)*params(5)*params(3))*OMEGAFP__/(BETA__-OMEGAFP__);
residual(6)= lhs-rhs;
lhs =(1+params(7)*params(11))*(y(13)-y(9));
rhs =y(11)-y(12);
residual(7)= lhs-rhs;
lhs =y(11);
rhs =(1-OMEGAKW__)*((1+params(7))*y(3)+y(22))+OMEGAKW__*(y(11)+(1+params(7))*params(11)*(y(10)-y(5)*params(6)*params(4)));
residual(8)= lhs-rhs;
lhs =y(12);
rhs =(1-OMEGAFW__)*(y(1)+y(9)+y(3))+OMEGAFW__*(y(12)+(params(11)-1)*(y(10)-y(5)*params(6)*params(4)));
residual(9)= lhs-rhs;
lhs =y(13)-y(9);
rhs =(y(10)-y(5)*params(6)*params(4))*OMEGAFW__/(BETA__-OMEGAFW__);
residual(10)= lhs-rhs;
lhs =y(10);
rhs =y(5)+y(21);
residual(11)= lhs-rhs;
lhs =y(3);
rhs =params(12)*(y(2)-params(10)*y(14));
residual(12)= lhs-rhs;
lhs =y(14);
rhs =y(8)*(1-OMEGAXI__)+OMEGAXI__*(y(14)-(y(5)-y(5)*params(5)*params(3)));
residual(13)= lhs-rhs;
lhs =y(15);
rhs =y(15)*params(15)+(1-params(15))*(y(5)*params(16)+.25*params(17)*y(17))+y(24);
residual(14)= lhs-rhs;
lhs =y(4);
rhs =y(15);
residual(15)= lhs-rhs;
lhs =y(17);
rhs =y(2)-y(16);
residual(16)= lhs-rhs;
lhs =y(19)+params(34)*(y(30)+y(19)*6+y(32)-y(19)*4-y(19)*4);
rhs =params(34)*((-y(18))+y(18)*3-y(18)*3+y(31));
residual(17)= lhs-rhs;
lhs =y(16)*(OMEGA__+VARFI__*T89)-y(16)*params(2)*VARFI__-y(16)*params(2)*BETA__*VARFI__;
rhs =VARFI__*y(20)-y(22)-(y(21)-BETA__*y(21))*params(2)*VARFI__;
residual(18)= lhs-rhs;
lhs =y(18);
rhs =y(21);
residual(19)= lhs-rhs;
lhs =y(21);
rhs =y(21)*params(26)+params(20)/100*x(1);
residual(20)= lhs-rhs;
lhs =y(20);
rhs =y(20)*params(29)+params(23)/100*x(2);
residual(21)= lhs-rhs;
lhs =y(22);
rhs =y(22)*params(28)+params(22)/100*x(4);
residual(22)= lhs-rhs;
lhs =y(23);
rhs =y(23)*params(30)+params(24)/100*x(5);
residual(23)= lhs-rhs;
lhs =y(24);
rhs =y(24)*params(27)+params(21)/100*x(3);
residual(24)= lhs-rhs;
lhs =y(25);
rhs =y(25)*params(31)+params(25)/100*x(6);
residual(25)= lhs-rhs;
lhs =y(26);
rhs =GY__+100*y(21);
residual(26)= lhs-rhs;
lhs =y(27);
rhs =GP__+100*y(5);
residual(27)= lhs-rhs;
lhs =y(28);
rhs =GY__+GP__+100*y(10);
residual(28)= lhs-rhs;
lhs =y(29);
rhs =GR__+400*y(4);
residual(29)= lhs-rhs;
lhs =y(30);
rhs =y(19);
residual(30)= lhs-rhs;
lhs =y(31);
rhs =y(18);
residual(31)= lhs-rhs;
lhs =y(32);
rhs =y(19);
residual(32)= lhs-rhs;
if ~isreal(residual)
  residual = real(residual)+imag(residual).^2;
end
if nargout >= 2,
  g1 = zeros(32, 32);

  %
  % Jacobian matrix
  %

  g1(1,4)=(-1);
  g1(1,5)=1;
  g1(1,21)=1;
  g1(1,23)=(-1);
  g1(2,1)=1/VARFI__;
  g1(2,2)=(-(params(2)+BETA__*params(2)-T89));
  g1(2,20)=(-1);
  g1(2,21)=params(2)*(1-BETA__);
  g1(3,6)=(-1);
  g1(3,7)=1;
  g1(3,8)=1+(params(12)-1)*params(10);
  g1(4,1)=(-(1-OMEGAKP__));
  g1(4,2)=(-(params(12)*(1-OMEGAKP__)));
  g1(4,5)=(-(OMEGAKP__*params(12)*params(10)*(1-params(5)*params(3))));
  g1(4,6)=1-OMEGAKP__;
  g1(4,9)=(-(1-OMEGAKP__));
  g1(4,25)=(-(1-OMEGAKP__));
  g1(5,1)=(-(1-OMEGAFP__));
  g1(5,2)=(-(1-OMEGAFP__));
  g1(5,5)=(-(OMEGAFP__*(params(10)-1)*(1-params(5)*params(3))));
  g1(5,7)=1-OMEGAFP__;
  g1(6,5)=(-(OMEGAFP__/(BETA__-OMEGAFP__)*(1-params(5)*params(3))));
  g1(6,8)=1;
  g1(7,9)=(-(1+params(7)*params(11)));
  g1(7,11)=(-1);
  g1(7,12)=1;
  g1(7,13)=1+params(7)*params(11);
  g1(8,3)=(-((1+params(7))*(1-OMEGAKW__)));
  g1(8,5)=(-(OMEGAKW__*(1+params(7))*params(11)*(-(params(6)*params(4)))));
  g1(8,10)=(-((1+params(7))*params(11)*OMEGAKW__));
  g1(8,11)=1-OMEGAKW__;
  g1(8,22)=(-(1-OMEGAKW__));
  g1(9,1)=(-(1-OMEGAFW__));
  g1(9,3)=(-(1-OMEGAFW__));
  g1(9,5)=(-(OMEGAFW__*(params(11)-1)*(-(params(6)*params(4)))));
  g1(9,9)=(-(1-OMEGAFW__));
  g1(9,10)=(-((params(11)-1)*OMEGAFW__));
  g1(9,12)=1-OMEGAFW__;
  g1(10,5)=(-(OMEGAFW__/(BETA__-OMEGAFW__)*(-(params(6)*params(4)))));
  g1(10,9)=(-1);
  g1(10,10)=(-(OMEGAFW__/(BETA__-OMEGAFW__)));
  g1(10,13)=1;
  g1(11,5)=(-1);
  g1(11,10)=1;
  g1(11,21)=(-1);
  g1(12,2)=(-params(12));
  g1(12,3)=1;
  g1(12,14)=(-(params(12)*(-params(10))));
  g1(13,5)=(-(OMEGAXI__*(-(1-params(5)*params(3)))));
  g1(13,8)=(-(1-OMEGAXI__));
  g1(13,14)=1-OMEGAXI__;
  g1(14,5)=(-((1-params(15))*params(16)));
  g1(14,15)=1-params(15);
  g1(14,17)=(-((1-params(15))*.25*params(17)));
  g1(14,24)=(-1);
  g1(15,4)=1;
  g1(15,15)=(-1);
  g1(16,2)=(-1);
  g1(16,16)=1;
  g1(16,17)=1;
  g1(17,18)=params(34);
  g1(17,19)=1+params(34)*(-2);
  g1(17,30)=params(34);
  g1(17,31)=(-params(34));
  g1(17,32)=params(34);
  g1(18,16)=OMEGA__+VARFI__*T89-params(2)*VARFI__-params(2)*BETA__*VARFI__;
  g1(18,20)=(-VARFI__);
  g1(18,21)=params(2)*VARFI__*(1-BETA__);
  g1(18,22)=1;
  g1(19,18)=1;
  g1(19,21)=(-1);
  g1(20,21)=1-params(26);
  g1(21,20)=1-params(29);
  g1(22,22)=1-params(28);
  g1(23,23)=1-params(30);
  g1(24,24)=1-params(27);
  g1(25,25)=1-params(31);
  g1(26,21)=(-100);
  g1(26,26)=1;
  g1(27,5)=(-100);
  g1(27,27)=1;
  g1(28,10)=(-100);
  g1(28,28)=1;
  g1(29,4)=(-400);
  g1(29,29)=1;
  g1(30,19)=(-1);
  g1(30,30)=1;
  g1(31,18)=(-1);
  g1(31,31)=1;
  g1(32,19)=(-1);
  g1(32,32)=1;
  if ~isreal(g1)
    g1 = real(g1)+2*imag(g1);
  end
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],32,1024);
end
end
