function [residual, g1, g2, g3] = spswUsEstimV1_dynamic(y, x, params, steady_state, it_)
%
% Status : Computes dynamic model for Dynare
%
% Inputs :
%   y         [#dynamic variables by 1] double    vector of endogenous variables in the order stored
%                                                 in M_.lead_lag_incidence; see the Manual
%   x         [M_.exo_nbr by nperiods] double     matrix of exogenous variables (in declaration order)
%                                                 for all simulation periods
%   params    [M_.param_nbr by 1] double          vector of parameter values in declaration order
%   it_       scalar double                       time period for exogenous variables for which to evaluate the model
%
% Outputs:
%   residual  [M_.endo_nbr by 1] double    vector of residuals of the dynamic model equations in order of 
%                                          declaration of the equations
%   g1        [M_.endo_nbr by #dynamic variables] double    Jacobian matrix of the dynamic model equations;
%                                                           rows: equations in order of declaration
%                                                           columns: variables in order stored in M_.lead_lag_incidence
%   g2        [M_.endo_nbr by (#dynamic variables)^2] double   Hessian matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence
%   g3        [M_.endo_nbr by (#dynamic variables)^3] double   Third order derivative matrix of the dynamic model equations;
%                                                              rows: equations in order of declaration
%                                                              columns: variables in order stored in M_.lead_lag_incidence
%
%
% Warning : this file is generated automatically by Dynare
%           from model file (.mod)

%
% Model equations
%

residual = zeros(32, 1);
BETA__ = 1/(1+params(1));
GY__ = 100*params(9);
GP__ = 100*params(19);
GR__ = 400*((1+params(9))*(1+params(19))/BETA__-1);
VARFI__ = 1/((1-BETA__*params(2))*(1-params(2)));
OMEGAP__ = params(12)-1;
OMEGAW__ = params(12)*params(7);
OMEGA__ = OMEGAP__+OMEGAW__;
OMEGAKP__ = BETA__*params(13)*(1+params(19))^(params(12)*(1-params(5))*params(10));
OMEGAFP__ = BETA__*params(13)*(1+params(19))^((1-params(5))*(params(10)-1));
OMEGAKW__ = BETA__*params(14)*(exp(params(9)*(1-params(8)))*(1+params(19))^(1-params(6)))^((1+params(7))*params(11));
OMEGAFW__ = BETA__*params(14)*(exp(params(9)*(1-params(8)))*(1+params(19))^(1-params(6)))^(params(11)-1);
OMEGAXI__ = params(13)*(1+params(19))^((1-params(5))*params(12)*params(10));
T90 = 1+BETA__*params(2)^2;
lhs =y(17);
rhs =y(49)+y(20)-y(51)+y(39)-y(60);
residual(1)= lhs-rhs;
lhs =y(17)*1/VARFI__;
rhs =BETA__*params(2)*y(50)-T90*y(18)+params(2)*y(1)+y(36)-params(2)*(y(37)-BETA__*y(60));
residual(2)= lhs-rhs;
lhs =(1+(params(12)-1)*params(10))*y(24);
rhs =y(22)-y(23);
residual(3)= lhs-rhs;
lhs =y(22);
rhs =(1-OMEGAKP__)*(y(17)+y(25)+params(12)*y(18)+y(41))+OMEGAKP__*(y(52)+params(12)*params(10)*(y(51)-params(5)*params(3)*y(21)));
residual(4)= lhs-rhs;
lhs =y(23);
rhs =(1-OMEGAFP__)*(y(17)+y(18))+OMEGAFP__*(y(53)+(params(10)-1)*(y(51)-params(5)*params(3)*y(21)));
residual(5)= lhs-rhs;
lhs =y(24);
rhs =OMEGAFP__/(BETA__-OMEGAFP__)*(y(21)-params(5)*params(3)*y(2));
residual(6)= lhs-rhs;
lhs =(1+params(7)*params(11))*(y(29)-y(25));
rhs =y(27)-y(28);
residual(7)= lhs-rhs;
lhs =y(27);
rhs =(1-OMEGAKW__)*((1+params(7))*y(19)+y(38))+OMEGAKW__*(y(55)+(1+params(7))*params(11)*(y(54)-y(21)*params(6)*params(4)));
residual(8)= lhs-rhs;
lhs =y(28);
rhs =(1-OMEGAFW__)*(y(17)+y(25)+y(19))+OMEGAFW__*(y(56)+(params(11)-1)*(y(54)-y(21)*params(6)*params(4)));
residual(9)= lhs-rhs;
lhs =y(29)-y(25);
rhs =OMEGAFW__/(BETA__-OMEGAFW__)*(y(26)-y(2)*params(6)*params(4));
residual(10)= lhs-rhs;
lhs =y(26);
rhs =y(37)+y(21)+y(25)-y(3);
residual(11)= lhs-rhs;
lhs =y(19);
rhs =params(12)*(y(18)-params(10)*y(30));
residual(12)= lhs-rhs;
lhs =y(30);
rhs =y(24)*(1-OMEGAXI__)+OMEGAXI__*(y(4)-(y(21)-params(5)*params(3)*y(2)));
residual(13)= lhs-rhs;
lhs =y(31);
rhs =params(15)*y(5)+(1-params(15))*(y(21)*params(16)+.25*params(17)*y(33)+.25*params(18)*(y(33)-y(7)))+y(40);
residual(14)= lhs-rhs;
lhs =y(20);
rhs =y(31);
residual(15)= lhs-rhs;
lhs =y(33);
rhs =y(18)-y(32);
residual(16)= lhs-rhs;
lhs =y(35)+params(34)*(y(61)+y(35)*6+y(16)-4*y(9)-4*y(59));
rhs =params(34)*((-y(8))+3*y(34)-3*y(58)+y(62));
residual(17)= lhs-rhs;
lhs =y(32)*(OMEGA__+VARFI__*T90)-params(2)*VARFI__*y(6)-params(2)*BETA__*VARFI__*y(57);
rhs =VARFI__*y(36)-y(38)-(y(37)-BETA__*y(60))*params(2)*VARFI__;
residual(18)= lhs-rhs;
lhs =y(34);
rhs =y(37)+y(18)-y(1);
residual(19)= lhs-rhs;
lhs =y(37);
rhs =params(26)*y(11)+params(20)/100*x(it_, 1);
residual(20)= lhs-rhs;
lhs =y(36);
rhs =params(29)*y(10)+params(23)/100*x(it_, 2);
residual(21)= lhs-rhs;
lhs =y(38);
rhs =params(28)*y(12)+params(22)/100*x(it_, 4);
residual(22)= lhs-rhs;
lhs =y(39);
rhs =params(30)*y(13)+params(24)/100*x(it_, 5);
residual(23)= lhs-rhs;
lhs =y(40);
rhs =params(27)*y(14)+params(21)/100*x(it_, 3);
residual(24)= lhs-rhs;
lhs =y(41);
rhs =params(31)*y(15)+params(25)/100*x(it_, 6);
residual(25)= lhs-rhs;
lhs =y(42);
rhs =GY__+100*(y(37)+y(18)-y(1));
residual(26)= lhs-rhs;
lhs =y(43);
rhs =GP__+100*y(21);
residual(27)= lhs-rhs;
lhs =y(44);
rhs =GY__+GP__+100*y(26);
residual(28)= lhs-rhs;
lhs =y(45);
rhs =GR__+400*y(20);
residual(29)= lhs-rhs;
lhs =y(46);
rhs =y(59);
residual(30)= lhs-rhs;
lhs =y(47);
rhs =y(58);
residual(31)= lhs-rhs;
lhs =y(48);
rhs =y(9);
residual(32)= lhs-rhs;
if nargout >= 2,
  g1 = zeros(32, 68);

  %
  % Jacobian matrix
  %

  g1(1,17)=1;
  g1(1,49)=(-1);
  g1(1,20)=(-1);
  g1(1,51)=1;
  g1(1,60)=1;
  g1(1,39)=(-1);
  g1(2,17)=1/VARFI__;
  g1(2,1)=(-params(2));
  g1(2,18)=T90;
  g1(2,50)=(-(BETA__*params(2)));
  g1(2,36)=(-1);
  g1(2,37)=params(2);
  g1(2,60)=params(2)*(-BETA__);
  g1(3,22)=(-1);
  g1(3,23)=1;
  g1(3,24)=1+(params(12)-1)*params(10);
  g1(4,17)=(-(1-OMEGAKP__));
  g1(4,18)=(-(params(12)*(1-OMEGAKP__)));
  g1(4,21)=(-(OMEGAKP__*params(12)*params(10)*(-(params(5)*params(3)))));
  g1(4,51)=(-(params(12)*params(10)*OMEGAKP__));
  g1(4,22)=1;
  g1(4,52)=(-OMEGAKP__);
  g1(4,25)=(-(1-OMEGAKP__));
  g1(4,41)=(-(1-OMEGAKP__));
  g1(5,17)=(-(1-OMEGAFP__));
  g1(5,18)=(-(1-OMEGAFP__));
  g1(5,21)=(-(OMEGAFP__*(params(10)-1)*(-(params(5)*params(3)))));
  g1(5,51)=(-((params(10)-1)*OMEGAFP__));
  g1(5,23)=1;
  g1(5,53)=(-OMEGAFP__);
  g1(6,2)=(-(OMEGAFP__/(BETA__-OMEGAFP__)*(-(params(5)*params(3)))));
  g1(6,21)=(-(OMEGAFP__/(BETA__-OMEGAFP__)));
  g1(6,24)=1;
  g1(7,25)=(-(1+params(7)*params(11)));
  g1(7,27)=(-1);
  g1(7,28)=1;
  g1(7,29)=1+params(7)*params(11);
  g1(8,19)=(-((1+params(7))*(1-OMEGAKW__)));
  g1(8,21)=(-(OMEGAKW__*(1+params(7))*params(11)*(-(params(6)*params(4)))));
  g1(8,54)=(-((1+params(7))*params(11)*OMEGAKW__));
  g1(8,27)=1;
  g1(8,55)=(-OMEGAKW__);
  g1(8,38)=(-(1-OMEGAKW__));
  g1(9,17)=(-(1-OMEGAFW__));
  g1(9,19)=(-(1-OMEGAFW__));
  g1(9,21)=(-(OMEGAFW__*(params(11)-1)*(-(params(6)*params(4)))));
  g1(9,25)=(-(1-OMEGAFW__));
  g1(9,54)=(-((params(11)-1)*OMEGAFW__));
  g1(9,28)=1;
  g1(9,56)=(-OMEGAFW__);
  g1(10,2)=(-(OMEGAFW__/(BETA__-OMEGAFW__)*(-(params(6)*params(4)))));
  g1(10,25)=(-1);
  g1(10,26)=(-(OMEGAFW__/(BETA__-OMEGAFW__)));
  g1(10,29)=1;
  g1(11,21)=(-1);
  g1(11,3)=1;
  g1(11,25)=(-1);
  g1(11,26)=1;
  g1(11,37)=(-1);
  g1(12,18)=(-params(12));
  g1(12,19)=1;
  g1(12,30)=(-(params(12)*(-params(10))));
  g1(13,2)=(-(params(5)*params(3)*OMEGAXI__));
  g1(13,21)=OMEGAXI__;
  g1(13,24)=(-(1-OMEGAXI__));
  g1(13,4)=(-OMEGAXI__);
  g1(13,30)=1;
  g1(14,21)=(-((1-params(15))*params(16)));
  g1(14,5)=(-params(15));
  g1(14,31)=1;
  g1(14,7)=(-((1-params(15))*(-(.25*params(18)))));
  g1(14,33)=(-((1-params(15))*(.25*params(17)+.25*params(18))));
  g1(14,40)=(-1);
  g1(15,20)=1;
  g1(15,31)=(-1);
  g1(16,18)=(-1);
  g1(16,32)=1;
  g1(16,33)=1;
  g1(17,8)=params(34);
  g1(17,34)=(-(params(34)*3));
  g1(17,58)=(-(params(34)*(-3)));
  g1(17,9)=params(34)*(-4);
  g1(17,35)=1+params(34)*6;
  g1(17,59)=params(34)*(-4);
  g1(17,61)=params(34);
  g1(17,62)=(-params(34));
  g1(17,16)=params(34);
  g1(18,6)=(-(params(2)*VARFI__));
  g1(18,32)=OMEGA__+VARFI__*T90;
  g1(18,57)=(-(params(2)*BETA__*VARFI__));
  g1(18,36)=(-VARFI__);
  g1(18,37)=params(2)*VARFI__;
  g1(18,60)=params(2)*VARFI__*(-BETA__);
  g1(18,38)=1;
  g1(19,1)=1;
  g1(19,18)=(-1);
  g1(19,34)=1;
  g1(19,37)=(-1);
  g1(20,11)=(-params(26));
  g1(20,37)=1;
  g1(20,63)=(-(params(20)/100));
  g1(21,10)=(-params(29));
  g1(21,36)=1;
  g1(21,64)=(-(params(23)/100));
  g1(22,12)=(-params(28));
  g1(22,38)=1;
  g1(22,66)=(-(params(22)/100));
  g1(23,13)=(-params(30));
  g1(23,39)=1;
  g1(23,67)=(-(params(24)/100));
  g1(24,14)=(-params(27));
  g1(24,40)=1;
  g1(24,65)=(-(params(21)/100));
  g1(25,15)=(-params(31));
  g1(25,41)=1;
  g1(25,68)=(-(params(25)/100));
  g1(26,1)=100;
  g1(26,18)=(-100);
  g1(26,37)=(-100);
  g1(26,42)=1;
  g1(27,21)=(-100);
  g1(27,43)=1;
  g1(28,26)=(-100);
  g1(28,44)=1;
  g1(29,20)=(-400);
  g1(29,45)=1;
  g1(30,59)=(-1);
  g1(30,46)=1;
  g1(31,58)=(-1);
  g1(31,47)=1;
  g1(32,9)=(-1);
  g1(32,48)=1;
end
if nargout >= 3,
  %
  % Hessian matrix
  %

  g2 = sparse([],[],[],32,4624);
end
if nargout >= 4,
  %
  % Third order derivatives
  %

  g3 = sparse([],[],[],32,314432);
end
end
