addpath ../UTILITIES/
addpath ../DATA

// ------------------------------------------------------------------------
// Load the model
// ------------------------------------------------------------------------
@#include "../MODEL/spswtiModel.mod"
@#include "../COMFILES/dummyCalibration.m"




// ---> Observable declaration
// ------------------------------------------------------------------------
varobs dY_o dP_o dW_o R_o;

// ---> Estimated parameter block
// ------------------------------------------------------------------------
estimated_params;
RHO,        normal_pdf,    0.0020, 0.0005; 
MUZ,        normal_pdf,    0.0044, 0.0005;
PISTAR,     normal_pdf,    0.0061, 0.0005; 
ALPHAP,     beta_pdf,      0.6600, 0.0500; 
ALPHAW,     beta_pdf,      0.6600, 0.0500; 
GAMMAP,     beta_pdf,      0.5000, 0.1500; 
GAMMAW,     beta_pdf,      0.5000, 0.1500; 
GAMMAZ,     beta_pdf,      0.5000, 0.1500; 
ETA,        beta_pdf,      0.7000, 0.1500; 
NU,         gamma_pdf,     1.0000, 0.2000;
FIP,        gamma_pdf,     2.0000, 0.1500;
FIX,        gamma_pdf,     0.5000, 0.0500;
FIR,        beta_pdf,      0.8500, 0.1000; 
SIGMAZ,     inv_gamma_pdf, 0.2500, 1.0000; 
SIGMAR,     inv_gamma_pdf, 0.2500, 1.0000;  
SIGMAQ,     inv_gamma_pdf, 0.2500, 1.0000;  
SIGMAG,     inv_gamma_pdf, 0.2500, 1.0000; 
SIGMAU,     inv_gamma_pdf, 0.2500, 1.0000; 
RHOR,       beta_pdf,      0.2500, 0.1000; 
RHOZ,       beta_pdf,      0.2500, 0.1000; 
RHOG,       beta_pdf,      0.8500, 0.1000;  
RHOQ,       beta_pdf,      0.8500, 0.1000; 
RHOU,       beta_pdf,      0.8000, 0.1000; 
end;

estimated_params_init; 
RHO   , 	 0.0019528567114841663000000; 
ALPHAP, 	 0.6136609974157449800000000; 
ALPHAW, 	 0.4236580023025521300000000; 
GAMMAP, 	 0.1952547819687717200000000; 
GAMMAW, 	 0.2266992206485199400000000; 
GAMMAZ, 	 0.2211908141325319400000000; 
ETA   , 	 0.7568343193061120000000000; 
NU    , 	 0.5478366840394576200000000; 
FIP   , 	 1.7777345482192770000000000; 
FIX   , 	 0.4957566920692496000000000; 
FIR   , 	 0.7300814813119139700000000; 
MUZ   , 	 0.0042827083218549200000000; 
PISTAR, 	 0.0060504928412428698000000; 
SIGMAZ, 	 0.9074125012409262100000000; 
SIGMAR, 	 0.1453446232541957300000000; 
SIGMAQ, 	 0.4819528075627691500000000; 
SIGMAG, 	 0.2655192769614980700000000; 
SIGMAU, 	 0.4450822044228310300000000; 
RHOR  , 	 0.6413965760361590700000000;
RHOG  ,      0.95; 
RHOZ  , 	 0.1631744799287090900000000; 
RHOQ  , 	 0.7641063241386797400000000; 
RHOU  , 	 0.4898992374429671500000000; 
end; 

// --------------------------------------------------------------------
// Estimate model
// --------------------------------------------------------------------
estimation(datafile=estimationUSData,first_obs=1,nobs=95,order=1,
mh_replic=1000000,mh_nblocks=1,mh_jscale=0.4,mh_drop=0.25,prior_trunc=0,
plot_priors=0);


