% dummyCalibration.m
%
% Script that should not be changed a priori (or at least with great care);
% It sets parameter values for initialization purpose


% ------------------------------------------------------------------------
% First, load the data to calibrate some parameters
% ------------------------------------------------------------------------
addpath ../DATA
sdate = 1985.00 ;
fdate = 2008.50 ;
xx    = computeEstimationMeans( sdate,fdate ) ;
% ------------------------------------------------------------------------
% Dummy calibration. Part #1: Pseudo-Estimation Constants
% (need not be the actual one used in simulations)
% ------------------------------------------------------------------------
GY0   = xx(1) ;
GP0   = xx(2) ;
GW0   = xx(3) ;
GR0   = xx(4) ;
GW    = GW0;

% ------------------------------------------------------------------------
% Dummy calibration. Part #2: Structural Parameters
% (need not be the actual one used in simulations)
% ------------------------------------------------------------------------
PHI    = 1/0.7; 
MUZ    = GY0/100;
PISTAR = GP0/100;
RBAR   = GR0/400;
BETA0  = (1+MUZ)*(1+PISTAR)/(1+RBAR);
RHO    = 1/BETA0-1;
ETA    = 0.70;
IOTAP  = 1.00;
IOTAW  = 1.00;
GAMMAP = 0.50;
GAMMAW = 0.50;
GAMMAZ = 0.50;
ALPHAP = 0.65;
ALPHAW = 0.65;
THETAP = 6.00;
THETAW = 3.00;
NU     = 2.0;
FIP    = 2.0;
FIX    = 0.00/4;
FIY    = 0.00/4;
FIR    = 0.50;
ELBBAR = 0.00;
LAMHP  = 1600;


% ------------------------------------------------------------------------
% Dummy calibration. Part #3: Shocks 
% ------------------------------------------------------------------------
SIGMAH =  	 0.00; 
RHOH   =  	 0.00; 
SIGMAR =  	 0.00; 
RHOR   =  	 0.00; 
RHOG   =  	 0.00;
SIGMAG =  	 0.00; 
SIGMAZ =  	 0.00; 
SIGMAQ =  	 0.00; 
SIGMAU =  	 0.00; 
RHOZ   =  	 0.00; 
RHOQ   =  	 0.00; 
RHOU   =  	 0.00; 
