 function vcPlotDistBands(X,varargin)

%function vcPlotDistBands(X,initial_date,end_date,FrancisRameydataset,add,subtract)


% vcPlotDistBands
%
% Plots median and percentile bands for matrix X.
%
% Usage: 
%   vcPlotDistBands(X)
%   vcPlotDistBands(...,OptionName,OptionValue,...)
%
% Required input argument:
%
%   X
%   Matrix containing data.
%
% Options:
%
%   Dim
%   Dimension along which percentiles are computed.
%   Default: 1
%
%   Bands2Show
%   Percent intervals to be shown in the plots, centered around median.
%   Default: [50,60,70,80,90]
%
%   MedianColor
%   Color of median line.
%   Default: [0,0,0.7]
%
%   ShadeColor
%   Base color for bands.
%   Default: [0.2,0.6,0.5]
%
%   LineWidth
%   Width of median line.
%   Default: 1.5
%
%   isZeroLine
%   If 1 plots the zero line. If 0 it does not plot a zero line.
%   Default: 1
%
%   ZeroLineColor
%   Color for the zero line.
%   Default: 'k'
%
%   ZeroLineStyle
%   Style for the zero line.
%   Default: ':'
%
% .........................................................................
% 
% Created: October 30, 2008
% by Vasco Curdia

%% ------------------------------------------------------------------------

%% default options
Dim = 1;
Bands2Show = [50,60,70,80,95];
%Bands2Show = [50,60,70];
MedianColor = [0,0,0.7];
ShadeColor = [0.2,0.6,0.5];
LineWidth = 1.5;
isZeroLine = 0;
ZeroLineColor = 'k';
ZeroLineStyle = ':';

%% Check options
% if ~isempty(varargin)
%     nOptions = length(varargin);
%     if mod(nOptions,2), error('Incorrect number of optional arguments.'), end
%     for jO=1:nOptions/2
%         eval(sprintf('%s = varargin{%.0f};',varargin{(jO-1)*2+1},jO*2))
%     end
% end

%% get dimensions
if Dim==2, X = X'; end
T = size(X,2);
tid = 1:T;
%tid = FrancisRameydataset.sample_growth(initial_date+add:end_date-subtract);

%% Plot bands
Bands2Show = sort(Bands2Show,'descend');
nBands = length(Bands2Show);
InitHold = ishold;
for jB=1:nBands
    %Band = Bands2Show(jB);
    Band = Bands2Show(1);
    BandPath = prctile(X,50+Band/2*[-1,+1]);
    BandColor = ShadeColor+(1-ShadeColor)*(-0.5+(0.7-(-0.5))*Band/100);
    fill([tid,tid(end:-1:1)],[BandPath(1,:),BandPath(2,end:-1:1)],BandColor,'EdgeColor',BandColor)
    hold on
end
if isZeroLine
    plot(tid,zeros(1,T),ZeroLineStyle,'Color',ZeroLineColor);
end
%plot(tid,prctile(X,50),'Color',MedianColor,'LineWidth',LineWidth);
% if ~InitHold
%     hold off
% end
%xlim([1,T])

%% ------------------------------------------------------------------------
