function [] = plotVarShare(var_shares_obs,var_shares_s , vrbs_obs , vrbs,shocks,list_vrbs_obs,list_vrbs,namesVrbs_obs,namesVrbs,nonzeroshock_ind,Shock_groups,groupNames,list_periods )
%function [] = plotVarShare(var_shares_obs,var_shares_s , vrbs_obs , vrbs,shocks,namesVrbs_obs,namesVrbs,nonzeroshock_ind )

%This function creates a series of stacked bar graphs where:
%   - each graph corresponds to a different observable
%   - each x-axis corresponds to the number of periods after initial period
%   - each 'stack' in the bar  corresponds to a different shock.


% Recall the dimensions of var_shares are: 
%   var_shares = NaN( ny , nsim , nshocks );
%namesShocks = fieldnames(shocks);

% namesVrbs_obs=fieldnames(vrbs_obs); %% COMMENT: THE LIST DOES NOT CORRESPOND TO THE NUMBERING -- see defineObservables
% namesVrbs=fieldnames(vrbs);

% to fix this: dd1=vrbs_obs.(namesVrbs{dd})
% nlist_s = length(namesVrbs);
% nlist_obs = length(namesVrbs_obs);
% list_vrbs = [];
%  for list = 1:nlist_s
%   list_vrbs = [list_vrbs,vrbs.(namesVrbs{list})];
%  end
%   
%  list_vrbs_obs = [];
%  for list = 1:nlist_obs
%   list_vrbs_obs = [list_vrbs_obs,vrbs_obs.(namesVrbs_obs{list})];
%  end



% ny = size(namesVrbs,1);
% y = NaN(ny,1);
%list_vrbs = [1,5,7]; % Identify the observables you want to graph.
%list_periods = [1,2,4,10,40,100]; % Identify the periods ahead you want to graph.
ny = size(list_vrbs,2);
ii=0;

for dd = list_vrbs; %iterate through y_observations
    figure;
    
    %dd1=vrbs.(namesVrbs{dd});
    for_graph = []; % This is an intermediate variable we use to concatenate the shares.
    ii = ii+1;
    %ax = subplot(ny,1,ii);

   %tt = squeeze(var_shares_s(dd,:,nonzeroshock_ind)) ; % isolate the shares for a single observable
   
   tt = squeeze(var_shares_s(dd,:,:)) ; % isolate the shares for a single observable
   for vv =  list_periods;
        ss = tt(vv,:); % isolate the time index for the desired time indexes.
        for_graph = [for_graph ; ss];
   end
    
    y = bar(for_graph,'stacked');  
   % legend(y,[namesShocks(nonzeroshock_ind)]','Location','bestoutside') ;
   legend(y,[groupNames]','Location','bestoutside') ;
    title([namesVrbs(ii),'Variance Decompostion']);
    xlabel('Time Period');
    perlabel = [ repmat('Q',size(list_periods,2),1) , num2str(list_periods')]; %This builds the legend as 'Q' + time period.
   set(gca,'XTickLabel',{perlabel});
   ylim([0 1]);
  %hold on
  
end


%% Observables
ny = size(list_vrbs_obs,2);
ii=0;
for dd = list_vrbs_obs; %iterate through y_observations
   figure;
    %dd1=vrbs_obs.(namesVrbs_obs{dd});
    for_graph = []; % This is an intermediate variable we use to concatenate the shares.
    ii = ii+1;
    %ax = subplot(ny,1,ii);
   

%    tt = squeeze(var_shares_obs(dd,:,nonzeroshock_ind)) ; % isolate the shares for a single observable
     tt = squeeze(var_shares_obs(dd,:,:)) ; % isolate the shares for a single observable
    
   for vv =  list_periods;
        ss = tt(vv,:); % isolate the time index for the desired time indexes.
        for_graph = [for_graph ; ss];
   end
    
    y = bar(for_graph,'stacked');  
   % legend(y,[namesShocks(nonzeroshock_ind)]','Location','bestoutside') ;
   legend(y,[groupNames]','Location','bestoutside') ;
    title([namesVrbs_obs(ii),'Variance Decompostion']);
    xlabel('Time Period');
    perlabel = [ repmat('Q',size(list_periods,2),1) , num2str(list_periods')]; %This builds the legend as 'Q' + time period.
   set(gca,'XTickLabel',{perlabel});
   ylim([0 1]);
 % hold on
  
end


end

