function [] = plotShocks1( statesDec_mat , obsDec_mat,DmY, xi_TT_mat,list_vrbs_obs,list_vrbs,namesVrbs_obs,namesVrbs,groupNames)
                            

% This function creates a figure containing a series of graphs (one for 
% each observable) where each individual graph contains stacked bars that
% reflect the contribution of each shock toward the overall path of the
% observable. Superimposed on each graph is a line that contains the 
% smoothed path of the observable.


%% States

 ii = 0;
 %figure;

for dd = list_vrbs; %iterate through y_observations
    figure;
    ii = ii+1;
    %ax = subplot(ny,1,ii);

    tt = [squeeze(statesDec_mat(dd,:,:))] ; % isolate the shock-path for a single observable, concatenate natural evolution transposed.s
  
    y = bar(1964.25:1/4:2008.5,tt,'grouped');  
     legend(y,['Initial conds.',[groupNames]' ],'Location','bestoutside') ;
    title([namesVrbs(ii),'Smoothed Shock Decompostion']);
    xlabel('Time Period');
    ylabel([namesVrbs(ii)])
    hold on
    plot(1964.25:1/4:2008.5,xi_TT_mat(dd,:),'LineWidth',2);
    hold on
  
end


%% Observables

 ii = 0;
 %figure;

 for dd = list_vrbs_obs; %iterate through y_observations
     figure;
     ii = ii+1;
     %ax = subplot(ny,1,ii);
 
    tt = [squeeze(obsDec_mat(dd,:,:))] ; % isolate the shock-path for a single observable, concatenate natural evolution transposed.s
  
    y = bar(1964.25:1/4:2008.5,tt,'grouped');  
     legend(y,['Initial conds.',[groupNames]' ],'Location','bestoutside') ;
    title([namesVrbs_obs(ii),'Smoothed Shock Decompostion']);
    xlabel('Time Period');
    ylabel([namesVrbs_obs(ii)])
    hold on
    plot(1964.25:1/4:2008.5,DmY(dd,:),'LineWidth',2);
    hold on
  
end




    
end

