

function  [HPvar_share_obs, HPvar_share_s] = HPvdecomp_fun(Mspec,params,params_index,vrbs,vrbs_obs,shocks,...
               ModelDim,shocks_oe,type,learning,Sml,nsim,list_vrbs_obs,...
               list_vrbs,list_periods,Shock_groups) 


[T_Z,T_epsilon,D,F,G,H,flag_solve] = solveModelv1(Mspec,params,params_index,vrbs,shocks,ModelDim,type,learning,Sml);

[F_m,Sc_m,Q_m] = eval(['add_to_StateSpace',Mspec,'(vrbs,params,params_index,T_Z,T_epsilon,ModelDim.nlag,ModelDim.noe,shocks_oe,learning,Sml)']);

[H_m,M,R] = eval(['getMeasurementEquation',Mspec,'(vrbs, vrbs_obs, params,params_index, ModelDim,learning,Sml)']);


bigT = 200; % length of simulation

replications = 1000;

nonstavrbs = [vrbs_obs.GDP,vrbs_obs.Wage,vrbs_obs.C,vrbs_obs.I];
dettrendvec = ones(length(nonstavrbs),1)*log((params(params_index.gammaT)/100+1));

% Define variance matrices
var_share_obs = NaN(size(H_m,2),size(Shock_groups,1));
var_share_s = NaN(size(Sc_m,1),size(Shock_groups,1));

HPvar_share_obsrp = NaN(size(H_m,2),size(Shock_groups,1),replications);
HPvar_share_srp = NaN(size(Sc_m,1),size(Shock_groups,1),replications);


% Variance decomposition (exclude observation shocks)
Sc_m_s = Sc_m(:,1:end-ModelDim.noe);

SIG_eps = eye(ModelDim.nshock); %define standard deviation identity matrix


for rp = 1:replications
    
    %disp(h)
epsZ = randn(ModelDim.nshock,bigT);


Y_sim_s = NaN(size(F_m,1),bigT,length(ModelDim.nshock)+1);
Y_sim_obs = NaN(size(H_m,2),bigT,length(ModelDim.nshock)+1);

Y_sim_nonstat = NaN(length(nonstavrbs),bigT,length(ModelDim.nshock)+1);


% Model simulation including all shocks

Y_var = zeros(size(F_m,2),bigT);
Y_sim_nonstat(:,1,1) = zeros(length(nonstavrbs),1) + dettrendvec;
 

for j = 2:bigT
    
    
    Y_var(:,j) = F_m*Y_var(:,j-1)+Sc_m_s*epsZ(:,j);
    Y_sim_nonstat(:,j,1) = H_m(:,nonstavrbs)'*Y_var(:,j) + Y_sim_nonstat(:,j-1,1) + dettrendvec;
    
end


Y_sim_s(:,:,1) = Y_var; % this series includes all shocks
Y_sim_obs(:,:,1) = H_m'*Y_var;


% Model simulation including individual shocks


for hh = 1:size(Shock_groups,1)
    
    
    SIG_eps_s_s = zeros(ModelDim.nshock);
        
    SIG_eps_s_s(Shock_groups{hh},Shock_groups{hh}) = SIG_eps(Shock_groups{hh},Shock_groups{hh});
    
    Y_sim_nonstat(:,1,hh+1) = zeros(length(nonstavrbs),1) + dettrendvec;
        
    for jj = 2:bigT
        
       
        Y_var(:,jj) = F_m*Y_var(:,jj-1)+Sc_m_s*SIG_eps_s_s*epsZ(:,jj);
        Y_sim_nonstat(:,jj,hh+1) = H_m(:,nonstavrbs)'*Y_var(:,jj) + Y_sim_nonstat(:,jj-1,hh+1) + dettrendvec;
        
    end
    
    Y_sim_s(:,:,hh+1) = Y_var;
    Y_sim_obs(:,:,hh+1) = H_m'*Y_var;

    
end

 
 
% Vector of observed variables, after substituting for nonstationary
% variables instead of growth rates

Y_sim_obs(nonstavrbs,:,:) = Y_sim_nonstat;

% HP-detrending

Y_sim_obsHP = NaN(size(Y_sim_obs));

Y_sim_sHP = NaN(size(Y_sim_s));


 % all shocks
 
 [hp_trend,~] = hpfilter(squeeze(Y_sim_obs(:,:,1))',1600);
     
Y_sim_obsHP(:,:,1) = squeeze(Y_sim_obs(:,:,1)) - hp_trend';    

 [hp_trend,~] = hpfilter(squeeze(Y_sim_s(:,:,1))',1600);

Y_sim_sHP(:,:,1) = squeeze(Y_sim_s(:,:,1)) - hp_trend';    
  
 
 
 % individual shocks

for hp = 1:size(Shock_groups,1)

[hp_trend,~] = hpfilter(squeeze(Y_sim_obs(:,:,hp+1))',1600);
     
Y_sim_obsHP(:,:,hp+1) = squeeze(Y_sim_obs(:,:,hp+1)) - hp_trend';    

var_share_obs(:,hp) = var(Y_sim_obsHP(:,:,hp+1),0,2)./var(Y_sim_obsHP(:,:,1),0,2);


[hp_trend,~] = hpfilter(squeeze(Y_sim_s(:,:,hp+1))',1600);
     
Y_sim_sHP(:,:,hp+1) = squeeze(Y_sim_s(:,:,hp+1)) - hp_trend';    

var_share_s(:,hp) = var(Y_sim_sHP(:,:,hp+1),0,2)./var(Y_sim_sHP(:,:,1),0,2);

end    
    

HPvar_share_obsrp(:,:,rp) = var_share_obs;

HPvar_share_srp(:,:,rp) = var_share_s;

end


HPvar_share_obs = mean(HPvar_share_obsrp,3); % median? 

HPvar_share_s = mean(HPvar_share_srp,3);






 
               
