
%% Fihgures for the Latest draft of the Brookings paper (April 7, 2019)

select_draws = 0;

if select_draws
 
   % loads full result from estimation 
load PriceOnly 

    %% Save for slides figures

n_draws_swl = 5000;
samplot = 1960.0:1/4:2018.5;
drawsel = randperm(size(ubar_full,2)); 
drawsels = drawsel(1:n_draws_swl);
X_draws_fulls = X_draws_full(:,drawsels);
ubar_fulls = ubar_full(:,drawsels);
ustar_fulls = ustar_full(:,drawsels);
gap = squeeze(xi_TT_full(vrbs.x,drawsels,:));
Y_pred_fulls = Y_pred_full(:,drawsels,:);
ltexpoe = squeeze(xi_TT_full(vrbs.oe_pi510Y_pi,drawsels,:));
unempl = Y_main(:,1);
save UstarPriceOnly X_draws_fulls ubar_fulls Y_pred_fulls ustar_fulls gap unempl ltexpoe samplot

end

%save UstarPriceOnly ubar_fulls ustar_fulls gap unempl samplot

% Loads 5000 draws (out of 100000) saved for the plots

load UstarPriceOnly ubar_fulls Y_pred_fulls ustar_fulls gap unempl ltexpoe samplot

% 1. ustar figure
for jj = 1:size(ubar_fulls,1);ubar(:,jj)=prctile(ubar_fulls(jj,:),[95,50,5]);end
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])
vcPlotDistBands3(ustar_fulls',samplot); 
hold on
h2 = plot(samplot,Y_main(:,1),'k-');
plot(1960:1/4:2018.5,ubar(2,:),'r-','LineWidth',2);
xlim([1960 2018.5])
ylim([3 11])

% uncomment to save
% ng = 'u_bar';
% namesinglefig_eps = [char(strcat(ng,'.eps'))];
% namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
% print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
% print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);


 % 2b u-u*
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])
vcPlotDistBands3(gap,samplot);
xlim([1960 2018.5])
ylim([-4 6])
% ng = 'u_ustarwage';
% namesinglefig_eps = [char(strcat(ng,'.eps'))];
% namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
% print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
% print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);


% 3. one-year ahead inflation expctations
load CEGSData_mat_2bis Y1
load Michexp_raw
full_sample = 1948:1/4:2018.5;
startSample = 1960;  
endSample = 2018.5; 

sampos = find(full_sample >= startSample & full_sample <= endSample);

figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])
vcPlotDistBands3(squeeze(Y_pred_fulls(vrbs_obs.exp14q_pi,:,:)),samplot);
hold on
plot(1960:1/4:2018.5,Y1(sampos,2),'r.','MarkerSize',12)
plot(1960:1/4:2018.5,Y1(sampos,1),'r.','MarkerSize',12)
plot(1960:1/4:2018.5,Mich_exps(sampos,2),'b.','MarkerSize',12)
plot(1960:1/4:2018.5,Asset_exps(sampos,1),'g--','LineWidth',1.5)
plot(1960:1/4:2018.5,Asset_exps2(sampos,1),'c--','LineWidth',1.5)
ylim([0 10.9])

% ng = 'oneyear_expswage';
% 
% namesinglefig_eps = [char(strcat(ng,'.eps'))];
% namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
% print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
% print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);
 

% 4. long-term inflation expctations
full_sample = 1948:1/4:2018.5;
  samplot = 1960.0:1/4:2018.5;
  sampos = find(full_sample >= startSample & full_sample <= endSample);
startSample = 1960;  
endSample = 2018.5; 

figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])
vcPlotDistBands3(squeeze(Y_pred_fulls(vrbs_obs.exp510y_pi,:,:))-squeeze(ltexpoe),samplot);
hold on
plot(1960:1/4:2018.5,Y_main(:,vrbs_obs.exp510y_pi),'r.','MarkerSize',12)
plot(1960:1/4:2018.5,Mich_exps(sampos,1),'b.','MarkerSize',12)
plot(1960:1/4:2018.5,Asset_exps(sampos,2),'g--','LineWidth',1.5)
plot(1960:1/4:2018.5,Asset_exps2(sampos,2),'c--','LineWidth',1.5)

% ng = 'LT_expswage';
% 
% namesinglefig_eps = [char(strcat(ng,'.eps'))];
% namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
% print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
% print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);


% 5. Selected ustar in bands
load CEGSData_mat_6 Y1
load U_Search u_search sampleu_search
load sampleri2 ustarri2
u_recr = ustarri2; clear ustarri2
u_search = [NaN(length(1948:1/4:1993.75),1);u_search;NaN(length(2015:1/4:2018.5),1)];
u_recr = [NaN(length(1948:1/4:2000.75),1);u_recr];
samplot = 1960.0:1/4:2018.5;
full_sample = 1948:1/4:2018.5;
refdate = 2006;
sel_sampl = find(full_sample >= samplot(1) & full_sample <= samplot(end));

ustarocc = Y1(sel_sampl,11)-Y1(find(full_sample==refdate),11);
ustarind  = Y1(sel_sampl,12)-Y1(find(full_sample==refdate),12);
ustareeb = Y1(sel_sampl,14)-Y1(find(full_sample==refdate),14);
ustarsi = u_search(sel_sampl)-u_search(full_sample == refdate);
ustarri = u_recr(sel_sampl)-u_recr(full_sample == refdate);

for j = 1:size(ustar_fulls,1)    
ustarn(j,:) = ustar_fulls(j,:)' - ustar_fulls(find(samplot==refdate),:)';
end

figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])

vcPlotDistBands3(ustarn',samplot); hold on
plot(samplot,median(ustarn,2),'kd')
plot(samplot,ustarocc,'b-','LineWidth',1.5)
plot(samplot,ustarind,'b--','LineWidth',1.5)
plot(samplot,ustareeb,'b-.','LineWidth',1.5)
plot(samplot,ustarsi,'r-.','LineWidth',1.5)
plot(samplot,ustarri,'r--','LineWidth',1.5)

xlim([refdate 2018.5]);
ylim([-2 2]);

%save UstarComp ustarn ustarocc ustarind ustareeb ustarsi ustarri samplot
%  
% ng = 'ustar_comp2c';
% 
% namesinglefig_eps = [char(strcat(ng,'.eps'))];
% namesinglefig_pdf = [char(strcat(ng,'.pdf'))];
% print(gcf, '-dpsc', '-r300', [namesinglefig_eps]);
% print(gcf, '-dpdf', '-r300', [namesinglefig_pdf]);


