
% Make plots
load('Pastustar.mat')
% Main
samplot = 1960.0:1/4:2017.75;
%figure
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])

vcPlotDistBands3(squeeze(xi_TT_matCk(vrbs.ustar,:,:))',samplot);
hold on
%plot(Y_main(:,1),'kd')
h1 = plot(samplot,mean(xi_TT_matCk(vrbs.ustar,:,:),3),'r-','LineWidth',2);
h2 = plot(samplot,Y_main(:,1),'k-');
%h3 = plot(samplot,mean(xi_TT_matCk(vrbs.utrend,:,:),3),'b--');
h3 = plot(samplot,past_ustar,'b','LineWidth',2);
xlim([samplot(135),samplot(end)])
%legend([h1,h2,h3],'u*','unemployment rate','utrend','Location','Best');
legend([h1,h3,h2],'u*: 2017Q4','u*: 2017Q1','unemployment rate','Location','Best');

ng = 'US_ustar_plain'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);   
    
% movements in ustar since 2005


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%



% test
samplot = 1960.0:1/4:2017.0;
pick2005 = find(samplot == 2005);

for j = 1:229
test(j,:) = squeeze(xi_TT_matCk(vrbs.ustar,j,:))' - squeeze(xi_TT_matCk(vrbs.ustar,pick2005,:))';
end
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])

vcPlotDistBands3(test',samplot);
hold on
%plot(Y_main(:,1),'kd')
h1 = plot(samplot,mean(xi_TT_matCk(vrbs.ustar,:,:),3)-4.67,'r-','LineWidth',2);
% plot(samplot,Y_main(:,1),'k-')
% plot(samplot,mean(xi_TT_matCk(vrbs.utrend,:,:),3),'b--')
%xlim([2005, 2017])

% Mismatch

mism = [0.524784982	0.301726669
0.659989993	0.28554667
0.822476665	0.267703325
0.892619987	0.277470003
0.92117999	0.261776676
0.966303329	0.248943339
0.970969995	0.248080005
1.014419993	0.240569999
1.074899991	0.247793332
1.133433342	0.261420002
1.184133371	0.282596668
1.243700027	0.324420005
1.313566685	0.370993326
1.412066658	0.418386678
1.515300035	0.486293326
1.699133317	0.647153338
1.877333323	0.843783319
2.030200044	0.996253351
2.125366688	1.048366706
2.174666643	1.049766699
2.180166721	1.007633328
2.146099965	0.941406647
2.130966663	0.897526662
2.039100011	0.847656667
1.933100025	0.781603336
1.834166646	0.735206683
1.747999986	0.674296657
1.644766649	0.624523322
1.558600028	0.57444334
1.497733315	0.545399984
1.434566657	0.507400006
1.394766688	0.460016658
1.343033314	0.434023331
1.297000011	0.407233338
1.217200001	0.364463329
1.134066661	0.326089998
1.052066684	0.307506671
0.975910008	0.300270001
0.908650001	0.283486664
0.841666659	0.27360332
0.812456667	0.285623342
0.767550011	0.29254667
0.749840001	0.29964
0.74150002	0.29622667
0.729170005	0.284423331
0.726483325	0.269689987
0.715286672	0.246809999
0.710283339	0.245933329
0.708440006	0.248460002
];

mism_occ = [NaN(length(1960.0:1/4:2004.75),1);mism(:,1)-mism(1,1)];
mism_ind = [NaN(length(1960.0:1/4:2004.75),1);mism(:,2)-mism(1,2)];

h2=plot(samplot,mism_occ,'k--','LineWidth',2);
h3=plot(samplot,mism_ind,'b--','LineWidth',2);

% plot(samplot,Y_main(:,1),'k-')
% plot(samplot,mean(xi_TT_matCk(vrbs.utrend,:,:),3),'b--')
xlim([2005, 2017])
legend([h1,h2,h3],'u*','Mismatch: occupation','Mismatch: industry','Location','Best');
ng = 'US_ustar_mism_2005'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);

    
% trend and ustar 
 samplot = 1960.0:1/4:2017.75;
%figure
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])

vcPlotDistBands3(squeeze(xi_TT_matCk(vrbs.ustar,:,:))',samplot);
hold on
%plot(Y_main(:,1),'kd')
h1 = plot(samplot,mean(xi_TT_matCk(vrbs.ustar,:,:),3),'r-','LineWidth',2);
h2 = plot(samplot,Y_main(:,1),'k-');
h3 = plot(samplot,mean(xi_TT_matCk(vrbs.utrend,:,:),3),'b--');
xlim([samplot(80),samplot(end)])
legend([h1,h2,h3],'u*','unemployment rate','utrend','Location','Best');
%legend([h1,h2],'u*','unemployment rate','Location','Best');

ng = 'US_ustar_utrend'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);      
    
 % 1-q-ahead
samplot = 1960.0:1/4:2017.0;
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])

vcPlotDistBands3(squeeze(ypred_matCk(vrbs_obs.exp1q_pi,:,:))'-...
    squeeze(xi_TT_matCk(vrbs.oe_pi1q_pi,:,:))',samplot);
hold on
%plot(Y_main(:,1),'kd')
plot(samplot,mean(ypred_matCk(vrbs_obs.exp1q_pi,:,:)-xi_TT_matCk(vrbs.oe_pi1q_pi,:,:),3),'k-','LineWidth',2)
plot(samplot,Y_main(:,vrbs_obs.exp1q_pi),'r-')
%plot(samplot,mean(xi_TT_matCk(vrbs.utrend,:,:),3),'b--')   
xlim([samplot(20),samplot(end)])

% 12-q-ahead
samplot = 1960.0:1/4:2017.75;
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])

vcPlotDistBands3(squeeze(ypred_matCk(vrbs_obs.exp12q_pi,:,:))'-...
    squeeze(xi_TT_matCk(vrbs.oe_pi12q_pi,:,:))',samplot);
hold on
%plot(Y_main(:,1),'kd')
plot(samplot,mean(ypred_matCk(vrbs_obs.exp12q_pi,:,:)-xi_TT_matCk(vrbs.oe_pi12q_pi,:,:),3),'k-','LineWidth',2)
plot(samplot,Y_main(:,vrbs_obs.exp12q_pi),'rd')
%plot(samplot,mean(xi_TT_matCk(vrbs.utrend,:,:),3),'b--')
xlim([samplot(20),samplot(end)])

% 5-10Y-ahead
samplot = 1960.0:1/4:2017.75;
figure('Units','centimeters','Position',[26.5642 14.2081 22.8167 12.1125])

vcPlotDistBands3(squeeze(ypred_matCk(vrbs_obs.exp510y_pi,:,:))',samplot);%-...
    %squeeze(xi_TT_matCk(vrbs.oe_pi510Y_pi,:,:))',samplot);
hold on
%plot(Y_main(:,1),'kd')
plot(samplot,mean(ypred_matCk(vrbs_obs.exp510y_pi,:,:)-xi_TT_matCk(vrbs.oe_pi510Y_pi,:,:),3),'k-','LineWidth',2)
plot(samplot,Y_main(:,vrbs_obs.exp510y_pi),'rd')
%plot(samplot,mean(xi_TT_matCk(vrbs.utrend,:,:),3),'b--')
xlim([samplot(50),samplot(end)])

ng = 'US_LTinflation'; 

 namesinglefig_eps = [char(strcat(ng,'.eps'))];

 namesinglefig_pdf = [char(strcat(ng,'.pdf'))];


    print(gcf, '-dpsc', '-r300', [pwd,'\',namesinglefig_eps]);
    
    print(gcf, '-dpdf', '-r300', [pwd,'\',namesinglefig_pdf]);
