

%% THIS FUNCTION COMPUTES ESTABILITY OF A MODEL DEFINED BY:


function [eig_vec_0,eig_vec_c] = Estab_funv2(A,invA0,OMEGA_c_RE,T_c_RE,T_Ls_RE,k_y,disc,c_gain) 

% NOTE: this version does not require OMEGA_0 as an inuput (it was
% redundant in the first version anyways)

%%%%%%%%%%%%%--INPUTS--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


% A,invA0: model's matrices
% REE coefficients OMEGA_0_RE, OMEGA_c_RE
% T_c_RE, T_Ls_RE: matrices generated by ALM_fun
% k_y (finite) number of forecast ahead
% disc vector of discount rates (to be used in the infinite horizon
% forecasts

% c_gain: structure:
%                   1. c_gain.cgainEstab: set == 1 for stability under
%                   constant gain (intercept only)
%                   2. c_gain.cgain: value of the gain parameter


%%%%%%%%%%%%%--OUTPUT--%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% eig_vec_0: eigenvalue corresponding to the intercept
% eig_vec_c: eigenvalue corresponding to indep. variables' coefficients


 %% First verify that marix dimensions match 

%  if size(A{1},1) ~= size(OMEGA_0_RE,1)
%      
%      disp('model not correctly specified')
%      return
%      
%  end
 
 if size(A{1},1) ~= size(OMEGA_c_RE,1)
     
     disp('model not correctly specified')
     return
     
 end

 
%% Define parameters

j_y = length(disc);
 
   
Inv_OM_RE = inv(eye(size(OMEGA_c_RE,2))-OMEGA_c_RE);

Inv_Tc_RE = inv(eye(size(T_c_RE,2))-T_c_RE);

 
    


%% Compute dT_0

dt_0 = Inv_Tc_RE*invA0*A{2}; %#ok<*MINV>



for ctn = 1:k_y
   
dt_0 = dt_0+Inv_Tc_RE*invA0*A{2+ctn}*Inv_OM_RE*...
            (eye(size(OMEGA_c_RE,2))-OMEGA_c_RE^(ctn));

end


 for ctn = 1:j_y
    
    dt_0 = dt_0+Inv_Tc_RE*invA0*A{2+k_y+ctn}*...
         (Inv_OM_RE*(eye(size(OMEGA_c_RE,2))*...
         (1-disc(ctn))^(-1)-OMEGA_c_RE*inv(eye(size(OMEGA_c_RE,2))-...
         disc(ctn)*OMEGA_c_RE)));
   
 end

 s_m = size(OMEGA_c_RE,2);
 
  %% Stability with constant gain -- in progress (COMPUTED ONLY FOR THE INTERCEPT)
if c_gain.cgainEstab == 1
    
    %eig_vec_0 = eig(c_gain.cgain*dt_0*(eye(s_m)-OMEGA_c_RE)+(1-c_gain.cgain)*eye(size(dt_0)));
    eig_vec_0 = eig(c_gain.cgain*dt_0+(1-c_gain.cgain)*eye(size(dt_0)));
    %eig_vec_0 = eig(eye(size(dt_0))+c_gain.cgain*(dt_0-eye(size(dt_0))));
    %eig_vec_0 = eig(eye(size(dt_0))+c_gain.cgain*(dt_0-eye(size(dt_0)))*(eye(s_m)-OMEGA_c_RE));%    ///c_gain.cgain*dt_0*(eye(s_m)-OMEGA_c_RE)+(1-c_gain.cgain)*eye(size(dt_0)));
    
else
    
     eig_vec_0 = eig(dt_0-eye(size(dt_0)));
    
end


 %% Compute dT_M

 
 
     
 s_m = size(OMEGA_c_RE,2);
 
 sum_M1 = zeros(s_m,s_m);
 
 Tc_inv = inv(eye(s_m)-T_c_RE);
 
 
 
 %% M1
 
 for ctn = 1:k_y
   
sum_M1 = sum_M1+Tc_inv*invA0*A{2+ctn};

 end

 
M1 = kron((Tc_inv*T_Ls_RE)',sum_M1);
 


%% M2

M2 = zeros(s_m^2,s_m^2);


for ctn = 1:j_y
    
    M2 = M2+kron((inv(eye(s_m)-disc(ctn)*OMEGA_c_RE)*Tc_inv*T_Ls_RE)',...
         Tc_inv*invA0*A{2+k_y+ctn});
    
    
end


%% M3

M3 = zeros(s_m^2,s_m^2);


for ctn = 1:j_y
    
  M3 = M3+kron((inv(eye(s_m)-disc(ctn)*OMEGA_c_RE)*Tc_inv*T_Ls_RE)',...
 Tc_inv*invA0*A{2+k_y+ctn}*OMEGA_c_RE*inv(eye(s_m)-disc(ctn)*OMEGA_c_RE)*disc(ctn));
  
end


%% M4

M4 = kron(eye(s_m),Tc_inv*invA0*A{2});


M = M1+M2+M3+M4;


eig_vec_c = eig(M-eye(s_m^2));

 

